/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiRandomGetNode
extends WasmBuiltinRootNode {
    public WasiRandomGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.randomGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int randomGet(WasmMemory memory, int buf, int size) {
        byte[] randomData = new byte[size];
        ThreadLocalRandom.current().nextBytes(randomData);
        this.memoryLib.initialize(memory, null, randomData, 0, buf, size);
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_random_get";
    }
}

