/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.BinaryParser;
import org.graalvm.wasm.MemoryContext;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.WasmContextOptions;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmScope;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;

public final class WasmContext {
    private final TruffleLanguage.Env env;
    private final WasmLanguage language;
    private final WasmContextOptions contextOptions;
    private final WasmStore contextStore;
    private final FdManager fdManager;
    private final MemoryContext memoryContext;
    private Object memGrowCallback;
    private Object memNotifyCallback;
    private Object memWaitCallback;
    private static final TruffleLanguage.ContextReference<WasmContext> REFERENCE = TruffleLanguage.ContextReference.create(WasmLanguage.class);

    public WasmContext(TruffleLanguage.Env env, WasmLanguage language) {
        this.env = env;
        this.language = language;
        this.contextOptions = WasmContextOptions.fromOptionValues(env.getOptions());
        this.fdManager = new FdManager(env);
        this.memoryContext = new MemoryContext();
        this.contextStore = new WasmStore(this, language);
    }

    public TruffleLanguage.Env environment() {
        return this.env;
    }

    public WasmLanguage language() {
        return this.language;
    }

    public WasmStore contextStore() {
        return this.contextStore;
    }

    public Object getScope() {
        return new WasmScope(this.contextStore);
    }

    public WasmModule readModule(byte[] data, ModuleLimits moduleLimits) {
        return this.readModule("Unnamed", data, moduleLimits);
    }

    public WasmModule readModule(String moduleName, byte[] data, ModuleLimits moduleLimits) {
        WasmModule module = WasmModule.create(moduleName, moduleLimits);
        BinaryParser reader = new BinaryParser(module, this, data);
        reader.readModule();
        return module;
    }

    public WasmContextOptions getContextOptions() {
        return this.contextOptions;
    }

    public static WasmContext get(Node node) {
        return (WasmContext)REFERENCE.get(node);
    }

    public void setMemGrowCallback(Object callback) {
        this.memGrowCallback = callback;
    }

    public Object getMemGrowCallback() {
        return this.memGrowCallback;
    }

    public void setMemNotifyCallback(Object callback) {
        this.memNotifyCallback = callback;
    }

    public Object getMemNotifyCallback() {
        return this.memNotifyCallback;
    }

    public void setMemWaitCallback(Object callback) {
        this.memWaitCallback = callback;
    }

    public Object getMemWaitCallback() {
        return this.memWaitCallback;
    }

    public void inheritCallbacksFromParentContext(WasmContext parent) {
        this.setMemGrowCallback(parent.getMemGrowCallback());
        this.setMemNotifyCallback(parent.getMemNotifyCallback());
        this.setMemWaitCallback(parent.getMemWaitCallback());
    }

    public MemoryContext memoryContext() {
        return this.memoryContext;
    }

    public FdManager fdManager() {
        return this.fdManager;
    }
}

