/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.wasm.GlobalRegistry;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.RuntimeState;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.api.Sequence;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmInstance
extends RuntimeState
implements TruffleObject {
    private List<LinkAction> linkActions;

    public WasmInstance(WasmStore store, WasmModule module) {
        this(store, module, module.numFunctions(), module.droppedDataInstanceOffset());
    }

    private WasmInstance(WasmStore store, WasmModule module, int numberOfFunctions, int droppedDataInstanceAddress) {
        super(store, module, numberOfFunctions, droppedDataInstanceAddress);
    }

    public String name() {
        return this.module().name();
    }

    public WasmFunctionInstance inferEntryPoint() {
        WasmFunction mainFunction = (WasmFunction)this.symbolTable().exportedFunctions().get((Object)"_main");
        if (mainFunction != null) {
            return this.functionInstance(mainFunction);
        }
        WasmFunction startFunction = (WasmFunction)this.symbolTable().exportedFunctions().get((Object)"_start");
        if (startFunction != null) {
            return this.functionInstance(startFunction);
        }
        if (this.symbolTable().startFunction() != null) {
            return this.functionInstance(this.symbolTable().startFunction());
        }
        return null;
    }

    private void ensureLinked() {
        this.store().linker().tryLink(this);
    }

    public List<LinkAction> linkActions() {
        return this.linkActions;
    }

    public List<LinkAction> createLinkActions() {
        this.linkActions = this.module().getOrRecreateLinkActions();
        return this.linkActions;
    }

    public void addLinkAction(LinkAction action) {
        this.linkActions.add(action);
    }

    public void removeLinkActions() {
        this.linkActions = null;
    }

    @Override
    protected WasmInstance instance() {
        return this;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readMember(String member) throws UnknownIdentifierException {
        this.ensureLinked();
        SymbolTable symbolTable = this.symbolTable();
        WasmFunction function = (WasmFunction)symbolTable.exportedFunctions().get((Object)member);
        if (function != null) {
            return this.functionInstance(function);
        }
        Integer tableIndex = (Integer)symbolTable.exportedTables().get((Object)member);
        if (tableIndex != null) {
            return this.store().tables().table(this.tableAddress(tableIndex));
        }
        Integer memoryIndex = (Integer)symbolTable.exportedMemories().get((Object)member);
        if (memoryIndex != null) {
            return this.memory(memoryIndex);
        }
        Integer globalIndex = (Integer)symbolTable.exportedGlobals().get((Object)member);
        if (globalIndex != null) {
            return this.readGlobal(symbolTable, globalIndex);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void writeMember(String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
        boolean mutable;
        this.ensureLinked();
        SymbolTable symbolTable = this.symbolTable();
        Integer index = (Integer)symbolTable.exportedGlobals().get((Object)member);
        if (index == null) {
            throw UnknownIdentifierException.create((String)member);
        }
        int address = this.globalAddress(index);
        if (!(value instanceof Number)) {
            throw UnsupportedMessageException.create();
        }
        boolean bl = mutable = symbolTable.globalMutability(index) == 1;
        if (this.module().isParsed() && !mutable) {
            throw UnsupportedMessageException.create();
        }
        long longValue = ((Number)value).longValue();
        this.store().globals().storeLong(address, longValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        this.ensureLinked();
        SymbolTable symbolTable = this.symbolTable();
        try {
            return symbolTable.exportedFunctions().containsKey((Object)member) || symbolTable.exportedMemories().containsKey((Object)member) || symbolTable.exportedTables().containsKey((Object)member) || symbolTable.exportedGlobals().containsKey((Object)member);
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberModifiable(String member) {
        this.ensureLinked();
        SymbolTable symbolTable = this.symbolTable();
        Integer index = (Integer)symbolTable.exportedGlobals().get((Object)member);
        if (index == null) {
            return false;
        }
        return symbolTable.globalMutability(index) == 1;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member) {
        return false;
    }

    private Object readGlobal(SymbolTable symbolTable, int globalIndex) {
        int address = this.globalAddress(globalIndex);
        GlobalRegistry globals = this.store().globals();
        byte type = symbolTable.globalValueType(globalIndex);
        switch (type) {
            case 127: {
                return globals.loadAsInt(address);
            }
            case 126: {
                return globals.loadAsLong(address);
            }
            case 125: {
                return Float.valueOf(Float.intBitsToFloat(globals.loadAsInt(address)));
            }
            case 124: {
                return Double.longBitsToDouble(globals.loadAsLong(address));
            }
            case 123: {
                return globals.loadAsVector128(address);
            }
            case 111: 
            case 112: {
                return globals.loadAsReference(address);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RuntimeException("Unknown type: " + type);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        this.ensureLinked();
        SymbolTable symbolTable = this.symbolTable();
        ArrayList<String> exportNames = new ArrayList<String>();
        for (String functionName : symbolTable.exportedFunctions().getKeys()) {
            exportNames.add(functionName);
        }
        for (String tableName : symbolTable.exportedTables().getKeys()) {
            exportNames.add(tableName);
        }
        for (String memoryName : symbolTable.exportedMemories().getKeys()) {
            exportNames.add(memoryName);
        }
        for (String globalName : symbolTable.exportedGlobals().getKeys()) {
            exportNames.add(globalName);
        }
        return new Sequence(exportNames);
    }

    public boolean isBuiltin() {
        return this.module().isBuiltin();
    }

    public String toString() {
        return "wasm-module-instance(" + this.name() + ")";
    }
}

