/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstantiator;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.parser.DebugTranslator;
import org.graalvm.wasm.parser.ir.CodeEntry;

public final class WasmModule
extends SymbolTable
implements TruffleObject {
    private final String name;
    private volatile List<LinkAction> linkActions;
    private final ModuleLimits limits;
    private Source source;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] bytecode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] customData;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] codeSection;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private CodeEntry[] codeEntries;
    @CompilerDirectives.CompilationFinal
    private boolean isParsed;
    private volatile boolean hasBeenInstantiated;
    @CompilerDirectives.CompilationFinal
    private int debugInfoOffset;
    @CompilerDirectives.CompilationFinal
    private EconomicMap<Integer, DebugFunction> debugFunctions;
    private static final VarHandle LINK_ACTIONS;

    private WasmModule(String name, ModuleLimits limits) {
        this.name = name;
        this.limits = limits == null ? ModuleLimits.DEFAULTS : limits;
        this.linkActions = new ArrayList<LinkAction>();
        this.isParsed = false;
        this.debugInfoOffset = -1;
    }

    public static WasmModule create(String name, ModuleLimits limits) {
        return new WasmModule(name, limits);
    }

    public static WasmModule createBuiltin(String name) {
        return new WasmModule(name, null);
    }

    @Override
    protected WasmModule module() {
        return this;
    }

    public SymbolTable symbolTable() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public List<LinkAction> getOrRecreateLinkActions() {
        List result = LINK_ACTIONS.getAndSet(this, null);
        if (result != null) {
            return result;
        }
        return WasmInstantiator.recreateLinkActions(this);
    }

    public void addLinkAction(LinkAction action) {
        assert (!this.isParsed());
        this.linkActions.add(action);
    }

    public boolean hasBeenInstantiated() {
        return this.hasBeenInstantiated;
    }

    public void setHasBeenInstantiated() {
        this.hasBeenInstantiated = true;
    }

    public ModuleLimits limits() {
        return this.limits;
    }

    public Source source() {
        if (this.source == null) {
            this.source = this.isBuiltin() ? Source.newBuilder((String)"wasm", (CharSequence)"", (String)this.name).internal(true).build() : Source.newBuilder((String)"wasm", (CharSequence)"", (String)this.name).build();
        }
        return this.source;
    }

    public byte[] bytecode() {
        return this.bytecode;
    }

    public int bytecodeLength() {
        return this.bytecode != null ? this.bytecode.length : 0;
    }

    public void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    public CodeEntry[] codeEntries() {
        return this.codeEntries;
    }

    public void setCodeEntries(CodeEntry[] codeEntries) {
        this.codeEntries = codeEntries;
    }

    public boolean hasCodeEntries() {
        return this.codeEntries != null;
    }

    public void setParsed() {
        this.isParsed = true;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public boolean isBuiltin() {
        return this.bytecode == null;
    }

    public byte[] customData() {
        return this.customData;
    }

    public void setCustomData(byte[] customData) {
        this.customData = customData;
    }

    public byte[] codeSection() {
        return this.codeSection;
    }

    public void setCodeSection(byte[] codeSection) {
        this.codeSection = codeSection;
    }

    public boolean hasDebugInfo() {
        return this.debugInfoOffset != -1;
    }

    public void setDebugInfoOffset(int offset) {
        this.debugInfoOffset = offset;
    }

    public int debugInfoOffset() {
        return this.debugInfoOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeStartOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 12 * codeEntryIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeInstructionOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 4 + 12 * codeEntryIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeEndOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 8 + 12 * codeEntryIndex);
    }

    public String toString() {
        return "wasm-module(" + this.name + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Integer, DebugFunction> debugFunctions(Node node) {
        if (this.debugFunctions == null && this.hasDebugInfo()) {
            WasmContext context = WasmContext.get(node);
            DebugTranslator translator = new DebugTranslator(this.customData, context.getContextOptions().debugCompDirectory());
            this.debugFunctions = translator.readCompilationUnits(this.customData, this.debugInfoOffset);
        }
        return this.debugFunctions;
    }

    static {
        try {
            LINK_ACTIONS = MethodHandles.lookup().findVarHandle(WasmModule.class, "linkActions", List.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

