/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.Map;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmStore;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmScope
implements TruffleObject {
    private final WasmStore store;

    public WasmScope(WasmStore store) {
        this.store = store;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    private Map<String, WasmInstance> instances() {
        return this.store.moduleInstances();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        Map<String, WasmInstance> instances = this.instances();
        WasmInstance value = instances.get(member);
        if (value != null) {
            return value;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        Map<String, WasmInstance> instances = this.instances();
        return instances.containsKey(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        Map<String, WasmInstance> instances = this.instances();
        String[] keys = instances.keySet().toArray(new String[instances.size()]);
        return new InstanceNamesObject(keys);
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "wasm-global-scope" + String.valueOf(this.instances().keySet());
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class InstanceNamesObject
    implements TruffleObject {
        private final String[] names;

        InstanceNamesObject(String[] names) {
            this.names = names;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.names.length;
        }

        @ExportMessage
        long getArraySize() {
            return this.names.length;
        }

        @ExportMessage
        Object readArrayElement(long index, @Bind Node node, @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                error.enter(node);
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.names[(int)index];
        }
    }
}

