/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugConstantObject;
import org.graalvm.wasm.debugging.data.objects.DebugValue;

public class DebugPointerType
extends DebugType {
    protected final DebugType baseType;

    public DebugPointerType(DebugType baseType) {
        assert (baseType != null) : "the base type of a debug pointer must not be null";
        this.baseType = baseType;
    }

    @Override
    public String asTypeName() {
        return this.baseType.asTypeName() + "*";
    }

    @Override
    public int valueLength() {
        return 4;
    }

    @Override
    public boolean hasMembers() {
        return true;
    }

    @Override
    public int memberCount() {
        return 1;
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        DebugLocation pointerLocation = location.loadAsLocation();
        if (pointerLocation.isInvalid()) {
            return DebugConstantObject.UNDEFINED;
        }
        String name = context.elementNameOrEmpty();
        return new DebugValue("*" + name, pointerLocation, this.baseType);
    }

    @Override
    public boolean isLocation() {
        return true;
    }

    @Override
    public DebugLocation asLocation(DebugContext context, DebugLocation location) {
        return location.loadAsLocation();
    }
}

