/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import java.nio.file.Path;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.data.DebugDataUtil;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObjectFactory;
import org.graalvm.wasm.debugging.languages.DebugLanguageSupport;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParseUnit;
import org.graalvm.wasm.debugging.parser.DebugParser;
import org.graalvm.wasm.debugging.parser.DebugParserContext;
import org.graalvm.wasm.debugging.parser.DebugParserScope;
import org.graalvm.wasm.debugging.parser.DebugSourceLoader;
import org.graalvm.wasm.debugging.parser.DebugUtil;

public class DebugTranslator {
    private final DebugParser parser;
    private final DebugSourceLoader sourceLoader;
    private final String testCompDir;

    public DebugTranslator(byte[] data, String testCompDir) {
        this.parser = new DebugParser(data);
        this.sourceLoader = new DebugSourceLoader();
        this.testCompDir = testCompDir;
    }

    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Integer, DebugFunction> readCompilationUnits(byte[] customData, int debugInfoOffset) {
        assert (customData != null) : "the array containing the debug information must not be null when trying to parse the information";
        assert (debugInfoOffset != -1) : "the offset of the debug information must be valid";
        EconomicMap debugFunctions = EconomicMap.create();
        int unitOffset = 0;
        DebugParseUnit entryUnit = this.parser.readCompilationUnit(debugInfoOffset, unitOffset);
        while (entryUnit != null) {
            DebugParserContext context;
            DebugParseUnit unit;
            if (this.parseCompilationUnit(entryUnit, customData, debugInfoOffset) != null && (unit = this.parser.readEntries(debugInfoOffset, unitOffset)) != null && (context = this.parseCompilationUnit(unit, customData, debugInfoOffset)) != null) {
                debugFunctions.putAll(context.functions());
            }
            if ((unitOffset = this.parser.getNextCompilationUnitOffset(debugInfoOffset, unitOffset)) == -1) continue;
            entryUnit = this.parser.readCompilationUnit(debugInfoOffset, unitOffset);
        }
        return debugFunctions;
    }

    private DebugParserContext parseCompilationUnit(DebugParseUnit parseUnit, byte[] customData, int debugInfoOffset) {
        DebugData data = parseUnit.rootData();
        EconomicMap<Integer, DebugData> entries = parseUnit.entries();
        int languageId = data.asI32OrDefault(19, -1);
        DebugObjectFactory objectFactory = DebugLanguageSupport.getObjectFactory(languageId);
        if (objectFactory == null) {
            return null;
        }
        String languageName = objectFactory.languageName();
        int stmtList = data.asI32OrDefault(16, -1);
        if (stmtList == -1) {
            return null;
        }
        String compDir = data.asStringOrNull(27);
        if (compDir == null) {
            return null;
        }
        if (!this.testCompDir.isEmpty()) {
            compDir = this.testCompDir;
        }
        int lineOffset = DebugUtil.getLineOffsetOrUndefined(customData, debugInfoOffset);
        int lineLength = DebugUtil.getLineLengthOrUndefined(customData, debugInfoOffset);
        if (lineOffset == -1 || lineLength == -1) {
            return null;
        }
        DebugLineMap[] fileLineMaps = this.parser.readLineSectionOrNull(lineOffset + stmtList, lineLength, compDir);
        if (fileLineMaps == null) {
            return null;
        }
        int nullSources = 0;
        Source[] fileSources = new Source[fileLineMaps.length];
        for (int i = 0; i < fileSources.length; ++i) {
            DebugLineMap lineMap = fileLineMaps[i];
            if (lineMap != null) {
                Path path = lineMap.getFilePath();
                fileSources[i] = this.sourceLoader.load(path, languageName, !this.testCompDir.isEmpty());
            }
            if (fileSources[i] != null) continue;
            ++nullSources;
        }
        if (nullSources == fileSources.length) {
            return null;
        }
        DebugParserContext context = new DebugParserContext(customData, debugInfoOffset, entries, fileLineMaps, fileSources);
        int[] pcs = DebugDataUtil.readPcsOrNull(data, context);
        if (pcs == null) {
            return null;
        }
        assert (pcs.length == 2) : "the pc range of a debug compilation unit must contain exactly two values (start pc and end pc)";
        int scopeStart = pcs[0];
        int scopeEnd = pcs[1];
        DebugParserScope scope = context.globalScope().with(null, scopeStart, scopeEnd);
        for (DebugData child : data.children()) {
            objectFactory.parse(context, scope, child);
        }
        return context;
    }
}

