/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.exception;

public enum Failure {
    UNSPECIFIED_MALFORMED(Type.MALFORMED, "unspecified"),
    INTEGER_REPRESENTATION_TOO_LONG(Type.MALFORMED, "integer representation too long"),
    INTEGER_TOO_LARGE(Type.MALFORMED, "integer too large"),
    UNEXPECTED_END(Type.MALFORMED, "unexpected end of section or function"),
    MALFORMED_VALUE_TYPE(Type.MALFORMED, "malformed value type"),
    INVALID_MAGIC_NUMBER(Type.MALFORMED, "magic header not detected"),
    INVALID_VERSION_NUMBER(Type.MALFORMED, "unknown binary version"),
    ZERO_BYTE_EXPECTED(Type.MALFORMED, "zero byte expected"),
    SECTION_SIZE_MISMATCH(Type.MALFORMED, "section size mismatch"),
    TOO_MANY_LOCALS(Type.MALFORMED, "too many locals"),
    FUNCTIONS_CODE_INCONSISTENT_LENGTHS(Type.MALFORMED, "function and code section have inconsistent lengths"),
    MALFORMED_UTF8(Type.MALFORMED, "malformed UTF-8 encoding"),
    MALFORMED_SECTION_ID(Type.MALFORMED, "malformed section id"),
    MALFORMED_MUTABILITY(Type.MALFORMED, "malformed mutability"),
    LENGTH_OUT_OF_BOUNDS(Type.MALFORMED, "length out of bounds"),
    DATA_COUNT_MISMATCH(Type.MALFORMED, "data count and data section have inconsistent lengths"),
    DATA_COUNT_SECTION_REQUIRED(Type.MALFORMED, "data count section required"),
    ILLEGAL_OPCODE(Type.MALFORMED, "illegal opcode"),
    MALFORMED_REFERENCE_TYPE(Type.MALFORMED, "malformed reference type"),
    MALFORMED_IMPORT_KIND(Type.MALFORMED, "malformed import kind"),
    END_OPCODE_EXPECTED(Type.MALFORMED, "END opcode expected"),
    UNEXPECTED_CONTENT_AFTER_LAST_SECTION(Type.MALFORMED, "unexpected content after last section"),
    MALFORMED_MEMOP_FLAGS(Type.MALFORMED, "malformed memop flags"),
    INVALID_SECTION_ORDER(Type.MALFORMED, "invalid section order"),
    DISABLED_MULTI_VALUE(Type.MALFORMED, "multi-value is not enabled"),
    UNSPECIFIED_INVALID(Type.INVALID, "unspecified"),
    TYPE_MISMATCH(Type.INVALID, "type mismatch"),
    INVALID_RESULT_ARITY(Type.INVALID, "invalid result arity"),
    MULTIPLE_MEMORIES(Type.INVALID, "multiple memories"),
    MULTIPLE_TABLES(Type.INVALID, "multiple tables"),
    LOOP_INPUT(Type.INVALID, "non-empty loop input type"),
    UNKNOWN_LOCAL(Type.INVALID, "unknown local"),
    UNKNOWN_GLOBAL(Type.INVALID, "unknown global"),
    UNKNOWN_MEMORY(Type.INVALID, "unknown memory"),
    UNKNOWN_TABLE(Type.INVALID, "unknown table"),
    UNKNOWN_LABEL(Type.INVALID, "unknown label"),
    UNKNOWN_FUNCTION(Type.INVALID, "unknown function"),
    UNKNOWN_TYPE(Type.INVALID, "unknown type"),
    START_FUNCTION_RESULT_VALUE(Type.INVALID, "start function"),
    START_FUNCTION_PARAMS(Type.INVALID, "start function"),
    LIMIT_MINIMUM_GREATER_THAN_MAXIMUM(Type.INVALID, "size minimum must not be greater than maximum"),
    DUPLICATE_EXPORT(Type.INVALID, "duplicate export name"),
    IMMUTABLE_GLOBAL_WRITE(Type.INVALID, "global is immutable"),
    CONSTANT_EXPRESSION_REQUIRED(Type.INVALID, "constant expression required"),
    LIMIT_EXCEEDED(Type.INVALID, "limit exceeded"),
    MEMORY_SIZE_LIMIT_EXCEEDED(Type.INVALID, "memory size must be at most 65536 pages (4GiB)"),
    MEMORY_64_SIZE_LIMIT_EXCEEDED(Type.INVALID, "memory size must be at most 976562500 pages"),
    ALIGNMENT_LARGER_THAN_NATURAL(Type.INVALID, "alignment must not be larger than natural"),
    ATOMIC_ALIGNMENT_NOT_NATURAL(Type.INVALID, "atomic alignment must be natural"),
    SHARED_MEMORY_MUST_HAVE_MAXIMUM(Type.INVALID, "shared memory must have maximum"),
    UNEXPECTED_END_OF_BLOCK(Type.INVALID, "cannot exit unspecified block"),
    UNKNOWN_ELEM_SEGMENT(Type.INVALID, "unknown elem segment"),
    UNKNOWN_DATA_SEGMENT(Type.INVALID, "unknown data segment"),
    UNKNOWN_REFERENCE(Type.INVALID, "unknown reference"),
    UNDECLARED_FUNCTION_REFERENCE(Type.INVALID, "undeclared function reference"),
    MODULE_SIZE_LIMIT_EXCEEDED(Type.INVALID, "module size exceeds limit"),
    TYPE_COUNT_LIMIT_EXCEEDED(Type.INVALID, "type count exceeds limit"),
    FUNCTION_COUNT_LIMIT_EXCEEDED(Type.INVALID, "function count exceeds limit"),
    TABLE_COUNT_LIMIT_EXCEEDED(Type.INVALID, "table count exceeds limit"),
    MEMORY_COUNT_LIMIT_EXCEEDED(Type.INVALID, "memory count exceeds limit"),
    IMPORT_COUNT_LIMIT_EXCEEDED(Type.INVALID, "import count exceeds limit"),
    EXPORT_COUNT_LIMIT_EXCEEDED(Type.INVALID, "export count exceeds limit"),
    GLOBAL_COUNT_LIMIT_EXCEEDED(Type.INVALID, "global count exceeds limit"),
    DATA_SEGMENT_COUNT_LIMIT_EXCEEDED(Type.INVALID, "data segment count exceeds limit"),
    ELEMENT_SEGMENT_COUNT_LIMIT_EXCEEDED(Type.INVALID, "element segment count exceeds limit"),
    FUNCTION_SIZE_LIMIT_EXCEEDED(Type.INVALID, "function size exceeds limit"),
    PARAMETERS_COUNT_LIMIT_EXCEEDED(Type.INVALID, "parameters count exceeds limit"),
    RESULT_COUNT_LIMIT_EXCEEDED(Type.INVALID, "result values count exceeds limit"),
    UNSPECIFIED_UNLINKABLE(Type.UNLINKABLE, "unspecified"),
    UNKNOWN_IMPORT(Type.UNLINKABLE, "unknown import"),
    INCOMPATIBLE_IMPORT_TYPE(Type.UNLINKABLE, "incompatible import type"),
    INVALID_WASI_DIRECTORIES_MAPPING(Type.UNLINKABLE, "invalid wasi directories mapping"),
    UNSPECIFIED_TRAP(Type.TRAP, "unspecified"),
    INT_DIVIDE_BY_ZERO(Type.TRAP, "integer divide by zero"),
    INT_OVERFLOW(Type.TRAP, "integer overflow"),
    INVALID_CONVERSION_TO_INT(Type.TRAP, "invalid conversion to integer"),
    UNREACHABLE(Type.TRAP, "unreachable"),
    UNDEFINED_ELEMENT(Type.TRAP, "undefined element"),
    UNINITIALIZED_ELEMENT(Type.TRAP, "uninitialized element"),
    OUT_OF_BOUNDS_MEMORY_ACCESS(Type.TRAP, "out of bounds memory access"),
    UNALIGNED_ATOMIC(Type.TRAP, "unaligned atomic"),
    EXPECTED_SHARED_MEMORY(Type.TRAP, "expected shared memory"),
    INDIRECT_CALL_TYPE__MISMATCH(Type.TRAP, "indirect call type mismatch"),
    INVALID_MULTI_VALUE_ARITY(Type.TRAP, "provided multi-value size does not match function type"),
    INVALID_TYPE_IN_MULTI_VALUE(Type.TRAP, "type of value in multi-value does not match the function type"),
    NULL_REFERENCE(Type.TRAP, "defined element is ref.null"),
    OUT_OF_BOUNDS_TABLE_ACCESS(Type.TRAP, "out of bounds table access"),
    TABLE_INSTANCE_SIZE_LIMIT_EXCEEDED(Type.TRAP, "table instance size exceeds limit"),
    MEMORY_INSTANCE_SIZE_LIMIT_EXCEEDED(Type.TRAP, "memory instance size exceeds limit"),
    UNSUPPORTED_MULTI_VALUE_TYPE(Type.TRAP, "multi-value has to be provided by an array type"),
    MEMORY_OVERHEAD_MODE(Type.TRAP, "functions cannot be executed with memory overhead mode enabled"),
    SHARED_MEMORY_WITHOUT_UNSAFE(Type.TRAP, "shared memories are not supported without Unsafe"),
    DIRECT_BYTE_BUFFER_WITHOUT_UNSAFE(Type.TRAP, "direct ByteBuffer memory access is not supported without Unsafe"),
    CALL_STACK_EXHAUSTED(Type.EXHAUSTION, "call stack exhausted"),
    MEMORY_ALLOCATION_FAILED(Type.EXHAUSTION, "could not allocate memory"),
    UNSPECIFIED_INTERNAL(Type.INTERNAL, "unspecified"),
    INCOMPATIBLE_OPTIONS(Type.INTERNAL, "some of the provided options are incompatible"),
    NON_REPRESENTABLE_EXTRA_DATA_VALUE(Type.MALFORMED, "value cannot be represented in extra data"),
    INVALID_LANE_INDEX(Type.INVALID, "invalid lane index");

    public final Type type;
    public final String name;

    private Failure(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public static enum Type {
        TRAP("trap"),
        EXHAUSTION("exhaustion"),
        MALFORMED("malformed"),
        INVALID("invalid"),
        UNLINKABLE("unlinkable"),
        INTERNAL("internal");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

