/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.exception;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import java.util.Locale;

public class WasmJsApiException
extends AbstractTruffleException {
    private static final long serialVersionUID = 8195809219857028793L;
    private final Kind kind;

    @CompilerDirectives.TruffleBoundary
    public WasmJsApiException(Kind kind, String message) {
        super(message);
        CompilerAsserts.neverPartOfCompilation();
        this.kind = kind;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmJsApiException(Kind kind, String message, Throwable cause) {
        super(message, cause, -1, null);
        CompilerAsserts.neverPartOfCompilation();
        this.kind = kind;
    }

    public Kind kind() {
        return this.kind;
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmJsApiException format(Kind kind, String s) {
        return new WasmJsApiException(kind, s);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmJsApiException format(Kind kind, String s, Object arg) {
        return new WasmJsApiException(kind, String.format(Locale.ROOT, s, arg));
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmJsApiException format(Kind kind, String s, Object ... args) {
        return new WasmJsApiException(kind, String.format(Locale.ROOT, s, args));
    }

    public static enum Kind {
        TypeError,
        RangeError,
        LinkError;

    }
}

