/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmFixedMemoryImplFunctionNode;
import org.graalvm.wasm.nodes.WasmFrame;
import org.graalvm.wasm.nodes.WasmRootNode;

@NodeInfo(language="wasm", description="The root node of all WebAssembly functions")
public class WasmFunctionRootNode
extends WasmRootNode {
    @Node.Child
    private WasmFixedMemoryImplFunctionNode functionNode;
    private final WasmCodeEntry codeEntry;
    private SourceSection sourceSection;

    public WasmFunctionRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, WasmModule module, WasmFixedMemoryImplFunctionNode functionNode, WasmCodeEntry codeEntry) {
        super(language, frameDescriptor, module);
        this.functionNode = functionNode;
        this.codeEntry = codeEntry;
    }

    int localCount() {
        return this.codeEntry.localCount();
    }

    int resultCount() {
        return this.codeEntry.resultCount();
    }

    void enterErrorBranch() {
        this.codeEntry.errorBranch();
    }

    byte resultType(int index) {
        return this.codeEntry.resultType(index);
    }

    int paramCount() {
        return this.module().symbolTable().function(this.codeEntry.functionIndex()).paramCount();
    }

    byte localType(int index) {
        return this.codeEntry.localType(index);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        int localCount = this.localCount();
        this.moveArgumentsToLocals(frame);
        this.initializeLocals(frame);
        int resultCount = this.resultCount();
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (resultCount > 1) {
            WasmLanguage.get((Node)this).multiValueStack().resize(resultCount);
        }
        try {
            this.functionNode.execute(frame, instance);
        }
        catch (StackOverflowError e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.CALL_STACK_EXHAUSTED);
        }
        if (resultCount == 0) {
            return WasmConstant.VOID;
        }
        if (resultCount == 1) {
            byte resultType = this.resultType(0);
            CompilerAsserts.partialEvaluationConstant((int)resultType);
            switch (resultType) {
                case 64: {
                    return WasmConstant.VOID;
                }
                case 127: {
                    return WasmFrame.popInt(frame, localCount);
                }
                case 126: {
                    return WasmFrame.popLong(frame, localCount);
                }
                case 125: {
                    return Float.valueOf(WasmFrame.popFloat(frame, localCount));
                }
                case 124: {
                    return WasmFrame.popDouble(frame, localCount);
                }
                case 123: {
                    return WasmFrame.popVector128(frame, localCount);
                }
                case 111: 
                case 112: {
                    return WasmFrame.popReference(frame, localCount);
                }
            }
            throw WasmException.format(Failure.UNSPECIFIED_INTERNAL, (Node)this, "Unknown result type: %d", resultType);
        }
        this.moveResultValuesToMultiValueStack(frame, resultCount, localCount);
        return WasmConstant.MULTI_VALUE;
    }

    @ExplodeLoop
    private void moveResultValuesToMultiValueStack(VirtualFrame frame, int resultCount, int localCount) {
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        WasmLanguage.MultiValueStack multiValueStack = WasmLanguage.get((Node)this).multiValueStack();
        long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
        Object[] objectMultiValueStack = multiValueStack.objectStack();
        block8: for (int i = 0; i < resultCount; ++i) {
            byte resultType = this.resultType(i);
            CompilerAsserts.partialEvaluationConstant((int)resultType);
            switch (resultType) {
                case 127: {
                    primitiveMultiValueStack[i] = WasmFrame.popInt(frame, localCount + i);
                    continue block8;
                }
                case 126: {
                    primitiveMultiValueStack[i] = WasmFrame.popLong(frame, localCount + i);
                    continue block8;
                }
                case 125: {
                    primitiveMultiValueStack[i] = Float.floatToRawIntBits(WasmFrame.popFloat(frame, localCount + i));
                    continue block8;
                }
                case 124: {
                    primitiveMultiValueStack[i] = Double.doubleToRawLongBits(WasmFrame.popDouble(frame, localCount + i));
                    continue block8;
                }
                case 123: {
                    objectMultiValueStack[i] = WasmFrame.popVector128(frame, localCount + i);
                    continue block8;
                }
                case 111: 
                case 112: {
                    objectMultiValueStack[i] = WasmFrame.popReference(frame, localCount + i);
                    continue block8;
                }
                default: {
                    throw WasmException.format(Failure.UNSPECIFIED_INTERNAL, (Node)this, "Unknown result type: %d", resultType);
                }
            }
        }
    }

    @ExplodeLoop
    private void moveArgumentsToLocals(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        int paramCount = this.paramCount();
        assert (WasmArguments.getArgumentCount(args) == paramCount) : "Expected number of params " + paramCount + ", actual " + WasmArguments.getArgumentCount(args);
        block8: for (int i = 0; i != paramCount; ++i) {
            Object arg = WasmArguments.getArgument(args, i);
            byte type = this.localType(i);
            switch (type) {
                case 127: {
                    WasmFrame.pushInt(frame, i, (Integer)arg);
                    continue block8;
                }
                case 126: {
                    WasmFrame.pushLong(frame, i, (Long)arg);
                    continue block8;
                }
                case 125: {
                    WasmFrame.pushFloat(frame, i, ((Float)arg).floatValue());
                    continue block8;
                }
                case 124: {
                    WasmFrame.pushDouble(frame, i, (Double)arg);
                    continue block8;
                }
                case 123: {
                    WasmFrame.pushVector128(frame, i, (Vector128)arg);
                    continue block8;
                }
                case 111: 
                case 112: {
                    WasmFrame.pushReference(frame, i, arg);
                }
            }
        }
    }

    @ExplodeLoop
    private void initializeLocals(VirtualFrame frame) {
        int paramCount;
        block8: for (int i = paramCount = this.paramCount(); i != this.localCount(); ++i) {
            byte type = this.localType(i);
            switch (type) {
                case 127: {
                    WasmFrame.pushInt(frame, i, 0);
                    continue block8;
                }
                case 126: {
                    WasmFrame.pushLong(frame, i, 0L);
                    continue block8;
                }
                case 125: {
                    WasmFrame.pushFloat(frame, i, 0.0f);
                    continue block8;
                }
                case 124: {
                    WasmFrame.pushDouble(frame, i, 0.0);
                    continue block8;
                }
                case 123: {
                    WasmFrame.pushVector128(frame, i, Vector128.ZERO);
                    continue block8;
                }
                case 111: 
                case 112: {
                    WasmFrame.pushReference(frame, i, WasmConstant.NULL);
                }
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private DebugFunction debugFunction() {
        if (this.module().hasDebugInfo()) {
            int functionSourceLocation = this.module().functionSourceCodeStartOffset(this.codeEntry.functionIndex());
            EconomicMap<Integer, DebugFunction> debugFunctions = this.module().debugFunctions((Node)this);
            if (debugFunctions.containsKey((Object)functionSourceLocation)) {
                return (DebugFunction)debugFunctions.get((Object)functionSourceLocation);
            }
        }
        return null;
    }

    public String getName() {
        DebugFunction function = this.debugFunction();
        return function != null ? function.name() : this.codeEntry.function().name();
    }

    public final String getQualifiedName() {
        return this.codeEntry.function().moduleName() + "." + this.getName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean isInstrumentable() {
        DebugFunction debugFunction = this.debugFunction();
        if (debugFunction == null) {
            return false;
        }
        return debugFunction.sourceSection() != null;
    }

    @CompilerDirectives.TruffleBoundary
    public final SourceSection getSourceSection() {
        if (this.sourceSection == null) {
            DebugFunction debugFunction = this.debugFunction();
            this.sourceSection = debugFunction != null ? debugFunction.sourceSection() : this.module().source().createUnavailableSection();
        }
        return this.sourceSection;
    }
}

