/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.BinaryParser;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.representation.DebugObjectDisplayValue;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.nodes.WasmDataAccess;
import org.graalvm.wasm.nodes.WasmFunctionNode;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNodeWrapper;
import org.graalvm.wasm.nodes.WasmInstrumentationSupportNode;
import org.graalvm.wasm.nodes.WasmRootNode;

@ExportLibrary(value=NodeLibrary.class)
@GenerateWrapper
public class WasmInstrumentableFunctionNode
extends Node
implements InstrumentableNode,
WasmDataAccess {
    private final int functionSourceLocation;
    private final WasmModule module;
    private final WasmCodeEntry codeEntry;
    @Node.Child
    private WasmFunctionNode functionNode;
    @Node.Child
    private WasmInstrumentationSupportNode instrumentation;
    @Node.Child
    private WasmMemoryLibrary zeroMemoryLib;

    public WasmInstrumentableFunctionNode(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes, WasmMemoryLibrary[] memoryLibs) {
        this.module = module;
        this.codeEntry = codeEntry;
        this.functionNode = new WasmFunctionNode(module, codeEntry, bytecodeStartOffset, bytecodeEndOffset, callNodes, memoryLibs);
        this.functionSourceLocation = module.functionSourceCodeStartOffset(codeEntry.functionIndex());
        this.zeroMemoryLib = module.memoryCount() > 0 ? memoryLibs[0] : null;
    }

    protected WasmInstrumentableFunctionNode(WasmInstrumentableFunctionNode node) {
        this.module = node.module;
        this.codeEntry = node.codeEntry;
        this.functionNode = node.functionNode;
        this.functionSourceLocation = node.functionSourceLocation;
        this.instrumentation = node.instrumentation;
        this.zeroMemoryLib = node.zeroMemoryLib;
    }

    private WasmInstance instance(VirtualFrame frame) {
        return ((WasmRootNode)this.getRootNode()).instance(frame);
    }

    private WasmMemory memory0(MaterializedFrame frame) {
        return this.instance((VirtualFrame)frame).memory(0);
    }

    int localCount() {
        return this.codeEntry.localCount();
    }

    void execute(VirtualFrame frame, WasmInstance instance) {
        this.functionNode.execute(frame, instance);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isInstrumentable() {
        return this.getSourceSection() != null;
    }

    @CompilerDirectives.TruffleBoundary
    private DebugFunction debugFunction() {
        EconomicMap<Integer, DebugFunction> debugFunctions;
        if (this.module.hasDebugInfo() && (debugFunctions = this.module.debugFunctions(this)).containsKey((Object)this.functionSourceLocation)) {
            return (DebugFunction)debugFunctions.get((Object)this.functionSourceLocation);
        }
        return null;
    }

    protected void notifyLine(VirtualFrame frame, int line, int nextLine, int sourceLocation) {
        this.instrumentation.notifyLine(frame, line, nextLine, sourceLocation);
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.RootBodyTag.class || tag == StandardTags.RootTag.class;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceSection() {
        DebugFunction debugFunction = this.debugFunction();
        if (debugFunction != null) {
            return debugFunction.sourceSection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        WasmInstrumentationSupportNode info = this.instrumentation;
        WasmContext context = WasmContext.get(this);
        if (info == null && this.module.hasDebugInfo() && materializedTags.contains(StandardTags.StatementTag.class)) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                info = this.instrumentation;
                if (info == null) {
                    int functionIndex = this.codeEntry.functionIndex();
                    DebugFunction debugFunction = this.debugFunction();
                    if (debugFunction == null) {
                        WasmInstrumentableFunctionNode wasmInstrumentableFunctionNode = this;
                        return wasmInstrumentableFunctionNode;
                    }
                    this.instrumentation = info = (WasmInstrumentationSupportNode)this.insert(new WasmInstrumentationSupportNode(debugFunction, this.module, functionIndex));
                    BinaryParser binaryParser = new BinaryParser(this.module, context, this.module.codeSection());
                    byte[] bytecode = binaryParser.createFunctionDebugBytecode(functionIndex, debugFunction.lineMap().sourceLocationToLineMap());
                    this.functionNode.updateBytecode(bytecode, 0, bytecode.length, this::notifyLine);
                    this.notifyInserted(info);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new WasmInstrumentableFunctionNodeWrapper(this, this, probe);
    }

    @ExportMessage
    public final boolean hasScope(Frame frame) {
        return this.debugFunction() != null;
    }

    @ExportMessage
    public final Object getScope(Frame frame, boolean nodeEnter) {
        DebugFunction debugFunction = this.debugFunction();
        assert (debugFunction != null);
        DebugContext context = new DebugContext(this.instrumentation.currentSourceLocation());
        MaterializedFrame materializedFrame = frame.materialize();
        return DebugObjectDisplayValue.fromDebugFunction(debugFunction, context, materializedFrame, this, !WasmContext.get(this).getContextOptions().debugCompDirectory().isEmpty());
    }

    @Override
    public boolean isValidStackIndex(MaterializedFrame frame, int index) {
        return index >= 0 && this.localCount() + index < frame.getFrameDescriptor().getNumberOfSlots();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int loadI32FromStack(MaterializedFrame frame, int index) {
        return frame.getIntStatic(this.localCount() + index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long loadI64FromStack(MaterializedFrame frame, int index) {
        return frame.getLongStatic(this.localCount() + index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float loadF32FromStack(MaterializedFrame frame, int index) {
        return frame.getFloatStatic(this.localCount() + index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double loadF64FromStack(MaterializedFrame frame, int index) {
        return frame.getDoubleStatic(this.localCount() + index);
    }

    @Override
    public boolean isValidLocalIndex(MaterializedFrame frame, int index) {
        return index >= 0 && index < this.localCount();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int loadI32FromLocals(MaterializedFrame frame, int index) {
        return frame.getIntStatic(index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long loadI64FromLocals(MaterializedFrame frame, int index) {
        return frame.getLongStatic(index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float loadF32FromLocals(MaterializedFrame frame, int index) {
        return frame.getFloatStatic(index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double loadF64FromLocals(MaterializedFrame frame, int index) {
        return frame.getDoubleStatic(index);
    }

    @Override
    public boolean isValidGlobalIndex(int index) {
        return index >= 0 && index < this.module.symbolTable().numGlobals();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int loadI32FromGlobals(MaterializedFrame frame, int index) {
        WasmInstance instance = this.instance((VirtualFrame)frame);
        int address = instance.globalAddress(index);
        return instance.store().globals().loadAsInt(address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long loadI64FromGlobals(MaterializedFrame frame, int index) {
        WasmInstance instance = this.instance((VirtualFrame)frame);
        int address = instance.globalAddress(index);
        return instance.store().globals().loadAsLong(address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float loadF32FromGlobals(MaterializedFrame frame, int index) {
        return Float.floatToRawIntBits(this.loadI32FromGlobals(frame, index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double loadF64FromGlobals(MaterializedFrame frame, int index) {
        return Double.doubleToRawLongBits(this.loadI64FromGlobals(frame, index));
    }

    @Override
    public boolean isValidMemoryAddress(MaterializedFrame frame, long address, int length) {
        WasmMemory memory = this.memory0(frame);
        return address >= 0L && address + (long)length < this.zeroMemoryLib.byteSize(memory);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte loadI8FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return (byte)this.zeroMemoryLib.load_i32_8s(memory, this, address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public short loadI16FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return (short)this.zeroMemoryLib.load_i32_16s(memory, this, address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int loadI32FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return this.zeroMemoryLib.load_i32(memory, this, address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long loadI64FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return this.zeroMemoryLib.load_i64(memory, this, address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public float loadF32FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return this.zeroMemoryLib.load_f32(memory, this, address);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public double loadF64FromMemory(MaterializedFrame frame, long address) {
        WasmMemory memory = this.memory0(frame);
        return this.zeroMemoryLib.load_f64(memory, this, address);
    }

    private byte[] loadByteArrayFromMemory(MaterializedFrame frame, long address, int length) {
        WasmMemory memory = this.memory0(frame);
        byte[] dataArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            dataArray[i] = (byte)this.zeroMemoryLib.load_i32_8s(memory, this, address + (long)i);
        }
        return dataArray;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String loadStringFromMemory(MaterializedFrame frame, long address, int length) {
        byte[] dataArray = this.loadByteArrayFromMemory(frame, address, length);
        return new String(dataArray);
    }
}

