/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Locale;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public class Assert {
    public static void assertByteEqual(byte b1, byte b2, Failure failure) throws WasmException {
        if (b1 != b2) {
            Assert.fail(failure, "%s: 0x%02X should = 0x%02X", failure.name, b1, b2);
        }
    }

    public static void assertByteEqual(byte b1, byte b2, String message, Failure failure) throws WasmException {
        if (b1 != b2) {
            Assert.fail(failure, "%s: 0x%02X should = 0x%02X", message, b1, b2);
        }
    }

    public static void assertIntEqual(int actual, int expected, Failure failure) throws WasmException {
        Assert.assertIntEqual(actual, expected, failure, failure.name);
    }

    public static void assertIntEqual(int actual, int expected, Failure failure, String message) throws WasmException {
        if (actual != expected) {
            Assert.fail(failure, "%s: %d should = %d", message, actual, expected);
        }
    }

    public static void assertIntEqual(int actual, int expected, Failure failure, String format, int arg) throws WasmException {
        if (actual != expected) {
            Assert.fail(failure, "%s: %d should = %d", Assert.format(format, arg), actual, expected);
        }
    }

    public static void assertIntGreaterOrEqual(int n1, int n2, Failure failure) throws WasmException {
        if (n1 < n2) {
            Assert.fail(failure, "%s: %d should be >= %d", failure.name, n1, n2);
        }
    }

    public static void assertIntGreater(int n1, int n2, String message, Failure failure) throws WasmException {
        if (n1 <= n2) {
            Assert.fail(failure, "%s: %d should be > %d", message, n1, n2);
        }
    }

    public static void assertIntLessOrEqual(int n1, int n2, Failure failure) throws WasmException {
        Assert.assertIntLessOrEqual(n1, n2, failure.name, failure);
    }

    public static void assertIntLess(int n1, int n2, Failure failure) throws WasmException {
        if (n1 >= n2) {
            Assert.fail(failure, "%s: %d should be < %d", failure.name, n1, n2);
        }
    }

    public static void assertUnsignedIntLess(int n1, int n2, Failure failure) throws WasmException {
        Assert.assertUnsignedIntLess(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedIntLess(int n1, int n2, Failure failure, String message) throws WasmException {
        if (Integer.compareUnsigned(n1, n2) >= 0) {
            Assert.fail(failure, "%s: %s should be < %s", message, Integer.toUnsignedString(n1), Integer.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedIntLess(int n1, int n2, Failure failure, String format, Object arg) throws WasmException {
        if (Integer.compareUnsigned(n1, n2) >= 0) {
            Assert.fail(failure, "%s: %s should be < %s", Assert.format(format, arg), Integer.toUnsignedString(n1), Integer.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedIntLess(int n1, int n2, Failure failure, String format, Object arg1, Object arg2) throws WasmException {
        if (Integer.compareUnsigned(n1, n2) >= 0) {
            Assert.fail(failure, "%s: %s should be < %s", Assert.format(format, arg1, arg2), Integer.toUnsignedString(n1), Integer.toUnsignedString(n2));
        }
    }

    public static void assertIntLessOrEqual(int n1, int n2, String message, Failure failure) throws WasmException {
        if (n1 > n2) {
            Assert.fail(failure, "%s: %d should be <= %d", message, n1, n2);
        }
    }

    public static void assertUnsignedIntLessOrEqual(int n1, int n2, Failure failure) throws WasmException {
        Assert.assertUnsignedIntLessOrEqual(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedIntLessOrEqual(int n1, int n2, Failure failure, String message) throws WasmException {
        if (Integer.compareUnsigned(n1, n2) > 0) {
            Assert.fail(failure, "%s: %s should be <= %s", message, Integer.toUnsignedString(n1), Integer.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedLongLess(long n1, long n2, Failure failure) throws WasmException {
        Assert.assertUnsignedLongLess(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedLongLess(long n1, long n2, Failure failure, String message) throws WasmException {
        if (Long.compareUnsigned(n1, n2) >= 0) {
            Assert.fail(failure, "%s: %s should be < %s", message, Long.toUnsignedString(n1), Long.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedLongLessOrEqual(long n1, long n2, Failure failure) throws WasmException {
        Assert.assertUnsignedLongLessOrEqual(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedLongLessOrEqual(long n1, long n2, Failure failure, String message) throws WasmException {
        if (Long.compareUnsigned(n1, n2) > 0) {
            Assert.fail(failure, "%s: %s should be <= %s", message, Long.toUnsignedString(n1), Long.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedIntGreaterOrEqual(int n1, int n2, Failure failure) throws WasmException {
        Assert.assertUnsignedIntGreaterOrEqual(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedIntGreaterOrEqual(int n1, int n2, Failure failure, String message) throws WasmException {
        if (Integer.compareUnsigned(n1, n2) < 0) {
            Assert.fail(failure, "%s: %s should be >= %s", message, Integer.toUnsignedString(n1), Integer.toUnsignedString(n2));
        }
    }

    public static void assertUnsignedLongGreaterOrEqual(long n1, long n2, Failure failure) throws WasmException {
        Assert.assertUnsignedLongGreaterOrEqual(n1, n2, failure, failure.name);
    }

    public static void assertUnsignedLongGreaterOrEqual(long n1, long n2, Failure failure, String message) throws WasmException {
        if (Long.compareUnsigned(n1, n2) < 0) {
            Assert.fail(failure, "%s: %s should be >= %s", message, Long.toUnsignedString(n1), Long.toUnsignedString(n2));
        }
    }

    public static void assertLongLessOrEqual(long n1, long n2, Failure failure) throws WasmException {
        if (n1 > n2) {
            Assert.fail(failure, "%s: %d should be <= %d", failure.name, n1, n2);
        }
    }

    public static void assertNotNull(Object object, String message, Failure failure) throws WasmException {
        if (object == null) {
            Assert.fail(failure, "%s: expected a non-null value", (Object)message);
        }
    }

    public static void assertTrue(boolean condition, Failure failure) throws WasmException {
        Assert.assertTrue(condition, failure.name, failure);
    }

    public static void assertTrue(boolean condition, String message, Failure failure) throws WasmException {
        if (!condition) {
            Assert.fail(failure, message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException fail(Failure failure, String format, Object ... args) throws WasmException {
        throw WasmException.format(failure, format, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException fail(Failure failure, String format, Object arg) throws WasmException {
        throw WasmException.format(failure, format, arg);
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException fail(Failure failure, String format, int arg) throws WasmException {
        throw WasmException.format(failure, format, arg);
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException fail(Failure failure, String message) throws WasmException {
        throw WasmException.create(failure, message);
    }

    @CompilerDirectives.TruffleBoundary
    private static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }
}

