/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.wasm.Assert;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.ImportValueSupplier;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.RuntimeState;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.WasmType;
import org.graalvm.wasm.api.ExecuteHostFunctionNode;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.constants.GlobalModifier;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.globals.WasmGlobal;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;

public class Linker {
    private ResolutionDag resolutionDag;

    public void tryLink(WasmInstance instance) {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (!instance.isLinkCompleted() ? 1 : 0) != 0)) {
            this.tryLinkOutsidePartialEvaluation(instance);
        }
    }

    public void tryLink(WasmInstance instance, ImportValueSupplier imports) {
        if (!instance.isLinkCompleted()) {
            this.tryLinkOutsidePartialEvaluation(instance, imports);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static WasmException linkFailedError(WasmInstance instance) {
        return WasmException.format(Failure.UNSPECIFIED_UNLINKABLE, "Linking of module %s previously failed.", instance.module());
    }

    @CompilerDirectives.TruffleBoundary
    private void tryLinkOutsidePartialEvaluation(WasmInstance entryPointInstance) {
        this.tryLinkOutsidePartialEvaluation(entryPointInstance, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void tryLinkOutsidePartialEvaluation(WasmInstance entryPointInstance, ImportValueSupplier imports) {
        WasmStore store;
        WasmStore wasmStore = store = entryPointInstance.store();
        synchronized (wasmStore) {
            LinkState linkState = entryPointInstance.linkState();
            if (linkState == LinkState.failed) {
                throw Linker.linkFailedError(entryPointInstance);
            }
            if (linkState == LinkState.nonLinked) {
                if (this.resolutionDag == null) {
                    this.resolutionDag = new ResolutionDag();
                }
                Map<String, WasmInstance> instances = store.moduleInstances();
                ArrayList<Throwable> failures = new ArrayList<Throwable>();
                int maxStartFunctionIndex = Linker.runLinkActions(store, instances, imports, failures);
                this.linkTopologically(store, failures, maxStartFunctionIndex);
                Linker.assignTypeEquivalenceClasses(store);
                this.resolutionDag = null;
                Linker.runStartFunctions(instances, failures);
                Linker.checkFailures(failures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runLinkActions(WasmStore store, Map<String, WasmInstance> instances, ImportValueSupplier imports, ArrayList<Throwable> failures) {
        int maxStartFunctionIndex = 0;
        for (WasmInstance instance : instances.values()) {
            maxStartFunctionIndex = Math.max(maxStartFunctionIndex, instance.startFunctionIndex());
            if (!instance.isNonLinked()) continue;
            instance.setLinkInProgress();
            try {
                for (LinkAction action : instance.linkActions()) {
                    action.accept(store.context(), store, instance, imports);
                }
            }
            catch (Throwable e) {
                instance.setLinkFailed();
                failures.add(e);
            }
            finally {
                instance.removeLinkActions();
            }
        }
        return maxStartFunctionIndex;
    }

    private void linkTopologically(WasmStore store, ArrayList<Throwable> failures, int maxStartFunctionIndex) {
        ResolutionDag.Resolver[] sortedResolutions = this.resolutionDag.toposort();
        LinkedHashSet<String> moduleOrdering = new LinkedHashSet<String>();
        for (ResolutionDag.Resolver resolver : sortedResolutions) {
            resolver.runActionOnce(store, failures);
            String moduleName = resolver.element.moduleName();
            moduleOrdering.remove(moduleName);
            moduleOrdering.add(moduleName);
        }
        int i = 0;
        for (String moduleName : moduleOrdering) {
            store.moduleInstances().get(moduleName).setStartFunctionIndex(maxStartFunctionIndex + i + 1);
            ++i;
        }
    }

    private static void assignTypeEquivalenceClasses(WasmStore store) {
        Map<String, WasmInstance> instances = store.moduleInstances();
        for (WasmInstance instance : instances.values()) {
            WasmModule module = instance.module();
            if (!instance.isLinkInProgress() || module.isParsed()) continue;
            Linker.assignTypeEquivalenceClasses(module, store.language());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignTypeEquivalenceClasses(WasmModule module, WasmLanguage language) {
        ReentrantLock lock = module.getLock();
        lock.lock();
        try {
            int index;
            if (module.isParsed()) {
                return;
            }
            SymbolTable symtab = module.symbolTable();
            for (index = 0; index < symtab.typeCount(); ++index) {
                SymbolTable.FunctionType type = symtab.typeAt(index);
                int equivalenceClass = language.equivalenceClassFor(type);
                symtab.setEquivalenceClass(index, equivalenceClass);
            }
            for (index = 0; index < symtab.numFunctions(); ++index) {
                WasmFunction function = symtab.function(index);
                function.setTypeEquivalenceClass(symtab.equivalenceClass(function.typeIndex()));
            }
            module.setParsed();
        }
        finally {
            lock.unlock();
        }
    }

    private static void runStartFunctions(Map<String, WasmInstance> instances, ArrayList<Throwable> failures) {
        ArrayList<WasmInstance> instanceList = new ArrayList<WasmInstance>(instances.values());
        instanceList.sort(Comparator.comparingInt(RuntimeState::startFunctionIndex));
        for (WasmInstance instance : instanceList) {
            if (!instance.isLinkInProgress()) continue;
            try {
                Linker.runStartFunction(instance);
                instance.setLinkCompleted();
            }
            catch (Throwable e) {
                instance.setLinkFailed();
                failures.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runStartFunction(WasmInstance instance) {
        WasmFunction start = instance.symbolTable().startFunction();
        if (start != null) {
            if (start.isImported()) {
                WasmFunctionInstance functionInstance = instance.functionInstance(start.index());
                WasmContext currentContext = WasmContext.get(null);
                WasmContext functionInstanceContext = functionInstance.context();
                if (functionInstanceContext == currentContext) {
                    instance.target(start.index()).call(WasmArguments.create(functionInstance.moduleInstance(), new Object[0]));
                } else {
                    TruffleContext truffleContext = functionInstance.getTruffleContext();
                    Object prev = truffleContext.enter(null);
                    try {
                        instance.target(start.index()).call(WasmArguments.create(functionInstance.moduleInstance(), new Object[0]));
                    }
                    finally {
                        truffleContext.leave(null, prev);
                    }
                }
            } else {
                instance.target(start.index()).call(WasmArguments.create(instance, new Object[0]));
            }
        }
    }

    private static void checkFailures(ArrayList<Throwable> failures) {
        if (!failures.isEmpty()) {
            Throwable first = failures.get(0);
            if (first instanceof WasmException) {
                throw (WasmException)((Object)first);
            }
            if (first instanceof RuntimeException) {
                throw (RuntimeException)first;
            }
            throw new RuntimeException(first);
        }
    }

    void resolveGlobalImport(WasmStore store, WasmInstance instance, ImportDescriptor importDescriptor, int globalIndex, byte valueType, byte mutability, ImportValueSupplier imports) {
        String importedGlobalName = importDescriptor.memberName();
        String importedModuleName = importDescriptor.moduleName();
        Runnable resolveAction = () -> {
            int globalAddress;
            byte exportedMutability;
            byte exportedValueType;
            WasmGlobal externalGlobal = Linker.lookupImportObject(instance, importDescriptor, imports, WasmGlobal.class);
            if (externalGlobal != null) {
                exportedValueType = externalGlobal.getValueType().byteValue();
                exportedMutability = externalGlobal.getMutability();
                assert (globalIndex == importDescriptor.targetIndex());
                globalAddress = store.globals().allocateExternalGlobal(externalGlobal);
            } else {
                WasmInstance importedInstance = store.lookupModuleInstance(importedModuleName);
                if (importedInstance == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, "Module '" + importedModuleName + "', referenced in the import of global variable '" + importedGlobalName + "' into module '" + instance.name() + "', does not exist.");
                }
                Integer exportedGlobalIndex = (Integer)importedInstance.symbolTable().exportedGlobals().get((Object)importedGlobalName);
                if (exportedGlobalIndex == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, "Global variable '" + importedGlobalName + "', imported into module '" + instance.name() + "', was not exported in the module '" + importedModuleName + "'.");
                }
                exportedValueType = importedInstance.symbolTable().globalValueType(exportedGlobalIndex);
                exportedMutability = importedInstance.symbolTable().globalMutability(exportedGlobalIndex);
                globalAddress = importedInstance.globalAddress(exportedGlobalIndex);
            }
            if (exportedValueType != valueType) {
                throw WasmException.create(Failure.INCOMPATIBLE_IMPORT_TYPE, "Global variable '" + importedGlobalName + "' is imported into module '" + instance.name() + "' with the type " + WasmType.toString(valueType) + ", 'but it was exported in the module '" + importedModuleName + "' with the type " + WasmType.toString(exportedValueType) + ".");
            }
            if (exportedMutability != mutability) {
                throw WasmException.create(Failure.INCOMPATIBLE_IMPORT_TYPE, "Global variable '" + importedGlobalName + "' is imported into module '" + instance.name() + "' with the modifier " + GlobalModifier.asString(mutability) + ", 'but it was exported in the module '" + importedModuleName + "' with the modifier " + GlobalModifier.asString(exportedMutability) + ".");
            }
            instance.setGlobalAddress(globalIndex, globalAddress);
        };
        ResolutionDag.ImportGlobalSym importGlobalSym = new ResolutionDag.ImportGlobalSym(instance.name(), importDescriptor, globalIndex);
        ResolutionDag.Sym[] dependencies = new ResolutionDag.Sym[]{new ResolutionDag.ExportGlobalSym(importedModuleName, importedGlobalName)};
        this.resolutionDag.resolveLater(importGlobalSym, dependencies, resolveAction);
        this.resolutionDag.resolveLater(new ResolutionDag.InitializeGlobalSym(instance.name(), globalIndex), new ResolutionDag.Sym[]{importGlobalSym}, ResolutionDag.NO_RESOLVE_ACTION);
    }

    void resolveGlobalExport(WasmModule module, String globalName, int globalIndex) {
        ResolutionDag.Sym[] dependencies = new ResolutionDag.Sym[]{new ResolutionDag.InitializeGlobalSym(module.name(), globalIndex)};
        this.resolutionDag.resolveLater(new ResolutionDag.ExportGlobalSym(module.name(), globalName), dependencies, ResolutionDag.NO_RESOLVE_ACTION);
    }

    void resolveGlobalInitialization(WasmInstance instance, int globalIndex) {
        ResolutionDag.Sym[] dependencies = ResolutionDag.NO_DEPENDENCIES;
        this.resolutionDag.resolveLater(new ResolutionDag.InitializeGlobalSym(instance.name(), globalIndex), dependencies, ResolutionDag.NO_RESOLVE_ACTION);
    }

    public static void initializeGlobal(WasmStore store, WasmInstance instance, int globalIndex, byte[] initBytecode) {
        Object initValue = Linker.evalConstantExpression(store, instance, initBytecode);
        store.globals().store(instance.module().globalValueType(globalIndex), instance.globalAddress(globalIndex), initValue);
    }

    void resolveGlobalInitialization(WasmStore store, WasmInstance instance, int globalIndex, byte[] initBytecode) {
        Runnable resolveAction = () -> Linker.initializeGlobal(store, instance, globalIndex, initBytecode);
        List<ResolutionDag.Sym> dependencies = Linker.dependenciesOfConstantExpression(instance, initBytecode);
        this.resolutionDag.resolveLater(new ResolutionDag.InitializeGlobalSym(instance.name(), globalIndex), dependencies.toArray(new ResolutionDag.Sym[0]), resolveAction);
    }

    private static <T> T lookupImportObject(WasmInstance instance, ImportDescriptor importDescriptor, ImportValueSupplier resolvedImports, Class<T> expectedType) {
        Object resolvedImport;
        if (resolvedImports != null && (resolvedImport = resolvedImports.get(importDescriptor, instance)) != null) {
            return expectedType.cast(resolvedImport);
        }
        return null;
    }

    void resolveFunctionImport(WasmStore store, WasmInstance instance, WasmFunction function, ImportValueSupplier imports) {
        Runnable resolveAction = () -> {
            WasmModule module = instance.module();
            ImportDescriptor importDescriptor = function.importDescriptor();
            assert (module.importedFunction(importDescriptor) == function);
            Object externalFunctionInstance = Linker.lookupImportObject(instance, importDescriptor, imports, Object.class);
            if (externalFunctionInstance != null) {
                if (externalFunctionInstance instanceof WasmFunctionInstance) {
                    WasmFunctionInstance functionInstance = (WasmFunctionInstance)externalFunctionInstance;
                    if (!function.type().equals(functionInstance.function().type())) {
                        throw WasmException.create(Failure.INCOMPATIBLE_IMPORT_TYPE);
                    }
                    instance.setTarget(function.index(), functionInstance.target());
                    instance.setFunctionInstance(function.index(), functionInstance);
                } else {
                    CallTarget callTarget = function.target();
                    if (callTarget == null) {
                        ExecuteHostFunctionNode executableWrapper = new ExecuteHostFunctionNode(store.language(), module, function);
                        callTarget = executableWrapper.getCallTarget();
                        function.setImportedFunctionCallTarget(callTarget);
                    }
                    assert (((RootCallTarget)callTarget).getRootNode().getLanguage(WasmLanguage.class) == store.language());
                    WasmFunctionInstance functionInstance = new WasmFunctionInstance(store.context(), instance, function, callTarget);
                    functionInstance.setImportedFunction(externalFunctionInstance);
                    instance.setTarget(function.index(), functionInstance.target());
                    instance.setFunctionInstance(function.index(), functionInstance);
                }
                return;
            }
            WasmInstance importedInstance = store.lookupModuleInstance(function.importedModuleName());
            if (importedInstance == null) {
                throw WasmException.create(Failure.UNKNOWN_IMPORT, "The module '" + function.importedModuleName() + "', referenced by the import '" + function.importedFunctionName() + "' in the module '" + instance.name() + "', does not exist.");
            }
            WasmFunction importedFunction = (WasmFunction)importedInstance.module().exportedFunctions().get((Object)function.importedFunctionName());
            if (importedFunction == null) {
                throw WasmException.create(Failure.UNKNOWN_IMPORT, "The imported function '" + function.importedFunctionName() + "', referenced in the module '" + instance.name() + "', does not exist in the imported module '" + function.importedModuleName() + "'.");
            }
            if (!function.type().equals(importedFunction.type())) {
                throw WasmException.create(Failure.INCOMPATIBLE_IMPORT_TYPE);
            }
            CallTarget target = importedInstance.target(importedFunction.index());
            WasmFunctionInstance functionInstance = importedInstance.functionInstance(importedFunction);
            instance.setTarget(function.index(), target);
            instance.setFunctionInstance(function.index(), functionInstance);
        };
        ResolutionDag.Sym[] dependencies = new ResolutionDag.Sym[]{new ResolutionDag.ExportFunctionSym(function.importDescriptor().moduleName(), function.importDescriptor().memberName())};
        this.resolutionDag.resolveLater(new ResolutionDag.ImportFunctionSym(instance.name(), function.importDescriptor(), function.index()), dependencies, resolveAction);
    }

    void resolveFunctionExport(WasmModule module, int functionIndex, String exportedFunctionName) {
        ResolutionDag.Sym[] symArray;
        WasmFunction function = module.symbolTable().function(functionIndex);
        ImportDescriptor importDescriptor = function.importDescriptor();
        if (importDescriptor != null) {
            ResolutionDag.Sym[] symArray2 = new ResolutionDag.Sym[1];
            symArray = symArray2;
            symArray2[0] = new ResolutionDag.ImportFunctionSym(module.name(), importDescriptor, functionIndex);
        } else {
            symArray = ResolutionDag.NO_DEPENDENCIES;
        }
        ResolutionDag.Sym[] dependencies = symArray;
        this.resolutionDag.resolveLater(new ResolutionDag.ExportFunctionSym(module.name(), exportedFunctionName), dependencies, ResolutionDag.NO_RESOLVE_ACTION);
    }

    void resolveMemoryImport(WasmStore store, WasmInstance instance, ImportDescriptor importDescriptor, int memoryIndex, long declaredMinSize, long declaredMaxSize, boolean typeIndex64, boolean shared, ImportValueSupplier imports) {
        String importedModuleName = importDescriptor.moduleName();
        String importedMemoryName = importDescriptor.memberName();
        boolean importsMainMemory = instance.module().isBuiltin() && importedModuleName.equals("main") && importedMemoryName.equals("memory");
        Runnable resolveAction = () -> {
            WasmMemory importedMemory;
            WasmMemory externalMemory = Linker.lookupImportObject(instance, importDescriptor, imports, WasmMemory.class);
            if (externalMemory != null) {
                int contextMemoryIndex = store.memories().registerExternal(externalMemory);
                importedMemory = store.memories().memory(contextMemoryIndex);
                assert (memoryIndex == importDescriptor.targetIndex());
            } else {
                WasmInstance importedInstance;
                WasmInstance wasmInstance = importedInstance = importsMainMemory ? store.lookupMainModule() : store.lookupModuleInstance(importedModuleName);
                if (importedInstance == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, String.format("The module '%s', referenced in the import of memory '%s' in module '%s', does not exist", importedModuleName, importedMemoryName, instance.name()));
                }
                WasmModule importedModule = importedInstance.module();
                if (importedModule.exportedMemories().size() == 0) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, String.format("The imported module '%s' does not export any memories, so cannot resolve memory '%s' imported in module '%s'.", importedModuleName, importedMemoryName, instance.name()));
                }
                Integer exportedMemoryIndex = (Integer)importedModule.exportedMemories().get((Object)importedMemoryName);
                if (exportedMemoryIndex == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, "Memory '" + importedMemoryName + "', imported into module '" + instance.name() + "', was not exported in the module '" + importedModuleName + "'.");
                }
                importedMemory = importedInstance.memory(exportedMemoryIndex);
            }
            Assert.assertUnsignedLongLessOrEqual(declaredMinSize, importedMemory.minSize(), Failure.INCOMPATIBLE_IMPORT_TYPE);
            Assert.assertUnsignedLongGreaterOrEqual(declaredMaxSize, importedMemory.declaredMaxSize(), Failure.INCOMPATIBLE_IMPORT_TYPE);
            if (typeIndex64 != importedMemory.hasIndexType64()) {
                Assert.fail(Failure.INCOMPATIBLE_IMPORT_TYPE, "index types of memory import do not match");
            }
            if (shared != importedMemory.isShared()) {
                Assert.fail(Failure.INCOMPATIBLE_IMPORT_TYPE, "shared statuses of memory import do not match");
            }
            instance.setMemory(memoryIndex, importedMemory);
        };
        this.resolutionDag.resolveLater(new ResolutionDag.ImportMemorySym(instance.name(), importDescriptor, memoryIndex), new ResolutionDag.Sym[]{new ResolutionDag.ExportMemorySym(importedModuleName, importedMemoryName)}, resolveAction);
    }

    void resolveMemoryExport(WasmInstance instance, int memoryIndex, String exportedMemoryName) {
        ResolutionDag.Sym[] symArray;
        WasmModule module = instance.module();
        ImportDescriptor importDescriptor = module.symbolTable().importedMemory(memoryIndex);
        if (importDescriptor != null) {
            ResolutionDag.Sym[] symArray2 = new ResolutionDag.Sym[1];
            symArray = symArray2;
            symArray2[0] = new ResolutionDag.ImportMemorySym(module.name(), importDescriptor, memoryIndex);
        } else {
            symArray = ResolutionDag.NO_DEPENDENCIES;
        }
        ResolutionDag.Sym[] dependencies = symArray;
        this.resolutionDag.resolveLater(new ResolutionDag.ExportMemorySym(module.name(), exportedMemoryName), dependencies, () -> {});
    }

    private static Object lookupGlobal(WasmStore store, WasmInstance instance, int index) {
        int globalAddress = instance.globalAddress(index);
        Assert.assertTrue(globalAddress != Integer.MIN_VALUE, "The global variable '" + index + " referenced in a constant expression in module '" + instance.name() + "' was not initialized.", Failure.UNSPECIFIED_MALFORMED);
        byte type = instance.symbolTable().globalValueType(index);
        CompilerAsserts.partialEvaluationConstant((int)type);
        switch (type) {
            case 127: {
                return store.globals().loadAsInt(globalAddress);
            }
            case 125: {
                return Float.valueOf(Float.intBitsToFloat(store.globals().loadAsInt(globalAddress)));
            }
            case 126: {
                return store.globals().loadAsLong(globalAddress);
            }
            case 124: {
                return Double.longBitsToDouble(store.globals().loadAsLong(globalAddress));
            }
            case 123: {
                return store.globals().loadAsVector128(globalAddress);
            }
            case 111: 
            case 112: {
                return store.globals().loadAsReference(globalAddress);
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_TRAP, "Local variable cannot have the void type.");
    }

    public static Object evalConstantExpression(WasmStore store, WasmInstance instance, byte[] bytecode) {
        int offset = 0;
        ArrayList<Object> stack = new ArrayList<Object>();
        block25: while (offset < bytecode.length) {
            int opcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
            ++offset;
            switch (opcode) {
                case 37: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    stack.add(Linker.lookupGlobal(store, instance, index));
                    continue block25;
                }
                case 38: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    stack.add(Linker.lookupGlobal(store, instance, index));
                    continue block25;
                }
                case 112: {
                    byte value = BinaryStreamParser.rawPeekI8(bytecode, offset);
                    ++offset;
                    stack.add(Integer.valueOf(value));
                    continue block25;
                }
                case 113: {
                    int value = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    stack.add(value);
                    continue block25;
                }
                case 114: {
                    long value = BinaryStreamParser.rawPeekI8(bytecode, offset);
                    ++offset;
                    stack.add(value);
                    continue block25;
                }
                case 115: {
                    long value = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                    stack.add(value);
                    continue block25;
                }
                case 116: {
                    float value = Float.intBitsToFloat(BinaryStreamParser.rawPeekI32(bytecode, offset));
                    offset += 4;
                    stack.add(Float.valueOf(value));
                    continue block25;
                }
                case 117: {
                    double value = Double.longBitsToDouble(BinaryStreamParser.rawPeekI64(bytecode, offset));
                    offset += 8;
                    stack.add(value);
                    continue block25;
                }
                case 12: {
                    Vector128 value = new Vector128(BinaryStreamParser.rawPeekI128(bytecode, offset));
                    offset += 16;
                    stack.add(value);
                    continue block25;
                }
                case 246: {
                    stack.add(WasmConstant.NULL);
                    continue block25;
                }
                case 248: {
                    int functionIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    WasmFunction function = instance.symbolTable().function(functionIndex);
                    WasmFunctionInstance functionInstance = instance.functionInstance(function);
                    stack.add(functionInstance);
                    offset += 4;
                    continue block25;
                }
                case 155: 
                case 156: 
                case 157: {
                    int x = (Integer)stack.remove(stack.size() - 1);
                    int y = (Integer)stack.remove(stack.size() - 1);
                    int result = switch (opcode) {
                        case 155 -> y + x;
                        case 156 -> y - x;
                        case 157 -> y * x;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    stack.add(result);
                    continue block25;
                }
                case 173: 
                case 174: 
                case 175: {
                    long x = (Long)stack.remove(stack.size() - 1);
                    long y = (Long)stack.remove(stack.size() - 1);
                    long result = switch (opcode) {
                        case 173 -> y + x;
                        case 174 -> y - x;
                        case 175 -> y * x;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    stack.add(result);
                    continue block25;
                }
            }
            Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid bytecode instruction for constant expression: 0x%02X", opcode);
        }
        assert (stack.size() == 1);
        return stack.get(0);
    }

    private static List<ResolutionDag.Sym> dependenciesOfConstantExpression(WasmInstance instance, byte[] bytecode) {
        ArrayList<ResolutionDag.Sym> dependencies = new ArrayList<ResolutionDag.Sym>();
        int offset = 0;
        block10: while (offset < bytecode.length) {
            int opcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
            ++offset;
            switch (opcode) {
                case 37: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    dependencies.add(new ResolutionDag.InitializeGlobalSym(instance.name(), index));
                    continue block10;
                }
                case 38: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    dependencies.add(new ResolutionDag.InitializeGlobalSym(instance.name(), index));
                    continue block10;
                }
                case 112: 
                case 114: {
                    ++offset;
                    continue block10;
                }
                case 113: 
                case 116: {
                    offset += 4;
                    continue block10;
                }
                case 115: 
                case 117: {
                    offset += 8;
                    continue block10;
                }
                case 12: {
                    offset += 16;
                    continue block10;
                }
                case 248: {
                    int functionIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    WasmFunction function = instance.symbolTable().function(functionIndex);
                    if (function.importDescriptor() != null) {
                        dependencies.add(new ResolutionDag.ImportFunctionSym(instance.name(), function.importDescriptor(), functionIndex));
                    }
                    offset += 4;
                    continue block10;
                }
                case 155: 
                case 156: 
                case 157: 
                case 173: 
                case 174: 
                case 175: 
                case 246: {
                    continue block10;
                }
            }
            Assert.fail(Failure.ILLEGAL_OPCODE, "Invalid bytecode instruction for constant expression: 0x%02X", opcode);
        }
        return dependencies;
    }

    void resolveDataSegment(WasmStore store, WasmInstance instance, int dataSegmentId, int memoryIndex, long offsetAddress, byte[] offsetBytecode, int byteLength, int bytecodeOffset, int droppedDataInstanceOffset) {
        Assert.assertUnsignedIntLess(memoryIndex, instance.symbolTable().memoryCount(), Failure.UNSPECIFIED_MALFORMED, "Specified memory was not declared or imported in the module '%s'", instance.name());
        Runnable resolveAction = () -> {
            if (store.getContextOptions().memoryOverheadMode()) {
                return;
            }
            WasmMemory memory = instance.memory(memoryIndex);
            long baseAddress = offsetBytecode != null ? ((Number)Linker.evalConstantExpression(store, instance, offsetBytecode)).longValue() : offsetAddress;
            WasmMemoryLibrary memoryLib = WasmMemoryLibrary.getUncached();
            byte[] bytecode = instance.module().bytecode();
            memoryLib.initialize(memory, null, bytecode, bytecodeOffset, baseAddress, byteLength);
            instance.setDataInstance(dataSegmentId, droppedDataInstanceOffset);
        };
        ArrayList<ResolutionDag.Sym> dependencies = new ArrayList<ResolutionDag.Sym>();
        if (instance.symbolTable().importedMemory(memoryIndex) != null) {
            dependencies.add(new ResolutionDag.ImportMemorySym(instance.name(), instance.symbolTable().importedMemory(memoryIndex), memoryIndex));
        }
        if (dataSegmentId > 0) {
            dependencies.add(new ResolutionDag.DataSym(instance.name(), dataSegmentId - 1));
        }
        if (offsetBytecode != null) {
            dependencies.addAll(Linker.dependenciesOfConstantExpression(instance, offsetBytecode));
        }
        this.resolutionDag.resolveLater(new ResolutionDag.DataSym(instance.name(), dataSegmentId), dependencies.toArray(new ResolutionDag.Sym[0]), resolveAction);
    }

    void resolvePassiveDataSegment(WasmStore store, WasmInstance instance, int dataSegmentId, int bytecodeOffset) {
        Runnable resolveAction = () -> {
            if (store.getContextOptions().memoryOverheadMode()) {
                return;
            }
            instance.setDataInstance(dataSegmentId, bytecodeOffset);
        };
        ArrayList<ResolutionDag.DataSym> dependencies = new ArrayList<ResolutionDag.DataSym>();
        if (dataSegmentId > 0) {
            dependencies.add(new ResolutionDag.DataSym(instance.name(), dataSegmentId - 1));
        }
        this.resolutionDag.resolveLater(new ResolutionDag.DataSym(instance.name(), dataSegmentId), dependencies.toArray(new ResolutionDag.Sym[0]), resolveAction);
    }

    void resolveTableImport(WasmStore store, WasmInstance instance, ImportDescriptor importDescriptor, int tableIndex, int declaredMinSize, int declaredMaxSize, byte elemType, ImportValueSupplier imports) {
        Runnable resolveAction = () -> {
            int tableAddress;
            WasmTable externalTable = Linker.lookupImportObject(instance, importDescriptor, imports, WasmTable.class);
            if (externalTable != null) {
                assert (tableIndex == importDescriptor.targetIndex());
                tableAddress = store.tables().registerExternal(externalTable);
            } else {
                WasmInstance importedInstance = store.lookupModuleInstance(importDescriptor.moduleName());
                String importedModuleName = importDescriptor.moduleName();
                if (importedInstance == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, String.format("Imported module '%s', referenced in module '%s', does not exist.", importedModuleName, instance.name()));
                }
                WasmModule importedModule = importedInstance.module();
                String importedTableName = importDescriptor.memberName();
                if (importedModule.exportedTables().size() == 0) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, String.format("The imported module '%s' does not export any tables, so cannot resolve table '%s' imported in module '%s'.", importedModuleName, importedTableName, instance.name()));
                }
                Integer exportedTableIndex = (Integer)importedModule.exportedTables().get((Object)importedTableName);
                if (exportedTableIndex == null) {
                    throw WasmException.create(Failure.UNKNOWN_IMPORT, "Table '" + importedTableName + "', imported into module '" + instance.name() + "', was not exported in the module '" + importedModuleName + "'.");
                }
                tableAddress = importedInstance.tableAddress(exportedTableIndex);
            }
            WasmTable importedTable = store.tables().table(tableAddress);
            Assert.assertUnsignedIntLessOrEqual(declaredMinSize, importedTable.minSize(), Failure.INCOMPATIBLE_IMPORT_TYPE);
            Assert.assertUnsignedIntGreaterOrEqual(declaredMaxSize, importedTable.declaredMaxSize(), Failure.INCOMPATIBLE_IMPORT_TYPE);
            Assert.assertByteEqual(elemType, importedTable.elemType(), Failure.INCOMPATIBLE_IMPORT_TYPE);
            instance.setTableAddress(tableIndex, tableAddress);
        };
        ResolutionDag.Sym[] dependencies = new ResolutionDag.Sym[]{new ResolutionDag.ExportTableSym(importDescriptor.moduleName(), importDescriptor.memberName())};
        this.resolutionDag.resolveLater(new ResolutionDag.ImportTableSym(instance.name(), importDescriptor), dependencies, resolveAction);
    }

    void resolveTableExport(WasmModule module, int tableIndex, String exportedTableName) {
        ResolutionDag.Sym[] symArray;
        ImportDescriptor importDescriptor = module.symbolTable().importedTable(tableIndex);
        if (importDescriptor != null) {
            ResolutionDag.Sym[] symArray2 = new ResolutionDag.Sym[1];
            symArray = symArray2;
            symArray2[0] = new ResolutionDag.ImportTableSym(module.name(), importDescriptor);
        } else {
            symArray = ResolutionDag.NO_DEPENDENCIES;
        }
        ResolutionDag.Sym[] dependencies = symArray;
        this.resolutionDag.resolveLater(new ResolutionDag.ExportTableSym(module.name(), exportedTableName), dependencies, ResolutionDag.NO_RESOLVE_ACTION);
    }

    private static void addElemItemDependencies(WasmInstance instance, int bytecodeOffset, int elementCount, ArrayList<ResolutionDag.Sym> dependencies) {
        int elementOffset = bytecodeOffset;
        byte[] bytecode = instance.module().bytecode();
        for (int elementIndex = 0; elementIndex != elementCount; ++elementIndex) {
            int index;
            int opcode = BinaryStreamParser.rawPeekU8(bytecode, elementOffset);
            ++elementOffset;
            int type = opcode & 0x80;
            int length = opcode & 0x60;
            if ((opcode & 0x10) != 0) continue;
            switch (length) {
                case 0: {
                    index = opcode & 0xF;
                    break;
                }
                case 32: {
                    index = BinaryStreamParser.rawPeekU8(bytecode, elementOffset);
                    ++elementOffset;
                    break;
                }
                case 64: {
                    index = BinaryStreamParser.rawPeekU16(bytecode, elementOffset);
                    elementOffset += 2;
                    break;
                }
                case 96: {
                    index = BinaryStreamParser.rawPeekI32(bytecode, elementOffset);
                    elementOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (type == 0) {
                WasmFunction function = instance.module().function(index);
                if (function.importDescriptor() == null) continue;
                dependencies.add(new ResolutionDag.ImportFunctionSym(instance.name(), function.importDescriptor(), function.index()));
                continue;
            }
            dependencies.add(new ResolutionDag.InitializeGlobalSym(instance.name(), index));
        }
    }

    private static Object[] extractElemItems(WasmStore store, WasmInstance instance, int bytecodeOffset, int elementCount) {
        int elementOffset = bytecodeOffset;
        byte[] bytecode = instance.module().bytecode();
        Object[] elemItems = new Object[elementCount];
        for (int elementIndex = 0; elementIndex != elementCount; ++elementIndex) {
            int index;
            int opcode = BinaryStreamParser.rawPeekU8(bytecode, elementOffset);
            ++elementOffset;
            int type = opcode & 0x80;
            int length = opcode & 0x60;
            if ((opcode & 0x10) != 0) {
                elemItems[elementIndex] = WasmConstant.NULL;
                continue;
            }
            switch (length) {
                case 0: {
                    index = opcode & 0xF;
                    break;
                }
                case 32: {
                    index = BinaryStreamParser.rawPeekU8(bytecode, elementOffset);
                    ++elementOffset;
                    break;
                }
                case 64: {
                    index = BinaryStreamParser.rawPeekU16(bytecode, elementOffset);
                    elementOffset += 2;
                    break;
                }
                case 96: {
                    index = BinaryStreamParser.rawPeekI32(bytecode, elementOffset);
                    elementOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (type == 0) {
                WasmFunction function = instance.module().function(index);
                elemItems[elementIndex] = instance.functionInstance(function);
                continue;
            }
            int globalAddress = instance.globalAddress(index);
            elemItems[elementIndex] = store.globals().loadAsReference(globalAddress);
        }
        return elemItems;
    }

    void resolveElemSegment(WasmStore store, WasmInstance instance, int tableIndex, int elemSegmentId, int offsetAddress, byte[] offsetBytecode, int bytecodeOffset, int elementCount) {
        Runnable resolveAction = () -> this.immediatelyResolveElemSegment(store, instance, tableIndex, offsetAddress, offsetBytecode, bytecodeOffset, elementCount);
        ArrayList<ResolutionDag.Sym> dependencies = new ArrayList<ResolutionDag.Sym>();
        if (instance.symbolTable().importedTable(tableIndex) != null) {
            dependencies.add(new ResolutionDag.ImportTableSym(instance.name(), instance.symbolTable().importedTable(tableIndex)));
        }
        if (elemSegmentId > 0) {
            dependencies.add(new ResolutionDag.ElemSym(instance.name(), elemSegmentId - 1));
        }
        if (offsetBytecode != null) {
            dependencies.addAll(Linker.dependenciesOfConstantExpression(instance, offsetBytecode));
        }
        Linker.addElemItemDependencies(instance, bytecodeOffset, elementCount, dependencies);
        this.resolutionDag.resolveLater(new ResolutionDag.ElemSym(instance.name(), elemSegmentId), dependencies.toArray(new ResolutionDag.Sym[0]), resolveAction);
    }

    public void immediatelyResolveElemSegment(WasmStore store, WasmInstance instance, int tableIndex, int offsetAddress, byte[] offsetBytecode, int bytecodeOffset, int elementCount) {
        if (store.getContextOptions().memoryOverheadMode()) {
            return;
        }
        Assert.assertTrue(instance.symbolTable().checkTableIndex(tableIndex), String.format("No table declared or imported in the module '%s'", instance.name()), Failure.UNSPECIFIED_MALFORMED);
        int tableAddress = instance.tableAddress(tableIndex);
        WasmTable table = store.tables().table(tableAddress);
        Assert.assertNotNull(table, String.format("No table declared or imported in the module '%s'", instance.name()), Failure.UNKNOWN_TABLE);
        int baseAddress = offsetBytecode != null ? (Integer)Linker.evalConstantExpression(store, instance, offsetBytecode) : offsetAddress;
        Assert.assertUnsignedIntLessOrEqual(baseAddress, table.size(), Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        Assert.assertUnsignedIntLessOrEqual(baseAddress + elementCount, table.size(), Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        Object[] elemSegment = Linker.extractElemItems(store, instance, bytecodeOffset, elementCount);
        table.initialize(elemSegment, 0, baseAddress, elementCount);
    }

    void resolvePassiveElemSegment(WasmStore store, WasmInstance instance, int elemSegmentId, int bytecodeOffset, int elementCount) {
        Runnable resolveAction = () -> this.immediatelyResolvePassiveElementSegment(store, instance, elemSegmentId, bytecodeOffset, elementCount);
        ArrayList<ResolutionDag.Sym> dependencies = new ArrayList<ResolutionDag.Sym>();
        if (elemSegmentId > 0) {
            dependencies.add(new ResolutionDag.ElemSym(instance.name(), elemSegmentId - 1));
        }
        Linker.addElemItemDependencies(instance, bytecodeOffset, elementCount, dependencies);
        this.resolutionDag.resolveLater(new ResolutionDag.ElemSym(instance.name(), elemSegmentId), dependencies.toArray(new ResolutionDag.Sym[0]), resolveAction);
    }

    public void immediatelyResolvePassiveElementSegment(WasmStore store, WasmInstance instance, int elemSegmentId, int bytecodeOffset, int elementCount) {
        if (store.getContextOptions().memoryOverheadMode()) {
            return;
        }
        Object[] initialValues = Linker.extractElemItems(store, instance, bytecodeOffset, elementCount);
        instance.setElemInstance(elemSegmentId, initialValues);
    }

    public static enum LinkState {
        nonLinked,
        inProgress,
        linked,
        failed;

    }

    static class ResolutionDag {
        public static final Runnable NO_RESOLVE_ACTION = () -> {};
        private static final Sym[] NO_DEPENDENCIES = new Sym[0];
        private final Map<Sym, Resolver> resolutions = new LinkedHashMap<Sym, Resolver>();

        ResolutionDag() {
        }

        void resolveLater(Sym element, Sym[] dependencies, Runnable action) {
            this.resolutions.put(element, new Resolver(element, dependencies, action));
        }

        private static String renderCycle(List<Sym> stack) {
            StringBuilder result = new StringBuilder();
            String arrow = "";
            for (Sym sym : stack) {
                result.append(arrow).append(sym.toString());
                arrow = " -> ";
            }
            return result.toString();
        }

        private void toposort(Sym sym, Map<Sym, Boolean> marks, ArrayList<Resolver> sorted, List<Sym> stack) {
            Resolver resolver = this.resolutions.get(sym);
            if (resolver != null) {
                Boolean mark = marks.get(sym);
                if (Boolean.TRUE.equals(mark)) {
                    return;
                }
                if (Boolean.FALSE.equals(mark)) {
                    throw WasmException.create(Failure.UNSPECIFIED_UNLINKABLE, String.format("Detected a cycle in the import dependencies: %s", ResolutionDag.renderCycle(stack)));
                }
                marks.put(sym, Boolean.FALSE);
                stack.add(sym);
                for (Sym dependency : resolver.dependencies) {
                    this.toposort(dependency, marks, sorted, stack);
                }
                marks.put(sym, Boolean.TRUE);
                stack.remove(stack.size() - 1);
                sorted.add(resolver);
            }
        }

        Resolver[] toposort() {
            HashMap<Sym, Boolean> marks = new HashMap<Sym, Boolean>();
            ArrayList<Resolver> sorted = new ArrayList<Resolver>();
            for (Sym sym : this.resolutions.keySet()) {
                this.toposort(sym, marks, sorted, new ArrayList<Sym>());
            }
            return sorted.toArray(new Resolver[0]);
        }

        static class Resolver {
            final Sym element;
            final Sym[] dependencies;
            Runnable action;

            Resolver(Sym element, Sym[] dependencies, Runnable action) {
                this.element = element;
                this.dependencies = dependencies;
                this.action = action;
            }

            public String toString() {
                return "Resolver(" + String.valueOf(this.element) + ")";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runActionOnce(WasmStore store, ArrayList<Throwable> failures) {
                if (this.action != null) {
                    WasmInstance instance = this.element.instance(store);
                    try {
                        if (instance != null && !instance.isLinkFailed()) {
                            for (Sym dependency : this.dependencies) {
                                WasmInstance dependencyInstance = dependency.instance(store);
                                if (dependencyInstance == null || !dependencyInstance.isLinkFailed()) continue;
                                instance.setLinkFailed();
                                break;
                            }
                        }
                        if (instance == null || !instance.isLinkFailed()) {
                            this.action.run();
                        }
                    }
                    catch (Throwable e) {
                        if (instance != null) {
                            instance.setLinkFailed();
                        }
                        failures.add(e);
                    }
                    finally {
                        this.action = null;
                    }
                }
            }
        }

        static abstract class Sym {
            final String moduleName;

            protected Sym(String moduleName) {
                this.moduleName = moduleName;
            }

            public String moduleName() {
                return this.moduleName;
            }

            public WasmInstance instance(WasmStore store) {
                return store.lookupModuleInstance(this.moduleName);
            }
        }

        static class ElemSym
        extends Sym {
            final int elemSegmentId;

            ElemSym(String moduleName, int dataSegmentId) {
                super(moduleName);
                this.elemSegmentId = dataSegmentId;
            }

            public String toString() {
                return String.format(Locale.ROOT, "(data %d in %s)", this.elemSegmentId, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.elemSegmentId;
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElemSym)) {
                    return false;
                }
                ElemSym that = (ElemSym)object;
                return this.elemSegmentId == that.elemSegmentId && this.moduleName.equals(that.moduleName);
            }
        }

        static class ExportTableSym
        extends Sym {
            final String tableName;

            ExportTableSym(String moduleName, String tableName) {
                super(moduleName);
                this.tableName = tableName;
            }

            public String toString() {
                return String.format("(export memory %s from %s)", this.tableName, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.tableName.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof ExportTableSym)) {
                    return false;
                }
                ExportTableSym that = (ExportTableSym)object;
                return this.moduleName.equals(that.moduleName) && this.tableName.equals(that.tableName);
            }
        }

        static class ImportTableSym
        extends Sym {
            final ImportDescriptor importDescriptor;

            ImportTableSym(String moduleName, ImportDescriptor importDescriptor) {
                super(moduleName);
                this.importDescriptor = importDescriptor;
            }

            public String toString() {
                return String.format("(import memory %s from %s into %s)", this.importDescriptor.memberName(), this.importDescriptor.moduleName(), this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.importDescriptor.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof ImportTableSym)) {
                    return false;
                }
                ImportTableSym that = (ImportTableSym)object;
                return this.moduleName.equals(that.moduleName) && this.importDescriptor.equals(that.importDescriptor);
            }
        }

        static class DataSym
        extends Sym {
            final int dataSegmentId;

            DataSym(String moduleName, int dataSegmentId) {
                super(moduleName);
                this.dataSegmentId = dataSegmentId;
            }

            public String toString() {
                return String.format(Locale.ROOT, "(data %d in %s)", this.dataSegmentId, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.dataSegmentId;
            }

            public boolean equals(Object object) {
                if (!(object instanceof DataSym)) {
                    return false;
                }
                DataSym that = (DataSym)object;
                return this.dataSegmentId == that.dataSegmentId && this.moduleName.equals(that.moduleName);
            }
        }

        static class ExportMemorySym
        extends Sym {
            final String memoryName;

            ExportMemorySym(String moduleName, String memoryName) {
                super(moduleName);
                this.memoryName = memoryName;
            }

            public String toString() {
                return String.format("(export memory %s from %s)", this.memoryName, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.memoryName.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof ExportMemorySym)) {
                    return false;
                }
                ExportMemorySym that = (ExportMemorySym)object;
                return this.moduleName.equals(that.moduleName) && this.memoryName.equals(that.memoryName);
            }
        }

        static class ImportMemorySym
        extends Sym {
            final ImportDescriptor importDescriptor;
            final int memoryIndex;

            ImportMemorySym(String moduleName, ImportDescriptor importDescriptor, int memoryIndex) {
                super(moduleName);
                this.importDescriptor = importDescriptor;
                this.memoryIndex = memoryIndex;
            }

            public String toString() {
                return String.format(Locale.ROOT, "(import memory %s from %s into %s with index %d)", this.importDescriptor.memberName(), this.importDescriptor.moduleName(), this.moduleName, this.memoryIndex);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.importDescriptor.hashCode() ^ this.memoryIndex;
            }

            public boolean equals(Object object) {
                if (!(object instanceof ImportMemorySym)) {
                    return false;
                }
                ImportMemorySym that = (ImportMemorySym)object;
                return this.moduleName.equals(that.moduleName) && this.importDescriptor.equals(that.importDescriptor) && this.memoryIndex == that.memoryIndex;
            }
        }

        static class ExportFunctionSym
        extends Sym {
            final String functionName;

            ExportFunctionSym(String moduleName, String functionName) {
                super(moduleName);
                this.functionName = functionName;
            }

            public String toString() {
                return String.format("(export func %s from %s)", this.functionName, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.functionName.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof ExportFunctionSym)) {
                    return false;
                }
                ExportFunctionSym that = (ExportFunctionSym)object;
                return this.moduleName.equals(that.moduleName) && this.functionName.equals(that.functionName);
            }
        }

        static class ImportFunctionSym
        extends Sym {
            final ImportDescriptor importDescriptor;
            final int destinationIndex;

            ImportFunctionSym(String moduleName, ImportDescriptor importDescriptor, int destinationIndex) {
                super(Objects.requireNonNull(moduleName));
                this.importDescriptor = Objects.requireNonNull(importDescriptor);
                this.destinationIndex = destinationIndex;
            }

            public String toString() {
                return String.format(Locale.ROOT, "(import func %s from %s into %s at %d)", this.importDescriptor.memberName(), this.importDescriptor.moduleName(), this.moduleName, this.destinationIndex);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ImportFunctionSym that = (ImportFunctionSym)o;
                return this.destinationIndex == that.destinationIndex && this.moduleName.equals(that.moduleName) && this.importDescriptor.equals(that.importDescriptor);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.importDescriptor.hashCode() ^ this.destinationIndex;
            }
        }

        static class InitializeGlobalSym
        extends Sym {
            final int globalIndex;

            InitializeGlobalSym(String moduleName, int globalIndex) {
                super(moduleName);
                this.globalIndex = globalIndex;
            }

            public String toString() {
                return String.format(Locale.ROOT, "(init global %d in %s)", this.globalIndex, this.moduleName);
            }

            public int hashCode() {
                return Integer.hashCode(this.globalIndex) ^ this.moduleName.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof InitializeGlobalSym)) {
                    return false;
                }
                InitializeGlobalSym that = (InitializeGlobalSym)object;
                return this.globalIndex == that.globalIndex && this.moduleName.equals(that.moduleName);
            }
        }

        static class ExportGlobalSym
        extends Sym {
            final String globalName;

            ExportGlobalSym(String moduleName, String globalName) {
                super(moduleName);
                this.globalName = globalName;
            }

            public String toString() {
                return String.format("(export global %s from %s)", this.globalName, this.moduleName);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.globalName.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof ExportGlobalSym)) {
                    return false;
                }
                ExportGlobalSym that = (ExportGlobalSym)object;
                return this.moduleName.equals(that.moduleName) && this.globalName.equals(that.globalName);
            }
        }

        static class ImportGlobalSym
        extends Sym {
            final ImportDescriptor importDescriptor;
            final int destinationIndex;

            ImportGlobalSym(String moduleName, ImportDescriptor importDescriptor, int destinationIndex) {
                super(moduleName);
                this.importDescriptor = importDescriptor;
                this.destinationIndex = destinationIndex;
            }

            public String toString() {
                return String.format("(import global %s from %s into %s)", this.importDescriptor.memberName(), this.importDescriptor.moduleName(), this.moduleName);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ImportGlobalSym that = (ImportGlobalSym)o;
                return this.destinationIndex == that.destinationIndex && Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.importDescriptor, that.importDescriptor);
            }

            public int hashCode() {
                return this.moduleName.hashCode() ^ this.importDescriptor.hashCode() ^ this.destinationIndex;
            }
        }
    }
}

