/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmType;

@ExportLibrary(value=InteropLibrary.class)
public class WasmConstant
implements TruffleObject {
    public static final WasmConstant VOID = new WasmConstant("wasm-void-result", WasmType.VOID, false);
    public static final WasmConstant NULL = new WasmConstant("wasm-ref-null", WasmType.NULL, true);
    public static final WasmConstant MULTI_VALUE = new WasmConstant("wasm-multi-value-result", WasmType.MULTI_VALUE, false);
    public static final Object RETURN_VALUE = new Object();
    private final String name;
    private final Object metaObject;
    private final boolean isNull;

    protected WasmConstant(String name, Object metaObject, boolean isNull) {
        this.name = name;
        this.metaObject = metaObject;
        this.isNull = isNull;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return this.metaObject;
    }

    @ExportMessage(name="toDisplayString")
    Object toDisplayString(boolean allowSideEffects) {
        return this.name;
    }

    @ExportMessage
    boolean isNull() {
        return this.isNull;
    }

    public String toString() {
        return this.name;
    }
}

