/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging;

import java.nio.file.Path;
import java.util.SortedSet;
import java.util.TreeSet;
import org.graalvm.collections.EconomicMap;

public class DebugLineMap {
    private final Path filePath;
    private final SortedSet<Integer> lines;
    private final EconomicMap<Integer, Integer> sourceLocationToLineMap;
    private final EconomicMap<Integer, Integer> lineToSourceLocationMap;

    public DebugLineMap(Path filePath) {
        this.filePath = filePath;
        this.lines = new TreeSet<Integer>();
        this.sourceLocationToLineMap = EconomicMap.create();
        this.lineToSourceLocationMap = EconomicMap.create();
    }

    public void add(int sourceLocation, int line) {
        if (!this.lines.contains(line)) {
            this.lines.add(line);
            this.lineToSourceLocationMap.put((Object)line, (Object)sourceLocation);
        }
        this.sourceLocationToLineMap.put((Object)sourceLocation, (Object)line);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public int getLine(int sourceLocation) {
        if (!this.sourceLocationToLineMap.containsKey((Object)sourceLocation)) {
            return -1;
        }
        return (Integer)this.sourceLocationToLineMap.get((Object)sourceLocation);
    }

    public int getSourceLocation(int line) {
        if (!this.lineToSourceLocationMap.containsKey((Object)line)) {
            return -1;
        }
        return (Integer)this.lineToSourceLocationMap.get((Object)line);
    }

    public int size() {
        return this.lineToSourceLocationMap.size();
    }

    public SortedSet<Integer> lines() {
        return this.lines;
    }

    public EconomicMap<Integer, Integer> sourceLocationToLineMap() {
        return this.sourceLocationToLineMap;
    }
}

