/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;

public class DebugRelocatedMember
extends DebugObject {
    private final DebugLocation objectLocation;
    private final DebugObject object;

    public DebugRelocatedMember(DebugLocation objectLocation, DebugObject object) {
        assert (objectLocation != null) : "the location of a relocatable debug member must not be null";
        assert (object != null) : "the object reference of a relocatable debug member must not be null";
        this.objectLocation = objectLocation;
        this.object = object;
    }

    @Override
    public String toDisplayString() {
        return this.object.toDisplayString();
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return this.objectLocation;
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context;
    }

    @Override
    public String asTypeName() {
        return this.object.asTypeName();
    }

    @Override
    public int valueLength() {
        return this.object.valueLength();
    }

    @Override
    public boolean isDebugObject() {
        return true;
    }

    @Override
    public DebugObject asDebugObject(DebugContext context, DebugLocation location) {
        return this.object;
    }
}

