/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.nodes.WasmFixedMemoryImplFunctionNodeGen;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;

public abstract class WasmFixedMemoryImplFunctionNode
extends Node {
    private final WasmModule module;
    private final WasmCodeEntry codeEntry;
    private final int bytecodeStartOffset;
    private final int bytecodeEndOffset;
    private final Node[] callNodes;
    private static final WasmInstrumentableFunctionNode[] EMPTY_INSTRUMENTABLE_FUNCTION_NODES = new WasmInstrumentableFunctionNode[0];
    @Node.Children
    private WasmInstrumentableFunctionNode[] instrumentableFunctionNodes = EMPTY_INSTRUMENTABLE_FUNCTION_NODES;

    protected WasmFixedMemoryImplFunctionNode(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes) {
        this.module = module;
        this.codeEntry = codeEntry;
        this.bytecodeStartOffset = bytecodeStartOffset;
        this.bytecodeEndOffset = bytecodeEndOffset;
        this.callNodes = callNodes;
    }

    public static WasmFixedMemoryImplFunctionNode create(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes) {
        return WasmFixedMemoryImplFunctionNodeGen.create(module, codeEntry, bytecodeStartOffset, bytecodeEndOffset, callNodes);
    }

    @Specialization(guards={"memoryCount() == 1"}, limit="3")
    protected void doFixedMemoryImpl(VirtualFrame frame, WasmInstance instance, @CachedLibrary(value="instance.memory(0)") WasmMemoryLibrary cachedMemoryLib0, @Cached(value="createMemoryLibs1(cachedMemoryLib0)") WasmMemoryLibrary[] cachedMemoryLibs, @Cached(value="createSpecializedFunctionNode(cachedMemoryLibs)", adopt=false) WasmInstrumentableFunctionNode specializedFunctionNode) {
        specializedFunctionNode.execute(frame, instance);
    }

    @Specialization(replaces={"doFixedMemoryImpl"})
    protected void doDispatched(VirtualFrame frame, WasmInstance instance, @Cached(value="createDispatchedFunctionNode()", adopt=false) WasmInstrumentableFunctionNode dispatchedFunctionNode) {
        dispatchedFunctionNode.execute(frame, instance);
    }

    @NeverDefault
    protected WasmMemoryLibrary[] createMemoryLibs1(WasmMemoryLibrary memoryLibs) {
        return new WasmMemoryLibrary[]{memoryLibs};
    }

    @Idempotent
    protected int memoryCount() {
        return this.module.memoryCount();
    }

    @NeverDefault
    protected WasmInstrumentableFunctionNode createSpecializedFunctionNode(WasmMemoryLibrary[] memoryLibs) {
        CompilerAsserts.neverPartOfCompilation();
        WasmInstrumentableFunctionNode instrumentableFunctionNode = new WasmInstrumentableFunctionNode(this.module, this.codeEntry, this.bytecodeStartOffset, this.bytecodeEndOffset, this.callNodes, memoryLibs);
        this.instrumentableFunctionNodes = Arrays.copyOf(this.instrumentableFunctionNodes, this.instrumentableFunctionNodes.length + 1);
        this.instrumentableFunctionNodes[this.instrumentableFunctionNodes.length - 1] = (WasmInstrumentableFunctionNode)this.insert(instrumentableFunctionNode);
        this.notifyInserted(instrumentableFunctionNode);
        return instrumentableFunctionNode;
    }

    @NeverDefault
    protected WasmInstrumentableFunctionNode createDispatchedFunctionNode() {
        CompilerAsserts.neverPartOfCompilation();
        WasmMemoryLibrary[] memoryLibs = new WasmMemoryLibrary[this.module.memoryCount()];
        for (int memoryIndex = 0; memoryIndex < this.module.memoryCount(); ++memoryIndex) {
            memoryLibs[memoryIndex] = (WasmMemoryLibrary)this.insert((Node)((WasmMemoryLibrary)WasmMemoryLibrary.getFactory().createDispatched(3)));
        }
        WasmInstrumentableFunctionNode instrumentableFunctionNode = new WasmInstrumentableFunctionNode(this.module, this.codeEntry, this.bytecodeStartOffset, this.bytecodeEndOffset, this.callNodes, memoryLibs);
        this.instrumentableFunctionNodes = new WasmInstrumentableFunctionNode[]{(WasmInstrumentableFunctionNode)this.insert(instrumentableFunctionNode)};
        this.notifyInserted(instrumentableFunctionNode);
        return instrumentableFunctionNode;
    }

    public abstract void execute(VirtualFrame var1, WasmInstance var2);

    final Node[] getCallNodes() {
        return this.callNodes;
    }
}

