/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.nodes.WasmCallNode;

@NodeInfo(language="wasm", description="The root node of all WebAssembly functions")
public abstract class WasmRootNode
extends RootNode {
    private final WasmModule module;
    private final BranchProfile nonLinkedProfile = BranchProfile.create();
    @CompilerDirectives.CompilationFinal
    private WasmInstance boundInstance;

    public WasmRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, WasmModule module) {
        super(language, frameDescriptor);
        this.module = module;
    }

    protected final WasmContext getContext() {
        return WasmContext.get((Node)this);
    }

    protected WasmModule module() {
        return this.module;
    }

    public final void tryInitialize(WasmInstance instance) {
        if (!instance.isLinkCompleted()) {
            this.nonLinkedProfile.enter();
            instance.store().linker().tryLink(instance);
        }
    }

    protected int findBytecodeIndex(Node node, Frame frame) {
        if (node == null) {
            return -1;
        }
        if (node instanceof WasmCallNode) {
            WasmCallNode n = (WasmCallNode)node;
            return n.getBytecodeOffset();
        }
        return -1;
    }

    protected final WasmInstance instance(VirtualFrame frame) {
        WasmInstance instance = this.boundInstance;
        if (instance == null) {
            instance = WasmArguments.getModuleInstance(frame.getArguments());
        } else {
            CompilerAsserts.partialEvaluationConstant((Object)instance);
            assert (instance == WasmArguments.getModuleInstance(frame.getArguments()));
        }
        assert (instance == instance.store().lookupModuleInstance(this.module()));
        return instance;
    }

    public final void setBoundModuleInstance(WasmInstance boundInstance) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.boundInstance == null);
        this.boundInstance = boundInstance;
    }

    public Object execute(VirtualFrame frame) {
        assert (WasmArguments.isValid(frame.getArguments()));
        WasmInstance instance = this.instance(frame);
        this.tryInitialize(instance);
        return this.executeWithInstance(frame, instance);
    }

    public abstract Object executeWithInstance(VirtualFrame var1, WasmInstance var2);

    public final String toString() {
        return this.getName();
    }

    protected boolean isInstrumentable() {
        return false;
    }
}

