/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.nodes.Node;
import java.io.Closeable;
import java.io.IOException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.types.Advice;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Rights;
import org.graalvm.wasm.predefined.wasi.types.Whence;

public abstract class Fd
implements Closeable {
    protected final Filetype type;
    protected long fsRightsBase;
    protected long fsRightsInheriting;
    protected short fdFlags;

    protected Fd(Filetype type, long fsRightsBase, long fsRightsInheriting, short fdFlags) {
        this.type = type;
        this.fsRightsBase = fsRightsBase;
        this.fsRightsInheriting = fsRightsInheriting;
        this.fdFlags = fdFlags;
    }

    public Errno pathOpen(Node node, WasmMemory memory, int dirflags, int pathAddress, int pathLength, short oflags, long childFsRightsBase, long childFsRightsInheriting, short fdflags, int fdAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathOpen)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno write(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno read(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pwrite(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pread(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno readdir(Node node, WasmMemory memory, int bufAddress, int bufLength, long cookie, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdReaddir)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno seek(Node node, WasmMemory memory, long offset, Whence whence, int newOffsetAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdSeek)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno tell(Node node, WasmMemory memory, int offsetAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdTell)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno advise(long offset, long length, Advice advice) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdAdvise)) {
            return Errno.Notcapable;
        }
        return Errno.Success;
    }

    public Errno fdstatGet(Node node, WasmMemory memory, int resultAddress) {
        return FdUtils.writeFdstat(node, memory, resultAddress, this.type, this.fdFlags, this.fsRightsBase, this.fsRightsInheriting);
    }

    public Errno fdstatSetFlags(Node node, WasmMemory memory, short fdflags) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFdstatSetFlags)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno fdstatSetRights(long newFsRightsBase, long newFsRightsInheriting) {
        if (!FlagUtils.isSubsetOf(newFsRightsBase, this.fsRightsBase) || !FlagUtils.isSubsetOf(newFsRightsInheriting, this.fsRightsInheriting)) {
            return Errno.Notcapable;
        }
        this.fsRightsBase = newFsRightsBase;
        this.fsRightsInheriting = newFsRightsInheriting;
        return Errno.Success;
    }

    public Errno filestatSetSize(Node node, long size) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatSetSize)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno filestatSetTimes(Node node, long atim, long mtim, int fstFlags) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatSetTimes)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno filestatGet(Node node, WasmMemory memory, int resultAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatGet)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno prestatGet(Node node, WasmMemory memory, int resultAddress) {
        return Errno.Acces;
    }

    public Errno prestatDirName(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        return Errno.Acces;
    }

    public Errno pathCreateDirectory(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathCreateDirectory)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathFilestatGet(Node node, WasmMemory memory, int flags, int pathAddress, int pathLength, int resultAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathFilestatGet)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathFilestatSetTimes(Node node, WasmMemory memory, int flags, int pathAddress, int pathLength, long atim, long mtim, int fstFlags) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathFilestatSetTimes)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathLink(Node node, WasmMemory memory, int oldFlags, int oldPathAddress, int oldPathLength, Fd newFd, int newPathAddress, int newPathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathLinkSource) || !FlagUtils.isSet(newFd.fsRightsBase, Rights.PathLinkTarget)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public int pathReadLink(Node node, WasmMemory memory, int pathAddress, int pathLength, int buf, int bufLen, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathReadlink)) {
            return Errno.Notcapable.ordinal();
        }
        return Errno.Acces.ordinal();
    }

    public Errno pathRemoveDirectory(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathRemoveDirectory)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathRename(Node node, WasmMemory memory, int oldPathAddress, int oldPathLength, Fd newFd, int newPathAddress, int newPathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathRenameSource) || !FlagUtils.isSet(newFd.fsRightsBase, Rights.PathRenameTarget)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathSymlink(Node node, WasmMemory memory, int oldPathAddress, int oldPathLength, int newPathAddress, int newPathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathSymlink)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno pathUnlinkFile(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathUnlinkFile)) {
            return Errno.Notcapable;
        }
        return Errno.Acces;
    }

    public Errno datasync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdDatasync)) {
            return Errno.Notcapable;
        }
        return Errno.Inval;
    }

    public Errno sync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdSync)) {
            return Errno.Notcapable;
        }
        return Errno.Inval;
    }

    @Override
    public void close() throws IOException {
    }
}

