/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;

public class MemoryRegistry {
    private static final int INITIAL_MEMORIES_SIZE = 4;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private WasmMemory[] memories = new WasmMemory[4];
    private int numMemories = 0;

    private void ensureCapacity() {
        if (this.numMemories == this.memories.length) {
            WasmMemory[] updatedMemories = new WasmMemory[this.memories.length * 2];
            System.arraycopy(this.memories, 0, updatedMemories, 0, this.memories.length);
            this.memories = updatedMemories;
        }
    }

    public int count() {
        return this.numMemories;
    }

    public int register(WasmMemory memory) {
        this.ensureCapacity();
        int index = this.numMemories++;
        this.memories[index] = memory;
        return index;
    }

    public int registerExternal(WasmMemory externalMemory) {
        return this.register(externalMemory);
    }

    public WasmMemory memory(int index) {
        assert (index < this.numMemories);
        return this.memories[index];
    }

    public MemoryRegistry duplicate() {
        MemoryRegistry other = new MemoryRegistry();
        for (int i = 0; i < this.numMemories; ++i) {
            WasmMemory memory = WasmMemoryLibrary.getUncached().duplicate(this.memory(i));
            other.register(memory);
        }
        return other;
    }
}

