/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

public final class WasmMath {
    private WasmMath() {
    }

    public static int addExactUnsigned(int a, int b) {
        int result = a + b;
        if (Integer.compareUnsigned(result, a) < 0) {
            throw new ArithmeticException("unsigned int overflow");
        }
        return result;
    }

    public static int minUnsigned(int a, int b) {
        return Integer.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static long minUnsigned(long a, long b) {
        return Long.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static int maxUnsigned(int a, int b) {
        return Integer.compareUnsigned(a, b) > 0 ? a : b;
    }

    public static int toUnsignedIntExact(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new ArithmeticException("unsigned int overflow");
        }
        return (int)value;
    }

    public static float unsignedIntToFloat(int x) {
        return Integer.toUnsignedLong(x);
    }

    public static double unsignedIntToDouble(int x) {
        return Integer.toUnsignedLong(x);
    }
}

