/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.Option;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.predefined.BuiltinModule;

@Option.Group(value={"wasm"})
public class WasmOptions {
    @Option(help="A comma-separated list of builtin modules to use.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="[<linkingName>:]<builtinModuleName>,[<linkingName>:]<builtinModuleName>,...")
    public static final OptionKey<Map<String, BuiltinModule>> Builtins = new OptionKey(Map.of(), new OptionType("Builtins", optionValue -> {
        if (optionValue.isEmpty()) {
            return Map.of();
        }
        String[] moduleSpecs = optionValue.split(",");
        HashMap<String, BuiltinModule> builtinModules = new HashMap<String, BuiltinModule>(moduleSpecs.length);
        for (String moduleSpec : moduleSpecs) {
            String[] parts = moduleSpec.split(":");
            if (parts.length > 2) {
                throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Module specification '" + moduleSpec + "' is not valid.");
            }
            String linkingName = parts[0];
            String predefinedModuleName = parts.length == 2 ? parts[1] : parts[0];
            builtinModules.put(linkingName, BuiltinModule.requireBuiltinModule(predefinedModuleName));
        }
        return Map.copyOf(builtinModules);
    }));
    @Option(help="The minimal binary size for which to use async parsing. If threads are not supported, async parsing will not be used.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="[0, inf)", deprecated=true, deprecationMessage="Option no longer has any effect and can be safely omitted.")
    public static final OptionKey<Integer> AsyncParsingBinarySize = new OptionKey((Object)100000);
    @Option(help="The stack size in kilobytes to use during async parsing, or zero to use defaults.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="[0, inf)", deprecated=true, deprecationMessage="Option no longer has any effect and can be safely omitted.")
    public static final OptionKey<Integer> AsyncParsingStackSize = new OptionKey((Object)0);
    @Option(help="A comma-separated list of pre-opened Wasi directories.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="[<virtualDir>::]<hostDir>,[<virtualDir>::]<hostDir>,...")
    public static final OptionKey<String> WasiMapDirs = new OptionKey((Object)"");
    public static final OptionType<ConstantsStorePolicy> StoreConstantsPolicyOptionType = new OptionType("StoreConstantsPolicy", ConstantsStorePolicy::valueOf);
    @Option(help="Whenever to store the constants in a pool or not. Deprecated: no longer has any effect.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, deprecated=true, usageSyntax="NONE|ALL|LARGE_ONLY")
    public static final OptionKey<ConstantsStorePolicy> StoreConstantsPolicy = new OptionKey((Object)ConstantsStorePolicy.NONE, StoreConstantsPolicyOptionType);
    @Option(help="Use sun.misc.Unsafe-based memory.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> UseUnsafeMemory = new OptionKey((Object)false);
    @Option(help="Use saturating-float-to-int conversion", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> SaturatingFloatToInt = new OptionKey((Object)true);
    @Option(help="Use sign-extension operators", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> SignExtensionOps = new OptionKey((Object)true);
    @Option(help="Enable multi-value support", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> MultiValue = new OptionKey((Object)true);
    @Option(help="Enable bulk-memory operations and support for reference types", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> BulkMemoryAndRefTypes = new OptionKey((Object)true);
    @Option(help="Enable support for 64-bit memory addresses (More details at https://github.com/WebAssembly/memory64/blob/main/proposals/memory64/Overview.md)", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> Memory64 = new OptionKey((Object)false);
    @Option(help="Enable support for multiple memories within a single module", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> MultiMemory = new OptionKey((Object)false);
    @Option(help="Enable support for threads and atomics", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> Threads = new OptionKey((Object)false);
    @Option(help="Enable support for extended const expressions", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> ExtendedConstExpressions = new OptionKey((Object)false);
    @Option(help="Enable support for the v128 type and vector instructions", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> SIMD = new OptionKey((Object)true);
    @Option(help="Enable support for the relaxed vector instructions", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> RelaxedSIMD = new OptionKey((Object)false);
    @Option(help="In this mode memories and tables are not initialized.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> MemoryOverheadMode = new OptionKey((Object)false);
    @Option(help="Make WASI random_get always return the same random numbers. For testing purpose only.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> WasiConstantRandomGet = new OptionKey((Object)false);
    @Option(help="Allows the embedder to access memories as direct byte buffers.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> DirectByteBufferMemoryAccess = new OptionKey((Object)false);
    @Option(help="Support instrumentation for functions that do not have their source available. For testing purpose only.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> DebugTestMode = new OptionKey((Object)false);
    @Option(help="Makes Context#eval return a wasm instance (runtime representation) instead of a wasm module (symbolic representation).", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> EvalReturnsInstance = new OptionKey((Object)false);

    public static enum ConstantsStorePolicy {
        ALL,
        LARGE_ONLY,
        NONE;

    }
}

