/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.api.InteropArray;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmIndirectCallNode;

public final class InteropCallAdapterNode
extends RootNode {
    private static final int MAX_UNROLL = 32;
    private final SymbolTable.FunctionType functionType;
    private final BranchProfile errorBranch = BranchProfile.create();
    @Node.Child
    private WasmIndirectCallNode callNode;

    public InteropCallAdapterNode(WasmLanguage language, SymbolTable.FunctionType functionType) {
        super((TruffleLanguage)language);
        this.functionType = functionType;
        this.callNode = WasmIndirectCallNode.create();
    }

    public Object execute(VirtualFrame frame) {
        WasmFunctionInstance functionInstance = (WasmFunctionInstance)frame.getArguments()[0];
        Object[] arguments = frame.getArguments();
        WasmArguments.setModuleInstance(arguments, functionInstance.moduleInstance());
        try {
            assert (functionInstance.context() == WasmContext.get(null));
            CallTarget target = functionInstance.target();
            Object result = this.callNode.execute(target, this.validateArguments(arguments, 1));
            int resultCount = this.functionType.resultTypes().length;
            if (resultCount > 1) {
                return this.multiValueStackAsArray((WasmLanguage)this.getLanguage(WasmLanguage.class));
            }
            return result;
        }
        catch (ArityException | UnsupportedTypeException e) {
            this.errorBranch.enter();
            throw WasmLanguage.rethrow(e);
        }
    }

    private Object[] validateArguments(Object[] arguments, int offset) throws ArityException, UnsupportedTypeException {
        byte[] paramTypes = this.functionType.paramTypes();
        int paramCount = paramTypes.length;
        CompilerAsserts.partialEvaluationConstant((int)paramCount);
        if (arguments.length - offset != paramCount) {
            throw ArityException.create((int)paramCount, (int)paramCount, (int)(arguments.length - offset));
        }
        if (CompilerDirectives.inCompiledCode() && paramCount <= 32) {
            InteropCallAdapterNode.validateArgumentsUnroll(arguments, offset, paramTypes, paramCount);
        } else {
            for (int i = 0; i < paramCount; ++i) {
                InteropCallAdapterNode.validateArgument(arguments, offset, paramTypes, i);
            }
        }
        return arguments;
    }

    @ExplodeLoop
    private static void validateArgumentsUnroll(Object[] arguments, int offset, byte[] paramTypes, int paramCount) throws UnsupportedTypeException {
        for (int i = 0; i < paramCount; ++i) {
            InteropCallAdapterNode.validateArgument(arguments, offset, paramTypes, i);
        }
    }

    private static void validateArgument(Object[] arguments, int offset, byte[] paramTypes, int i) throws UnsupportedTypeException {
        byte paramType = paramTypes[i];
        Object value = arguments[i + offset];
        switch (paramType) {
            case 127: {
                if (!(value instanceof Integer)) break;
                return;
            }
            case 126: {
                if (!(value instanceof Long)) break;
                return;
            }
            case 125: {
                if (!(value instanceof Float)) break;
                return;
            }
            case 124: {
                if (!(value instanceof Double)) break;
                return;
            }
            case 123: {
                if (!(value instanceof Vector128)) break;
                return;
            }
            case 112: {
                if (!(value instanceof WasmFunctionInstance) && value != WasmConstant.NULL) break;
                return;
            }
            case 111: {
                return;
            }
            default: {
                throw WasmException.create(Failure.UNKNOWN_TYPE);
            }
        }
        throw UnsupportedTypeException.create((Object[])arguments);
    }

    private Object multiValueStackAsArray(WasmLanguage language) {
        WasmLanguage.MultiValueStack multiValueStack = language.multiValueStack();
        long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
        Object[] objectMultiValueStack = multiValueStack.objectStack();
        byte[] resultTypes = this.functionType.resultTypes();
        int resultCount = resultTypes.length;
        assert (primitiveMultiValueStack.length >= resultCount);
        assert (objectMultiValueStack.length >= resultCount);
        Object[] values = new Object[resultCount];
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (CompilerDirectives.inCompiledCode() && resultCount <= 32) {
            InteropCallAdapterNode.popMultiValueResultUnroll(values, primitiveMultiValueStack, objectMultiValueStack, resultTypes, resultCount);
        } else {
            for (int i = 0; i < resultCount; ++i) {
                values[i] = InteropCallAdapterNode.popMultiValueResult(primitiveMultiValueStack, objectMultiValueStack, resultTypes, i);
            }
        }
        return InteropArray.create(values);
    }

    @ExplodeLoop
    private static void popMultiValueResultUnroll(Object[] values, long[] primitiveMultiValueStack, Object[] objectMultiValueStack, byte[] resultTypes, int resultCount) {
        for (int i = 0; i < resultCount; ++i) {
            values[i] = InteropCallAdapterNode.popMultiValueResult(primitiveMultiValueStack, objectMultiValueStack, resultTypes, i);
        }
    }

    private static Object popMultiValueResult(long[] primitiveMultiValueStack, Object[] objectMultiValueStack, byte[] resultTypes, int i) {
        byte resultType = resultTypes[i];
        return switch (resultType) {
            case 127 -> (int)primitiveMultiValueStack[i];
            case 126 -> primitiveMultiValueStack[i];
            case 125 -> Float.valueOf(Float.intBitsToFloat((int)primitiveMultiValueStack[i]));
            case 124 -> Double.longBitsToDouble(primitiveMultiValueStack[i]);
            case 111, 112, 123 -> {
                Object obj = objectMultiValueStack[i];
                objectMultiValueStack[i] = null;
                yield obj;
            }
            default -> throw WasmException.create(Failure.UNSPECIFIED_INTERNAL);
        };
    }

    public String getName() {
        return "wasm-function-interop:" + String.valueOf(this.functionType);
    }

    public String toString() {
        return this.getName();
    }

    protected boolean isInstrumentable() {
        return false;
    }
}

