/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.util.Arrays;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.Vector128Ops;

public final class Vector128OpsFallback
implements Vector128Ops<byte[]> {
    private static final ByteArraySupport byteArraySupport = ByteArraySupport.littleEndian();

    public static Vector128Ops<byte[]> create() {
        return new Vector128OpsFallback();
    }

    @Override
    public byte[] unary(byte[] x, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 77 -> Vector128OpsFallback.v128_not(x);
            case 96, 97, 98 -> Vector128OpsFallback.i8x16_unop(x, vectorOpcode);
            case 124, 125 -> Vector128OpsFallback.i16x8_extadd_pairwise_i8x16(x, vectorOpcode);
            case 135, 137 -> Vector128OpsFallback.i16x8_extend_low_i8x16(x, vectorOpcode);
            case 136, 138 -> Vector128OpsFallback.i16x8_extend_high_i8x16(x, vectorOpcode);
            case 128, 129 -> Vector128OpsFallback.i16x8_unop(x, vectorOpcode);
            case 126, 127 -> Vector128OpsFallback.i32x4_extadd_pairwise_i16x8(x, vectorOpcode);
            case 167, 169 -> Vector128OpsFallback.i32x4_extend_low_i16x8(x, vectorOpcode);
            case 168, 170 -> Vector128OpsFallback.i32x4_extend_high_i16x8(x, vectorOpcode);
            case 160, 161 -> Vector128OpsFallback.i32x4_unop(x, vectorOpcode);
            case 199, 201 -> Vector128OpsFallback.i64x2_extend_low_i32x4(x, vectorOpcode);
            case 200, 202 -> Vector128OpsFallback.i64x2_extend_high_i32x4(x, vectorOpcode);
            case 192, 193 -> Vector128OpsFallback.i64x2_unop(x, vectorOpcode);
            case 103, 104, 105, 106, 224, 225, 227 -> Vector128OpsFallback.f32x4_unop(x, vectorOpcode);
            case 116, 117, 122, 148, 236, 237, 239 -> Vector128OpsFallback.f64x2_unop(x, vectorOpcode);
            case 165, 166, 248, 249 -> Vector128OpsFallback.i32x4_trunc_f32x4(x, vectorOpcode);
            case 250, 251 -> Vector128OpsFallback.f32x4_convert_i32x4(x, vectorOpcode);
            case 197, 198, 252, 253 -> Vector128OpsFallback.i32x4_trunc_f64x2_zero(x, vectorOpcode);
            case 254, 255 -> Vector128OpsFallback.f64x2_convert_low_i32x4(x, vectorOpcode);
            case 94 -> Vector128OpsFallback.f32x4_demote_f64x2_zero(x);
            case 95 -> Vector128OpsFallback.f64x2_promote_low_f32x4(x);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public byte[] binary(byte[] x, byte[] y, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 14, 162 -> Vector128OpsFallback.i8x16_swizzle(x, y, vectorOpcode);
            case 78, 79, 80, 81 -> Vector128OpsFallback.v128_binop(x, y, vectorOpcode);
            case 35, 36, 37, 38, 39, 40, 41, 42, 43, 44 -> Vector128OpsFallback.i8x16_relop(x, y, vectorOpcode);
            case 45, 46, 47, 48, 49, 50, 51, 52, 53, 54 -> Vector128OpsFallback.i16x8_relop(x, y, vectorOpcode);
            case 55, 56, 57, 58, 59, 60, 61, 62, 63, 64 -> Vector128OpsFallback.i32x4_relop(x, y, vectorOpcode);
            case 214, 215, 216, 217, 218, 219 -> Vector128OpsFallback.i64x2_relop(x, y, vectorOpcode);
            case 65, 66, 67, 68, 69, 70 -> Vector128OpsFallback.f32x4_relop(x, y, vectorOpcode);
            case 71, 72, 73, 74, 75, 76 -> Vector128OpsFallback.f64x2_relop(x, y, vectorOpcode);
            case 101, 102 -> Vector128OpsFallback.i8x16_narrow_i16x8(x, y, vectorOpcode);
            case 110, 111, 112, 113, 114, 115, 118, 119, 120, 121, 123 -> Vector128OpsFallback.i8x16_binop(x, y, vectorOpcode);
            case 133, 134 -> Vector128OpsFallback.i16x8_narrow_i32x4(x, y, vectorOpcode);
            case 130, 142, 143, 144, 145, 146, 147, 149, 150, 151, 152, 153, 154, 155 -> Vector128OpsFallback.i16x8_binop(x, y, vectorOpcode);
            case 156, 158 -> Vector128OpsFallback.i16x8_binop_extend_low_i8x16(x, y, vectorOpcode);
            case 157, 159 -> Vector128OpsFallback.i16x8_binop_extend_high_i8x16(x, y, vectorOpcode);
            case 174, 177, 181, 182, 183, 184, 185 -> Vector128OpsFallback.i32x4_binop(x, y, vectorOpcode);
            case 186 -> Vector128OpsFallback.i32x4_dot_i16x8_s(x, y);
            case 188, 190 -> Vector128OpsFallback.i32x4_binop_extend_low_i16x8(x, y, vectorOpcode);
            case 189, 191 -> Vector128OpsFallback.i32x4_binop_extend_high_i16x8(x, y, vectorOpcode);
            case 206, 209, 213 -> Vector128OpsFallback.i64x2_binop(x, y, vectorOpcode);
            case 220, 222 -> Vector128OpsFallback.i64x2_binop_extend_low_i32x4(x, y, vectorOpcode);
            case 221, 223 -> Vector128OpsFallback.i64x2_binop_extend_high_i32x4(x, y, vectorOpcode);
            case 180, 226, 228, 229, 230, 231, 232, 233, 234, 235 -> Vector128OpsFallback.f32x4_binop(x, y, vectorOpcode);
            case 212, 238, 240, 241, 242, 243, 244, 245, 246, 247 -> Vector128OpsFallback.f64x2_binop(x, y, vectorOpcode);
            case 187 -> Vector128OpsFallback.i16x8_relaxed_dot_i8x16_i7x16_s(x, y);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public byte[] ternary(byte[] x, byte[] y, byte[] z, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 82, 178, 179, 210, 211 -> Vector128OpsFallback.bitselect(x, y, z, vectorOpcode);
            case 175, 176 -> Vector128OpsFallback.f32x4_ternop(x, y, z, vectorOpcode);
            case 207, 208 -> Vector128OpsFallback.f64x2_ternop(x, y, z, vectorOpcode);
            case 194 -> Vector128OpsFallback.i32x4_relaxed_dot_i8x16_i7x16_add_s(x, y, z);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public int vectorToInt(byte[] x, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 83 -> Vector128OpsFallback.v128_any_true(x);
            case 99 -> Vector128OpsFallback.i8x16_all_true(x);
            case 100 -> Vector128OpsFallback.i8x16_bitmask(x);
            case 131 -> Vector128OpsFallback.i16x8_all_true(x);
            case 132 -> Vector128OpsFallback.i16x8_bitmask(x);
            case 163 -> Vector128OpsFallback.i32x4_all_true(x);
            case 164 -> Vector128OpsFallback.i32x4_bitmask(x);
            case 195 -> Vector128OpsFallback.i64x2_all_true(x);
            case 196 -> Vector128OpsFallback.i64x2_bitmask(x);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public byte[] shift(byte[] x, int shift, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 107, 108, 109 -> Vector128OpsFallback.i8x16_shiftop(x, shift, vectorOpcode);
            case 139, 140, 141 -> Vector128OpsFallback.i16x8_shiftop(x, shift, vectorOpcode);
            case 171, 172, 173 -> Vector128OpsFallback.i32x4_shiftop(x, shift, vectorOpcode);
            case 203, 204, 205 -> Vector128OpsFallback.i64x2_shiftop(x, shift, vectorOpcode);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] v128_load8x8(long value, int vectorOpcode) {
        byte[] bytes = new byte[8];
        CompilerDirectives.ensureVirtualized((Object)bytes);
        byteArraySupport.putLong(bytes, 0, value);
        byte[] resultBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x = bytes[i];
            short result = switch (vectorOpcode) {
                case 1 -> x;
                case 2 -> (short)Byte.toUnsignedInt(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(resultBytes, i * 2, result);
        }
        return resultBytes;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] v128_load16x4(long value, int vectorOpcode) {
        byte[] bytes = new byte[8];
        CompilerDirectives.ensureVirtualized((Object)bytes);
        byteArraySupport.putLong(bytes, 0, value);
        byte[] resultBytes = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getShort(bytes, i * 2);
            int result = switch (vectorOpcode) {
                case 3 -> x;
                case 4 -> Short.toUnsignedInt((short)x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(resultBytes, i * 4, result);
        }
        return resultBytes;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] v128_load32x2(long value, int vectorOpcode) {
        byte[] bytes = new byte[8];
        CompilerDirectives.ensureVirtualized((Object)bytes);
        byteArraySupport.putLong(bytes, 0, value);
        byte[] resultBytes = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(bytes, i * 4);
            long result = switch (vectorOpcode) {
                case 5 -> x;
                case 6 -> Integer.toUnsignedLong(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(resultBytes, i * 8, result);
        }
        return resultBytes;
    }

    @Override
    public byte[] v128_load32_zero(int value) {
        byte[] resultBytes = new byte[16];
        byteArraySupport.putInt(resultBytes, 0, value);
        return resultBytes;
    }

    @Override
    public byte[] v128_load64_zero(long value) {
        byte[] resultBytes = new byte[16];
        byteArraySupport.putLong(resultBytes, 0, value);
        return resultBytes;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] i8x16_splat(byte value) {
        byte[] result = new byte[16];
        Arrays.fill(result, value);
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] i16x8_splat(short value) {
        byte[] result = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byteArraySupport.putShort(result, i * 2, value);
        }
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] i32x4_splat(int value) {
        byte[] result = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byteArraySupport.putInt(result, i * 4, value);
        }
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] i64x2_splat(long value) {
        byte[] result = new byte[16];
        for (int i = 0; i < 2; ++i) {
            byteArraySupport.putLong(result, i * 8, value);
        }
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] f32x4_splat(float value) {
        byte[] result = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byteArraySupport.putFloat(result, i * 4, value);
        }
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] f64x2_splat(double value) {
        byte[] result = new byte[16];
        for (int i = 0; i < 2; ++i) {
            byteArraySupport.putDouble(result, i * 8, value);
        }
        return result;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    public byte[] i8x16_shuffle(byte[] x, byte[] y, byte[] indices) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = indices[i] < 16 ? x[indices[i]] : y[indices[i] - 16];
        }
        return result;
    }

    @Override
    public byte i8x16_extract_lane_s(byte[] bytes, int laneIndex) {
        return bytes[laneIndex];
    }

    @Override
    public int i8x16_extract_lane(byte[] bytes, int laneIndex, int vectorOpcode) {
        return switch (vectorOpcode) {
            case 21 -> bytes[laneIndex];
            case 22 -> Byte.toUnsignedInt(bytes[laneIndex]);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public byte[] i8x16_replace_lane(byte[] bytes, int laneIndex, byte value) {
        byte[] result = Arrays.copyOf(bytes, 16);
        result[laneIndex] = value;
        return result;
    }

    @Override
    public short i16x8_extract_lane_s(byte[] vec, int laneIndex) {
        return byteArraySupport.getShort(vec, laneIndex * 2);
    }

    @Override
    public int i16x8_extract_lane(byte[] vec, int laneIndex, int vectorOpcode) {
        int x = byteArraySupport.getShort(vec, laneIndex * 2);
        return switch (vectorOpcode) {
            case 24 -> x;
            case 25 -> Short.toUnsignedInt((short)x);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public byte[] i16x8_replace_lane(byte[] vec, int laneIndex, short value) {
        byte[] result = Arrays.copyOf(vec, 16);
        byteArraySupport.putShort(result, laneIndex * 2, value);
        return result;
    }

    @Override
    public int i32x4_extract_lane(byte[] vec, int laneIndex) {
        return byteArraySupport.getInt(vec, laneIndex * 4);
    }

    @Override
    public byte[] i32x4_replace_lane(byte[] vec, int laneIndex, int value) {
        byte[] result = Arrays.copyOf(vec, 16);
        byteArraySupport.putInt(result, laneIndex * 4, value);
        return result;
    }

    @Override
    public long i64x2_extract_lane(byte[] vec, int laneIndex) {
        return byteArraySupport.getLong(vec, laneIndex * 8);
    }

    @Override
    public byte[] i64x2_replace_lane(byte[] vec, int laneIndex, long value) {
        byte[] result = Arrays.copyOf(vec, 16);
        byteArraySupport.putLong(result, laneIndex * 8, value);
        return result;
    }

    @Override
    public float f32x4_extract_lane(byte[] vec, int laneIndex) {
        return byteArraySupport.getFloat(vec, laneIndex * 4);
    }

    @Override
    public byte[] f32x4_replace_lane(byte[] vec, int laneIndex, float value) {
        byte[] result = Arrays.copyOf(vec, 16);
        byteArraySupport.putFloat(result, laneIndex * 4, value);
        return result;
    }

    @Override
    public double f64x2_extract_lane(byte[] vec, int laneIndex) {
        return byteArraySupport.getDouble(vec, laneIndex * 8);
    }

    @Override
    public byte[] f64x2_replace_lane(byte[] vec, int laneIndex, double value) {
        byte[] result = Arrays.copyOf(vec, 16);
        byteArraySupport.putDouble(result, laneIndex * 8, value);
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_swizzle(byte[] values, byte[] indices, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            int index = Byte.toUnsignedInt(indices[i]);
            result[i] = index < 16 ? values[index] : (byte)0;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] v128_not(byte[] x) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = ~x[i];
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] v128_binop(byte[] x, byte[] y, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = switch (vectorOpcode) {
                case 78 -> (byte)(x[i] & y[i]);
                case 79 -> (byte)(x[i] & ~y[i]);
                case 80 -> (byte)(x[i] | y[i]);
                case 81 -> (byte)(x[i] ^ y[i]);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] bitselect(byte[] x, byte[] y, byte[] mask, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = (byte)(x[i] & mask[i] | y[i] & ~mask[i]);
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int v128_any_true(byte[] vec) {
        int result = 0;
        for (int i = 0; i < 16; ++i) {
            if (vec[i] == 0) continue;
            result = 1;
            break;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_relop(byte[] x, byte[] y, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            int n;
            block24: {
                block23: {
                    switch (vectorOpcode) {
                        case 35: {
                            if (x[i] == y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 36: {
                            if (x[i] != y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 37: {
                            if (x[i] < y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 38: {
                            if (Byte.compareUnsigned(x[i], y[i]) < 0) {
                                break;
                            }
                            break block23;
                        }
                        case 39: {
                            if (x[i] > y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 40: {
                            if (Byte.compareUnsigned(x[i], y[i]) > 0) {
                                break;
                            }
                            break block23;
                        }
                        case 41: {
                            if (x[i] <= y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 42: {
                            if (Byte.compareUnsigned(x[i], y[i]) <= 0) {
                                break;
                            }
                            break block23;
                        }
                        case 43: {
                            if (x[i] >= y[i]) {
                                break;
                            }
                            break block23;
                        }
                        case 44: {
                            if (Byte.compareUnsigned(x[i], y[i]) >= 0) {
                                break;
                            }
                            break block23;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    n = -1;
                    break block24;
                }
                n = 0;
            }
            result[i] = n;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_relop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            short s;
            block24: {
                block23: {
                    short x = byteArraySupport.getShort(vecX, i * 2);
                    short y = byteArraySupport.getShort(vecY, i * 2);
                    switch (vectorOpcode) {
                        case 45: {
                            if (x == y) {
                                break;
                            }
                            break block23;
                        }
                        case 46: {
                            if (x != y) {
                                break;
                            }
                            break block23;
                        }
                        case 47: {
                            if (x < y) {
                                break;
                            }
                            break block23;
                        }
                        case 48: {
                            if (Short.compareUnsigned(x, y) < 0) {
                                break;
                            }
                            break block23;
                        }
                        case 49: {
                            if (x > y) {
                                break;
                            }
                            break block23;
                        }
                        case 50: {
                            if (Short.compareUnsigned(x, y) > 0) {
                                break;
                            }
                            break block23;
                        }
                        case 51: {
                            if (x <= y) {
                                break;
                            }
                            break block23;
                        }
                        case 52: {
                            if (Short.compareUnsigned(x, y) <= 0) {
                                break;
                            }
                            break block23;
                        }
                        case 53: {
                            if (x >= y) {
                                break;
                            }
                            break block23;
                        }
                        case 54: {
                            if (Short.compareUnsigned(x, y) >= 0) {
                                break;
                            }
                            break block23;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    s = -1;
                    break block24;
                }
                s = 0;
            }
            short result = s;
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_relop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int n;
            block24: {
                block23: {
                    int x = byteArraySupport.getInt(vecX, i * 4);
                    int y = byteArraySupport.getInt(vecY, i * 4);
                    switch (vectorOpcode) {
                        case 55: {
                            if (x == y) {
                                break;
                            }
                            break block23;
                        }
                        case 56: {
                            if (x != y) {
                                break;
                            }
                            break block23;
                        }
                        case 57: {
                            if (x < y) {
                                break;
                            }
                            break block23;
                        }
                        case 58: {
                            if (Integer.compareUnsigned(x, y) < 0) {
                                break;
                            }
                            break block23;
                        }
                        case 59: {
                            if (x > y) {
                                break;
                            }
                            break block23;
                        }
                        case 60: {
                            if (Integer.compareUnsigned(x, y) > 0) {
                                break;
                            }
                            break block23;
                        }
                        case 61: {
                            if (x <= y) {
                                break;
                            }
                            break block23;
                        }
                        case 62: {
                            if (Integer.compareUnsigned(x, y) <= 0) {
                                break;
                            }
                            break block23;
                        }
                        case 63: {
                            if (x >= y) {
                                break;
                            }
                            break block23;
                        }
                        case 64: {
                            if (Integer.compareUnsigned(x, y) >= 0) {
                                break;
                            }
                            break block23;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    n = -1;
                    break block24;
                }
                n = 0;
            }
            int result = n;
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_relop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long l;
            block16: {
                block15: {
                    long x = byteArraySupport.getLong(vecX, i * 8);
                    long y = byteArraySupport.getLong(vecY, i * 8);
                    switch (vectorOpcode) {
                        case 214: {
                            if (x == y) {
                                break;
                            }
                            break block15;
                        }
                        case 215: {
                            if (x != y) {
                                break;
                            }
                            break block15;
                        }
                        case 216: {
                            if (x < y) {
                                break;
                            }
                            break block15;
                        }
                        case 217: {
                            if (x > y) {
                                break;
                            }
                            break block15;
                        }
                        case 218: {
                            if (x <= y) {
                                break;
                            }
                            break block15;
                        }
                        case 219: {
                            if (x >= y) {
                                break;
                            }
                            break block15;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    l = -1L;
                    break block16;
                }
                l = 0L;
            }
            long result = l;
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_relop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int n;
            block16: {
                block15: {
                    float x = byteArraySupport.getFloat(vecX, i * 4);
                    float y = byteArraySupport.getFloat(vecY, i * 4);
                    switch (vectorOpcode) {
                        case 65: {
                            if (x == y) {
                                break;
                            }
                            break block15;
                        }
                        case 66: {
                            if (x != y) {
                                break;
                            }
                            break block15;
                        }
                        case 67: {
                            if (x < y) {
                                break;
                            }
                            break block15;
                        }
                        case 68: {
                            if (x > y) {
                                break;
                            }
                            break block15;
                        }
                        case 69: {
                            if (x <= y) {
                                break;
                            }
                            break block15;
                        }
                        case 70: {
                            if (x >= y) {
                                break;
                            }
                            break block15;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    n = -1;
                    break block16;
                }
                n = 0;
            }
            int result = n;
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_relop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long l;
            block16: {
                block15: {
                    double x = byteArraySupport.getDouble(vecX, i * 8);
                    double y = byteArraySupport.getDouble(vecY, i * 8);
                    switch (vectorOpcode) {
                        case 71: {
                            if (x == y) {
                                break;
                            }
                            break block15;
                        }
                        case 72: {
                            if (x != y) {
                                break;
                            }
                            break block15;
                        }
                        case 73: {
                            if (x < y) {
                                break;
                            }
                            break block15;
                        }
                        case 74: {
                            if (x > y) {
                                break;
                            }
                            break block15;
                        }
                        case 75: {
                            if (x <= y) {
                                break;
                            }
                            break block15;
                        }
                        case 76: {
                            if (x >= y) {
                                break;
                            }
                            break block15;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    l = -1L;
                    break block16;
                }
                l = 0L;
            }
            long result = l;
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_unop(byte[] x, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = switch (vectorOpcode) {
                case 96 -> (byte)Math.abs(x[i]);
                case 97 -> -x[i];
                case 98 -> (byte)Integer.bitCount(Byte.toUnsignedInt(x[i]));
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i8x16_all_true(byte[] bytes) {
        int result = 1;
        for (int i = 0; i < 16; ++i) {
            if (bytes[i] != 0) continue;
            result = 0;
            break;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i8x16_bitmask(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 16; ++i) {
            if (bytes[i] >= 0) continue;
            result |= 1 << i;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_narrow_i16x8(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byte[] src = i < 8 ? vecX : vecY;
            int index = i < 8 ? i : i - 8;
            short srcValue = byteArraySupport.getShort(src, index * 2);
            result[i] = switch (vectorOpcode) {
                case 101 -> Vector128OpsFallback.satS8(srcValue);
                case 102 -> Vector128OpsFallback.satU8(srcValue);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_shiftop(byte[] x, int shift, int vectorOpcode) {
        byte[] result = new byte[16];
        int shiftMod = shift % 8;
        for (int i = 0; i < 16; ++i) {
            result[i] = switch (vectorOpcode) {
                case 107 -> (byte)(x[i] << shiftMod);
                case 108 -> (byte)(x[i] >> shiftMod);
                case 109 -> (byte)(Byte.toUnsignedInt(x[i]) >>> shiftMod);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i8x16_binop(byte[] x, byte[] y, int vectorOpcode) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = switch (vectorOpcode) {
                case 110 -> (byte)(x[i] + y[i]);
                case 111 -> Vector128OpsFallback.satS8(x[i] + y[i]);
                case 112 -> Vector128OpsFallback.satU8(Byte.toUnsignedInt(x[i]) + Byte.toUnsignedInt(y[i]));
                case 113 -> (byte)(x[i] - y[i]);
                case 114 -> Vector128OpsFallback.satS8(x[i] - y[i]);
                case 115 -> Vector128OpsFallback.satU8(Byte.toUnsignedInt(x[i]) - Byte.toUnsignedInt(y[i]));
                case 118 -> (byte)Math.min(x[i], y[i]);
                case 119 -> {
                    if (Byte.compareUnsigned(x[i], y[i]) <= 0) {
                        yield x[i];
                    }
                    yield y[i];
                }
                case 120 -> (byte)Math.max(x[i], y[i]);
                case 121 -> {
                    if (Byte.compareUnsigned(x[i], y[i]) >= 0) {
                        yield x[i];
                    }
                    yield y[i];
                }
                case 123 -> (byte)((Byte.toUnsignedInt(x[i]) + Byte.toUnsignedInt(y[i]) + 1) / 2);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_extadd_pairwise_i8x16(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x1 = vecX[2 * i];
            byte x2 = vecX[2 * i + 1];
            short result = switch (vectorOpcode) {
                case 124 -> (short)(x1 + x2);
                case 125 -> (short)(Byte.toUnsignedInt(x1) + Byte.toUnsignedInt(x2));
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_extend_low_i8x16(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x = vecX[i];
            short result = switch (vectorOpcode) {
                case 135 -> x;
                case 137 -> (short)Byte.toUnsignedInt(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_extend_high_i8x16(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x = vecX[i + 8];
            short result = switch (vectorOpcode) {
                case 136 -> x;
                case 138 -> (short)Byte.toUnsignedInt(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_unop(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            short x = byteArraySupport.getShort(vecX, i * 2);
            short result = switch (vectorOpcode) {
                case 128 -> (short)Math.abs(x);
                case 129 -> -x;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i16x8_all_true(byte[] vec) {
        int result = 1;
        for (int i = 0; i < 8; ++i) {
            short x = byteArraySupport.getShort(vec, i * 2);
            if (x != 0) continue;
            result = 0;
            break;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i16x8_bitmask(byte[] vec) {
        int result = 0;
        for (int i = 0; i < 8; ++i) {
            short x = byteArraySupport.getShort(vec, i * 2);
            if (x >= 0) continue;
            result |= 1 << i;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_narrow_i32x4(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte[] src = i < 4 ? vecX : vecY;
            int index = i < 4 ? i : i - 4;
            int srcValue = byteArraySupport.getInt(src, index * 4);
            short result = switch (vectorOpcode) {
                case 133 -> Vector128OpsFallback.satS16(srcValue);
                case 134 -> Vector128OpsFallback.satU16(srcValue);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_shiftop(byte[] vecX, int shift, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        int shiftMod = shift % 16;
        for (int i = 0; i < 8; ++i) {
            short x = byteArraySupport.getShort(vecX, i * 2);
            short result = switch (vectorOpcode) {
                case 139 -> (short)(x << shiftMod);
                case 140 -> (short)(x >> shiftMod);
                case 141 -> (short)(Short.toUnsignedInt(x) >>> shiftMod);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_binop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            short x = byteArraySupport.getShort(vecX, i * 2);
            short y = byteArraySupport.getShort(vecY, i * 2);
            short result = switch (vectorOpcode) {
                case 130, 154 -> Vector128OpsFallback.satS16(x * y + 16384 >> 15);
                case 142 -> (short)(x + y);
                case 143 -> Vector128OpsFallback.satS16(x + y);
                case 144 -> Vector128OpsFallback.satU16(Short.toUnsignedInt(x) + Short.toUnsignedInt(y));
                case 145 -> (short)(x - y);
                case 146 -> Vector128OpsFallback.satS16(x - y);
                case 147 -> Vector128OpsFallback.satU16(Short.toUnsignedInt(x) - Short.toUnsignedInt(y));
                case 149 -> (short)(x * y);
                case 150 -> (short)Math.min(x, y);
                case 151 -> {
                    if (Short.compareUnsigned(x, y) <= 0) {
                        yield x;
                    }
                    yield y;
                }
                case 152 -> (short)Math.max(x, y);
                case 153 -> {
                    if (Short.compareUnsigned(x, y) >= 0) {
                        yield x;
                    }
                    yield y;
                }
                case 155 -> (short)((Short.toUnsignedInt(x) + Short.toUnsignedInt(y) + 1) / 2);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_binop_extend_low_i8x16(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x = vecX[i];
            byte y = vecY[i];
            short result = switch (vectorOpcode) {
                case 156 -> (short)(x * y);
                case 158 -> (short)(Byte.toUnsignedInt(x) * Byte.toUnsignedInt(y));
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_binop_extend_high_i8x16(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x = vecX[i + 8];
            byte y = vecY[i + 8];
            short result = switch (vectorOpcode) {
                case 157 -> (short)(x * y);
                case 159 -> (short)(Byte.toUnsignedInt(x) * Byte.toUnsignedInt(y));
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i16x8_relaxed_dot_i8x16_i7x16_s(byte[] vecX, byte[] vecY) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byte x1 = byteArraySupport.getByte(vecX, i * 2);
            byte x2 = byteArraySupport.getByte(vecX, i * 2 + 1);
            byte y1 = byteArraySupport.getByte(vecY, i * 2);
            byte y2 = byteArraySupport.getByte(vecY, i * 2 + 1);
            short result = Vector128OpsFallback.satS16(x1 * y1 + x2 * y2);
            byteArraySupport.putShort(vecResult, i * 2, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_extadd_pairwise_i16x8(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            short x1 = byteArraySupport.getShort(vecX, i * 2 * 2);
            short x2 = byteArraySupport.getShort(vecX, (i * 2 + 1) * 2);
            int result = switch (vectorOpcode) {
                case 126 -> x1 + x2;
                case 127 -> Short.toUnsignedInt(x1) + Short.toUnsignedInt(x2);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_extend_low_i16x8(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getShort(vecX, i * 2);
            int result = switch (vectorOpcode) {
                case 167 -> x;
                case 169 -> Short.toUnsignedInt((short)x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_extend_high_i16x8(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getShort(vecX, (i + 4) * 2);
            int result = switch (vectorOpcode) {
                case 168 -> x;
                case 170 -> Short.toUnsignedInt((short)x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_unop(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            int result = switch (vectorOpcode) {
                case 160 -> Math.abs(x);
                case 161 -> -x;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i32x4_all_true(byte[] vec) {
        int result = 1;
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vec, i * 4);
            if (x != 0) continue;
            result = 0;
            break;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i32x4_bitmask(byte[] vec) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vec, i * 4);
            if (x >= 0) continue;
            result |= 1 << i;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_shiftop(byte[] vecX, int shift, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            int result = switch (vectorOpcode) {
                case 171 -> x << shift;
                case 172 -> x >> shift;
                case 173 -> x >>> shift;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_binop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            int y = byteArraySupport.getInt(vecY, i * 4);
            int result = switch (vectorOpcode) {
                case 174 -> x + y;
                case 177 -> x - y;
                case 181 -> x * y;
                case 182 -> Math.min(x, y);
                case 183 -> {
                    if (Integer.compareUnsigned(x, y) <= 0) {
                        yield x;
                    }
                    yield y;
                }
                case 184 -> Math.max(x, y);
                case 185 -> {
                    if (Integer.compareUnsigned(x, y) >= 0) {
                        yield x;
                    }
                    yield y;
                }
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_dot_i16x8_s(byte[] vecX, byte[] vecY) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            short x1 = byteArraySupport.getShort(vecX, i * 2 * 2);
            short x2 = byteArraySupport.getShort(vecX, (i * 2 + 1) * 2);
            short y1 = byteArraySupport.getShort(vecY, i * 2 * 2);
            short y2 = byteArraySupport.getShort(vecY, (i * 2 + 1) * 2);
            int result = x1 * y1 + x2 * y2;
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_binop_extend_low_i16x8(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            short x = byteArraySupport.getShort(vecX, i * 2);
            short y = byteArraySupport.getShort(vecY, i * 2);
            int result = switch (vectorOpcode) {
                case 188 -> x * y;
                case 190 -> Short.toUnsignedInt(x) * Short.toUnsignedInt(y);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_binop_extend_high_i16x8(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            short x = byteArraySupport.getShort(vecX, (i + 4) * 2);
            short y = byteArraySupport.getShort(vecY, (i + 4) * 2);
            int result = switch (vectorOpcode) {
                case 189 -> x * y;
                case 191 -> Short.toUnsignedInt(x) * Short.toUnsignedInt(y);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_relaxed_dot_i8x16_i7x16_add_s(byte[] vecX, byte[] vecY, byte[] vecZ) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byte x1 = byteArraySupport.getByte(vecX, i * 4);
            byte x2 = byteArraySupport.getByte(vecX, i * 4 + 1);
            byte y1 = byteArraySupport.getByte(vecY, i * 4);
            byte y2 = byteArraySupport.getByte(vecY, i * 4 + 1);
            short dot1 = Vector128OpsFallback.satS16(x1 * y1 + x2 * y2);
            byte x3 = byteArraySupport.getByte(vecX, i * 4 + 2);
            byte x4 = byteArraySupport.getByte(vecX, i * 4 + 3);
            byte y3 = byteArraySupport.getByte(vecY, i * 4 + 2);
            byte y4 = byteArraySupport.getByte(vecY, i * 4 + 3);
            short dot2 = Vector128OpsFallback.satS16(x3 * y3 + x4 * y4);
            int addend = byteArraySupport.getInt(vecZ, i * 4);
            int result = dot1 + dot2 + addend;
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_extend_low_i32x4(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            long result = switch (vectorOpcode) {
                case 199 -> x;
                case 201 -> Integer.toUnsignedLong(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_extend_high_i32x4(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(vecX, (i + 2) * 4);
            long result = switch (vectorOpcode) {
                case 200 -> x;
                case 202 -> Integer.toUnsignedLong(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_unop(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long x = byteArraySupport.getLong(vecX, i * 8);
            long result = switch (vectorOpcode) {
                case 192 -> Math.abs(x);
                case 193 -> -x;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i64x2_all_true(byte[] vec) {
        int result = 1;
        for (int i = 0; i < 2; ++i) {
            long x = byteArraySupport.getLong(vec, i * 8);
            if (x != 0L) continue;
            result = 0;
            break;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static int i64x2_bitmask(byte[] vec) {
        int result = 0;
        for (int i = 0; i < 2; ++i) {
            long x = byteArraySupport.getLong(vec, i * 8);
            if (x >= 0L) continue;
            result |= 1 << i;
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_shiftop(byte[] vecX, int shift, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long x = byteArraySupport.getLong(vecX, i * 8);
            long result = switch (vectorOpcode) {
                case 203 -> x << shift;
                case 204 -> x >> shift;
                case 205 -> x >>> shift;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_binop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long x = byteArraySupport.getLong(vecX, i * 8);
            long y = byteArraySupport.getLong(vecY, i * 8);
            long result = switch (vectorOpcode) {
                case 206 -> x + y;
                case 209 -> x - y;
                case 213 -> x * y;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_binop_extend_low_i32x4(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            int y = byteArraySupport.getInt(vecY, i * 4);
            long result = switch (vectorOpcode) {
                case 220 -> (long)x * (long)y;
                case 222 -> Integer.toUnsignedLong(x) * Integer.toUnsignedLong(y);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i64x2_binop_extend_high_i32x4(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(vecX, (i + 2) * 4);
            int y = byteArraySupport.getInt(vecY, (i + 2) * 4);
            long result = switch (vectorOpcode) {
                case 221 -> (long)x * (long)y;
                case 223 -> Integer.toUnsignedLong(x) * Integer.toUnsignedLong(y);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putLong(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_unop(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            float x = byteArraySupport.getFloat(vecX, i * 4);
            float result = switch (vectorOpcode) {
                case 224 -> Math.abs(x);
                case 225 -> -x;
                case 227 -> (float)Math.sqrt(x);
                case 103 -> (float)Math.ceil(x);
                case 104 -> (float)Math.floor(x);
                case 105 -> ExactMath.truncate((float)x);
                case 106 -> (float)Math.rint(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putFloat(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_binop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            float x = byteArraySupport.getFloat(vecX, i * 4);
            float y = byteArraySupport.getFloat(vecY, i * 4);
            float result = switch (vectorOpcode) {
                case 228 -> x + y;
                case 229 -> x - y;
                case 230 -> x * y;
                case 231 -> x / y;
                case 180, 232 -> Math.min(x, y);
                case 226, 233 -> Math.max(x, y);
                case 234 -> {
                    if (y < x) {
                        yield y;
                    }
                    yield x;
                }
                case 235 -> {
                    if (x < y) {
                        yield y;
                    }
                    yield x;
                }
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putFloat(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_ternop(byte[] vecX, byte[] vecY, byte[] vecZ, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            float x = byteArraySupport.getFloat(vecX, i * 4);
            float y = byteArraySupport.getFloat(vecY, i * 4);
            float z = byteArraySupport.getFloat(vecZ, i * 4);
            float result = switch (vectorOpcode) {
                case 175 -> x * y + z;
                case 176 -> -x * y + z;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putFloat(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_unop(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            double x = byteArraySupport.getDouble(vecX, i * 8);
            double result = switch (vectorOpcode) {
                case 236 -> Math.abs(x);
                case 237 -> -x;
                case 239 -> Math.sqrt(x);
                case 116 -> Math.ceil(x);
                case 117 -> Math.floor(x);
                case 122 -> ExactMath.truncate((double)x);
                case 148 -> Math.rint(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putDouble(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_binop(byte[] vecX, byte[] vecY, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            double x = byteArraySupport.getDouble(vecX, i * 8);
            double y = byteArraySupport.getDouble(vecY, i * 8);
            double result = switch (vectorOpcode) {
                case 240 -> x + y;
                case 241 -> x - y;
                case 242 -> x * y;
                case 243 -> x / y;
                case 212, 244 -> Math.min(x, y);
                case 238, 245 -> Math.max(x, y);
                case 246 -> {
                    if (y < x) {
                        yield y;
                    }
                    yield x;
                }
                case 247 -> {
                    if (x < y) {
                        yield y;
                    }
                    yield x;
                }
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putDouble(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_ternop(byte[] vecX, byte[] vecY, byte[] vecZ, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            double x = byteArraySupport.getDouble(vecX, i * 8);
            double y = byteArraySupport.getDouble(vecY, i * 8);
            double z = byteArraySupport.getDouble(vecZ, i * 8);
            double result = switch (vectorOpcode) {
                case 207 -> x * y + z;
                case 208 -> -x * y + z;
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putDouble(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_trunc_f32x4(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            float x = byteArraySupport.getFloat(vecX, i * 4);
            int result = switch (vectorOpcode) {
                case 165, 248 -> (int)x;
                case 166, 249 -> Vector128OpsFallback.truncSatU32(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_convert_i32x4(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            float result = switch (vectorOpcode) {
                case 250 -> x;
                case 251 -> Integer.toUnsignedLong(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putFloat(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] i32x4_trunc_f64x2_zero(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            double x = byteArraySupport.getDouble(vecX, i * 8);
            int result = switch (vectorOpcode) {
                case 197, 252 -> (int)x;
                case 198, 253 -> Vector128OpsFallback.truncSatU32(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putInt(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_convert_low_i32x4(byte[] vecX, int vectorOpcode) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            int x = byteArraySupport.getInt(vecX, i * 4);
            double result = switch (vectorOpcode) {
                case 254 -> x;
                case 255 -> Integer.toUnsignedLong(x);
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
            byteArraySupport.putDouble(vecResult, i * 8, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f32x4_demote_f64x2_zero(byte[] vecX) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            double x = byteArraySupport.getDouble(vecX, i * 8);
            float result = (float)x;
            byteArraySupport.putFloat(vecResult, i * 4, result);
        }
        return vecResult;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    private static byte[] f64x2_promote_low_f32x4(byte[] vecX) {
        byte[] vecResult = new byte[16];
        for (int i = 0; i < 2; ++i) {
            float x = byteArraySupport.getFloat(vecX, i * 4);
            double result = x;
            byteArraySupport.putDouble(vecResult, i * 8, result);
        }
        return vecResult;
    }

    private static byte satS8(int x) {
        if (x > 127) {
            return 127;
        }
        if (x < -128) {
            return -128;
        }
        return (byte)x;
    }

    private static byte satU8(int x) {
        if (x > 255) {
            return -1;
        }
        if (x < 0) {
            return 0;
        }
        return (byte)x;
    }

    private static short satS16(int x) {
        if (x > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        if (x < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)x;
    }

    private static short satU16(int x) {
        if (x > 65535) {
            return -1;
        }
        if (x < 0) {
            return 0;
        }
        return (short)x;
    }

    private static int truncSatU32(double x) {
        if (Double.isNaN(x) || x < 0.0) {
            return 0;
        }
        if (x > 4.294967295E9) {
            return -1;
        }
        return (int)ExactMath.truncate((double)x);
    }

    @Override
    public byte[] fromArray(byte[] bytes, int offset) {
        return Arrays.copyOfRange(bytes, offset, offset + 16);
    }

    @Override
    public byte[] toArray(byte[] vec) {
        return vec;
    }

    @Override
    public void intoArray(byte[] vec, byte[] array, int offset) {
        System.arraycopy(vec, 0, array, offset, 16);
    }

    @Override
    public Vector128 toVector128(byte[] vec) {
        return new Vector128(vec);
    }

    @Override
    public byte[] fromVector128(Vector128 vector128) {
        return vector128.getBytes();
    }
}

