/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmVariableNamesObject
implements TruffleObject {
    final List<String> names;

    WasmVariableNamesObject(List<String> names) {
        this.names = names;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getArraySize() {
        return this.names.size();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.names.get((int)index);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.names.size();
    }
}

