/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.graalvm.wasm.api.Vector128Ops;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.UnsafeUtilities;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import sun.misc.Unsafe;

@ExportLibrary(value=WasmMemoryLibrary.class)
public final class UnsafeWasmMemory
extends WasmMemory {
    private long startAddress;
    private long size;
    private ByteBuffer buffer;
    public static final long MAX_ALLOWED_SIZE = 32767L;
    private static final Unsafe unsafe;
    private static final long addressOffset;
    private static final VarHandle SIZE_FIELD;

    @CompilerDirectives.TruffleBoundary
    private UnsafeWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, shared);
        this.size = initialSize;
        long initialByteSize = this.byteSize();
        long maxAllowedByteSize = maxAllowedSize * 65536L;
        this.buffer = UnsafeWasmMemory.allocateBuffer(shared ? maxAllowedByteSize : initialByteSize);
        this.startAddress = UnsafeWasmMemory.getBufferAddress(this.buffer);
    }

    @CompilerDirectives.TruffleBoundary
    UnsafeWasmMemory(long declaredMinSize, long declaredMaxSize, boolean indexType64, boolean shared) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, Math.min(declaredMaxSize, 32767L), indexType64, shared);
    }

    @CompilerDirectives.TruffleBoundary
    private static ByteBuffer allocateBuffer(long byteSize) {
        try {
            return ByteBuffer.allocateDirect(Math.toIntExact(byteSize));
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }

    private static long getBufferAddress(ByteBuffer buffer) {
        return unsafe.getLong(buffer, addressOffset);
    }

    private void validateAddress(Node node, long address, long length) {
        UnsafeWasmMemory.validateAddress(node, address, length, this.byteSize());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void reset() {
        this.size = this.declaredMinSize;
        this.buffer = UnsafeWasmMemory.allocateBuffer(this.shared ? this.maxAllowedSize * 65536L : this.declaredMinSize * 65536L);
        this.startAddress = UnsafeWasmMemory.getBufferAddress(this.buffer);
        this.currentMinSize = this.declaredMinSize;
    }

    @ExportMessage
    public long size() {
        return SIZE_FIELD.getVolatile(this);
    }

    @ExportMessage
    public long byteSize() {
        return this.size * 65536L;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize()) <= 0 && Long.compareUnsigned(previousSize + extraPageSize, this.maxAllowedSize()) <= 0) {
            long updatedSize;
            long targetByteSize = Math.multiplyExact(Math.addExact(previousSize, extraPageSize), 65536);
            if (Long.compareUnsigned(targetByteSize, this.buffer.capacity()) > 0) {
                ByteBuffer updatedBuffer;
                long sourceByteSize = this.byteSize();
                try {
                    updatedBuffer = UnsafeWasmMemory.allocateBuffer(this.newBufferSize(targetByteSize));
                }
                catch (WasmException oome) {
                    return -1L;
                }
                long updatedStartAddress = UnsafeWasmMemory.getBufferAddress(updatedBuffer);
                unsafe.copyMemory(this.startAddress, updatedStartAddress, sourceByteSize);
                this.buffer = updatedBuffer;
                this.startAddress = updatedStartAddress;
            }
            this.currentMinSize = updatedSize = previousSize + extraPageSize;
            SIZE_FIELD.setVolatile(this, updatedSize);
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    public long newBufferSize(long targetByteSize) {
        long prefBufferSize = Math.addExact(this.buffer.capacity(), this.buffer.capacity() >> 1);
        long maxAllowedByteSize = Math.multiplyExact(this.maxAllowedSize(), 65536);
        return Math.max(targetByteSize, Math.min(prefBufferSize, maxAllowedByteSize));
    }

    @ExportMessage
    public int load_i32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        return unsafe.getLong(this.startAddress + address);
    }

    @ExportMessage
    public float load_f32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getFloat(this.startAddress + address);
    }

    @ExportMessage
    public double load_f64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        return unsafe.getDouble(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_8s(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return 0xFF & unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_16s(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return 0xFFFF & unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_8s(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return 0xFFL & (long)unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_16s(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return 0xFFFFL & (long)unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_32s(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return 0xFFFFFFFFL & (long)unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public Object load_i128(Node node, long address) {
        this.validateAddress(node, address, 16L);
        byte[] bytes = new byte[16];
        unsafe.copyMemory(null, this.startAddress + address, bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, 16L);
        return Vector128Ops.SINGLETON_IMPLEMENTATION.fromArray(bytes);
    }

    @ExportMessage
    public void store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        unsafe.putInt(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        unsafe.putLong(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_f32(Node node, long address, float value) {
        this.validateAddress(node, address, 4L);
        unsafe.putFloat(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_f64(Node node, long address, double value) {
        this.validateAddress(node, address, 8L);
        unsafe.putDouble(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        unsafe.putByte(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        unsafe.putShort(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        unsafe.putByte(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        unsafe.putShort(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        unsafe.putInt(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i128(Node node, long address, Object value) {
        this.validateAddress(node, address, 16L);
        unsafe.copyMemory(Vector128Ops.SINGLETON_IMPLEMENTATION.toArray(Vector128Ops.cast(value)), Unsafe.ARRAY_BYTE_BASE_OFFSET, null, this.startAddress + address, 16L);
    }

    @ExportMessage
    public int atomic_load_i32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getLongVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public int atomic_load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFF & unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public int atomic_load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFF & unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFFL & (long)unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFFL & (long)unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return 0xFFFFFFFFL & (long)unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public void atomic_store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        unsafe.putLongVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, value);
    }

    @ExportMessage
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, -value);
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, -value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, -value);
    }

    @ExportMessage
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndSetInt(null, this.startAddress + address, value);
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndSetInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndSetLong(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, expected, replacement);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        this.validateAddress(node, address, 4L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            throw UnsafeWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        this.validateAddress(node, address, 8L);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        if (!this.isShared()) {
            throw UnsafeWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @ExportMessage
    public void initialize(Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
        UnsafeWasmMemory.validateLength(node, length);
        this.validateAddress(node, destinationOffset, length);
        if (sourceOffset < 0 || sourceOffset > source.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsafeWasmMemory.trapOutOfBoundsBuffer(node, sourceOffset, length, source.length);
        }
        unsafe.copyMemory(source, Unsafe.ARRAY_BYTE_BASE_OFFSET + sourceOffset * Unsafe.ARRAY_BYTE_INDEX_SCALE, null, this.startAddress + destinationOffset, length);
    }

    @ExportMessage
    public void fill(Node node, long offset, long length, byte value) {
        UnsafeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        unsafe.setMemory(this.startAddress + offset, length, value);
    }

    @ExportMessage
    public void copyFrom(Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof UnsafeWasmMemory);
        UnsafeWasmMemory s = (UnsafeWasmMemory)source;
        UnsafeWasmMemory.validateLength(node, length);
        s.validateAddress(node, sourceOffset, length);
        this.validateAddress(node, destinationOffset, length);
        unsafe.copyMemory(s.startAddress + sourceOffset, this.startAddress + destinationOffset, length);
    }

    @ExportMessage
    public WasmMemory duplicate() {
        UnsafeWasmMemory other = new UnsafeWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size, this.maxAllowedSize, this.indexType64, this.shared);
        unsafe.copyMemory(this.startAddress, other.startAddress, this.byteSize());
        return other;
    }

    public void free() {
        this.buffer = null;
        this.startAddress = 0L;
        this.size = 0L;
    }

    @ExportMessage
    public boolean freed() {
        return this.startAddress == 0L;
    }

    @ExportMessage
    public void close() {
        if (!this.freed()) {
            this.free();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public ByteBuffer asByteBuffer() {
        return this.buffer.slice(0, Math.toIntExact(this.byteSize()));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        UnsafeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        int totalBytesRead = 0;
        for (int i = 0; i < length; ++i) {
            int byteRead = stream.read();
            if (byteRead == -1) {
                if (totalBytesRead != 0) break;
                return -1;
            }
            unsafe.putByte(this.startAddress + (long)offset + (long)i, (byte)byteRead);
            ++totalBytesRead;
        }
        return totalBytesRead;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        UnsafeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        for (int i = 0; i < length; ++i) {
            byte b = unsafe.getByte(this.startAddress + (long)offset + (long)i);
            stream.write(b & 0xFF);
        }
    }

    @ExportMessage
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        UnsafeWasmMemory.validateLength(node, length);
        this.validateAddress(node, srcOffset, length);
        if (dstOffset < 0 || dstOffset > dst.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsafeWasmMemory.trapOutOfBoundsBuffer(node, dstOffset, length, dst.length);
        }
        unsafe.copyMemory(null, this.startAddress + srcOffset, dst, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)dstOffset * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE, length);
    }

    private static long getObjectFieldOffset(Field field) {
        return unsafe.objectFieldOffset(field);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SIZE_FIELD = lookup.findVarHandle(UnsafeWasmMemory.class, "size", Long.TYPE);
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
            Field addressField = Buffer.class.getDeclaredField("address");
            addressOffset = UnsafeWasmMemory.getObjectFieldOffset(addressField);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

