/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiPathFilestatSetTimesNode
extends WasmBuiltinRootNode {
    public WasiPathFilestatSetTimesNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.pathFilestatSetTimeNode(instance.store(), this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3), (Long)WasmArguments.getArgument(args, 4), (Long)WasmArguments.getArgument(args, 5), (Integer)WasmArguments.getArgument(args, 6));
    }

    @CompilerDirectives.TruffleBoundary
    private int pathFilestatSetTimeNode(WasmStore store, WasmMemory memory, int fd, int flags, int pathAddress, int pathLength, long atim, long mtim, int fstFlags) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.pathFilestatSetTimes((Node)this, memory, flags, pathAddress, pathLength, atim, mtim, fstFlags).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_path_filestat_set_times";
    }
}

