/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmNamesObject
implements TruffleObject {
    private final String[] names;

    public WasmNamesObject(String[] names) {
        this.names = names;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.names.length;
    }

    @ExportMessage
    long getArraySize() {
        return this.names.length;
    }

    @ExportMessage
    Object readArrayElement(long index, @Bind Node node, @Cached InlinedBranchProfile errorBranch) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            errorBranch.enter(node);
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.names[(int)index];
    }
}

