/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import java.util.List;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;

public class DebugScopeValue
extends DebugObject {
    private final String name;
    private final List<DebugObject> values;

    public DebugScopeValue(String name, List<DebugObject> values) {
        assert (values != null) : "the list of values of a debug scope must not be null";
        this.name = name;
        this.values = values;
    }

    @Override
    public String toDisplayString() {
        return this.name;
    }

    @Override
    public String asTypeName() {
        return "";
    }

    @Override
    public int valueLength() {
        return 0;
    }

    @Override
    public boolean hasMembers() {
        return true;
    }

    @Override
    public int memberCount() {
        return this.values.size();
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        return this.values.get(index);
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return location;
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context;
    }
}

