/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class DebugBaseType
extends DebugType {
    private final String typeName;
    private final int encoding;
    private final int byteSize;
    private final int bitSize;
    private final int bitOffset;

    public DebugBaseType(String typeName, int encoding, int byteSize, int bitSize, int bitOffset) {
        this.typeName = typeName;
        this.encoding = encoding;
        this.byteSize = byteSize;
        this.bitSize = bitSize;
        this.bitOffset = bitOffset;
    }

    private static String toZeroTerminatedString(DebugLocation location) {
        byte b;
        StringBuilder builder = new StringBuilder();
        DebugLocation l = location;
        for (int i = 0; i < 255 && (b = l.loadI8()) != 0; ++i) {
            builder.append((char)b);
            l = l.nextByte();
        }
        return builder.toString();
    }

    @Override
    public String asTypeName() {
        return this.typeName;
    }

    @Override
    public int valueLength() {
        return this.byteSize;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        int effectiveBitSize = context.memberBitSizeOrDefault(this.bitSize);
        int effectiveBitOffset = context.memberBitOffsetOrDefault(this.bitOffset);
        if (this.encoding == 1) {
            return location.loadAsLocation();
        }
        if (this.encoding == 2) {
            return location.loadI8(effectiveBitSize, effectiveBitOffset) != 0;
        }
        if (this.encoding == 4) {
            if (this.byteSize == 4) {
                return Float.valueOf(location.loadF32());
            }
            if (this.byteSize == 8) {
                return location.loadF64();
            }
        }
        if (this.encoding == 5) {
            if (this.byteSize == 1) {
                return location.loadI8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadI16(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 4) {
                return location.loadI32(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 8) {
                return location.loadI64(effectiveBitSize, effectiveBitOffset);
            }
        }
        if (this.encoding == 7) {
            if (this.byteSize == 1) {
                return location.loadU8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadU16(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 4) {
                return location.loadU32(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 8) {
                return new DebugConstantDisplayValue(location.loadU64(effectiveBitSize, effectiveBitOffset));
            }
        }
        if (this.encoding == 6) {
            byte byteValue = location.loadI8(effectiveBitSize, effectiveBitOffset);
            return new DebugConstantDisplayValue("'" + (char)byteValue + "' " + byteValue);
        }
        if (this.encoding == 8) {
            int byteValue = location.loadU8(effectiveBitSize, effectiveBitOffset);
            return new DebugConstantDisplayValue("'" + (char)byteValue + "' " + byteValue);
        }
        if (this.encoding == 16) {
            return DebugBaseType.toZeroTerminatedString(location);
        }
        return DebugConstantDisplayValue.UNSUPPORTED;
    }

    @Override
    public boolean isModifiableValue() {
        return this.encoding == 2 || this.encoding == 4 || this.encoding == 5 || this.encoding == 7 && this.byteSize <= 4 || this.encoding == 6 || this.encoding == 8;
    }

    @Override
    public void setValue(DebugContext context, DebugLocation location, Object value, InteropLibrary lib) {
        if (!this.isModifiableValue()) {
            return;
        }
        int effectiveBitSize = context.memberBitSizeOrDefault(this.bitSize);
        try {
            if (this.encoding == 2 && lib.isBoolean(value)) {
                location.store8(effectiveBitSize, (byte)(lib.asBoolean(value) ? 1 : 0));
            }
            if (this.encoding == 4) {
                if (this.byteSize == 4 && lib.fitsInFloat(value)) {
                    location.storeF32(lib.asFloat(value));
                }
                if (this.byteSize == 8 && lib.fitsInDouble(value)) {
                    location.storeF64(lib.asDouble(value));
                }
            }
            if (this.encoding == 5 || this.encoding == 7) {
                if (this.byteSize == 1 && lib.fitsInByte(value)) {
                    location.store8(effectiveBitSize, lib.asByte(value));
                }
                if (this.byteSize == 2 && lib.fitsInShort(value)) {
                    location.store16(effectiveBitSize, lib.asShort(value));
                }
                if (this.byteSize == 4 && lib.fitsInInt(value)) {
                    location.store32(effectiveBitSize, lib.asInt(value));
                }
                if (this.byteSize == 8 && lib.fitsInLong(value)) {
                    location.store64(effectiveBitSize, lib.asLong(value));
                }
            }
            if (this.encoding == 6 || this.encoding == 8) {
                if (lib.fitsInByte(value)) {
                    location.store8(effectiveBitSize, lib.asByte(value));
                } else if (lib.isString(value)) {
                    location.store8(effectiveBitSize, (byte)lib.asString(value).charAt(0));
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    public boolean fitsIntoInt() {
        if (this.encoding == 5) {
            return this.byteSize <= 4;
        }
        if (this.encoding == 7) {
            return this.byteSize <= 2;
        }
        return false;
    }

    @Override
    public int asInt(DebugContext context, DebugLocation location) {
        int effectiveBitSize = context.memberBitSizeOrDefault(this.bitSize);
        int effectiveBitOffset = context.memberBitOffsetOrDefault(this.bitOffset);
        if (this.encoding == 5) {
            if (this.byteSize == 1) {
                return location.loadI8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadI16(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 4) {
                return location.loadI32(effectiveBitSize, effectiveBitOffset);
            }
        }
        if (this.encoding == 7) {
            if (this.byteSize == 1) {
                return location.loadU8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadU16(effectiveBitSize, effectiveBitOffset);
            }
        }
        return 0;
    }

    @Override
    public boolean fitsIntoLong() {
        if (this.encoding == 5) {
            return this.byteSize <= 8;
        }
        if (this.encoding == 7) {
            return this.byteSize <= 4;
        }
        return false;
    }

    @Override
    public long asLong(DebugContext context, DebugLocation location) {
        int effectiveBitSize = context.memberBitSizeOrDefault(this.bitSize);
        int effectiveBitOffset = context.memberBitOffsetOrDefault(this.bitOffset);
        if (this.encoding == 5) {
            if (this.byteSize == 1) {
                return location.loadI8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadI16(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 4) {
                return location.loadI32(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 8) {
                return location.loadI64(effectiveBitSize, effectiveBitOffset);
            }
        }
        if (this.encoding == 7) {
            if (this.byteSize == 1) {
                return location.loadU8(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 2) {
                return location.loadU16(effectiveBitSize, effectiveBitOffset);
            }
            if (this.byteSize == 4) {
                return location.loadU32(effectiveBitSize, effectiveBitOffset);
            }
        }
        return 0L;
    }
}

