/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.WasmDebugException;
import org.graalvm.wasm.debugging.data.DebugAddressSize;
import org.graalvm.wasm.debugging.encoding.DataEncoding;
import org.graalvm.wasm.debugging.parser.AbbreviationDeclaration;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParseUnit;
import org.graalvm.wasm.debugging.parser.DebugState;
import org.graalvm.wasm.debugging.parser.DebugUtil;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmDataAccess;

public class DebugParser {
    private static final int SUPPORTED_VERSION = 4;
    private static final int SUPPORTED_ADDRESS_LENGTH = 4;
    private static final int UNIT_HEADER_LENGTH = 4;
    private final byte[] data;
    private int offset;
    private int endOffset;

    public DebugParser(byte[] data) {
        this.data = data;
    }

    private boolean initializeAndCheckOffsets(int debugInfoOffset, int unitOffset) {
        int infoOffset = DebugUtil.getInfoOffsetOrUndefined(this.data, debugInfoOffset);
        int infoLength = DebugUtil.getInfoLengthOrUndefined(this.data, debugInfoOffset);
        if (infoOffset == -1 || infoLength == -1) {
            return false;
        }
        this.offset = unitOffset == 0 ? infoOffset : unitOffset;
        this.endOffset = infoOffset + infoLength;
        return this.offset < this.endOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public DebugData readCompilationUnitChildren(DebugParseUnit unit, int debugInfoOffset) {
        EconomicMap<Integer, AbbreviationDeclaration> abbreviationTable = unit.abbreviationTable();
        EconomicMap<Integer, DebugData> entries = unit.entries();
        int compilationUnitOffset = unit.compilationUnitOffset();
        this.offset = unit.entryOffset();
        try {
            return this.readDebugEntry(abbreviationTable, debugInfoOffset, compilationUnitOffset, entries, true);
        }
        catch (WasmDebugException e) {
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public int getNextCompilationUnitOffset(int debugInfoOffset, int unitOffset) {
        if (this.initializeAndCheckOffsets(debugInfoOffset, unitOffset)) {
            try {
                if (this.is64Bit()) {
                    return -1;
                }
                int unitLength = this.readInitialLength();
                return this.offset + unitLength;
            }
            catch (WasmDebugException e) {
                return -1;
            }
        }
        return -1;
    }

    @CompilerDirectives.TruffleBoundary
    public DebugParseUnit readCompilationUnit(int debugInfoOffset, int unitOffset) {
        int abbrevOffset = DebugUtil.getAbbrevOffsetOrUndefined(this.data, debugInfoOffset);
        int abbrevLength = DebugUtil.getAbbrevLengthOrUndefined(this.data, debugInfoOffset);
        if (abbrevOffset == -1 || abbrevLength == -1) {
            return null;
        }
        if (this.initializeAndCheckOffsets(debugInfoOffset, unitOffset)) {
            int unitStartOffset = this.offset;
            try {
                if (this.is64Bit()) {
                    return null;
                }
                int unitLength = this.readInitialLength();
                if (unitLength == -1) {
                    return null;
                }
                short version = this.read2();
                if (version != 4) {
                    return null;
                }
                int debugAbbrevOffset = this.read4();
                if (Integer.compareUnsigned(debugAbbrevOffset, abbrevLength) >= 0) {
                    return null;
                }
                byte addressSize = this.read1();
                if (addressSize != 4) {
                    return null;
                }
                this.endOffset = unitStartOffset + unitLength + 4;
                EconomicMap<Integer, AbbreviationDeclaration> abbreviationTable = this.readAbbrevSection(abbrevOffset + debugAbbrevOffset, abbrevLength);
                EconomicMap entries = EconomicMap.create();
                int entryOffset = this.offset;
                DebugData compilationUnit = this.readDebugEntry(abbreviationTable, debugInfoOffset, unitStartOffset, (EconomicMap<Integer, DebugData>)entries, false);
                if (compilationUnit != null && compilationUnit.tag() == 17) {
                    return new DebugParseUnit(compilationUnit, (EconomicMap<Integer, DebugData>)entries, abbreviationTable, entryOffset, unitStartOffset);
                }
            }
            catch (WasmDebugException e) {
                return null;
            }
        }
        return null;
    }

    private EconomicMap<Integer, AbbreviationDeclaration> readAbbrevSection(int abbrevOffset, int abbrevLength) throws WasmDebugException {
        int currentOffset = this.offset;
        int currentEndOffset = this.endOffset;
        this.offset = abbrevOffset;
        this.endOffset = abbrevOffset + abbrevLength;
        EconomicMap table = EconomicMap.create();
        while (true) {
            if (this.peekUnsignedInt() == 0) break;
            AbbreviationDeclaration d = this.readAbbrevEntry();
            table.put((Object)d.index(), (Object)d);
        }
        this.readUnsignedInt();
        this.offset = currentOffset;
        this.endOffset = currentEndOffset;
        return table;
    }

    private AbbreviationDeclaration readAbbrevEntry() throws WasmDebugException {
        int index = this.readUnsignedInt();
        int tag = this.readUnsignedInt();
        boolean children = this.read1() != 0;
        AbbreviationDeclaration entry = new AbbreviationDeclaration(index, tag, children);
        while (true) {
            int attributeName = this.readUnsignedInt();
            int attributeForm = this.readUnsignedInt();
            if (attributeName == 0 && attributeForm == 0) break;
            entry.addAttribute(attributeName, attributeForm);
        }
        return entry;
    }

    private DebugData readDebugEntry(EconomicMap<Integer, AbbreviationDeclaration> abbrevTable, int debugInfoOffset, int compilationUnitOffset, EconomicMap<Integer, DebugData> entries, boolean followChildren) throws WasmDebugException {
        int startOffset = this.offset;
        int abbrevDeclarationIndex = this.readUnsignedInt();
        AbbreviationDeclaration declaration = (AbbreviationDeclaration)abbrevTable.get((Object)abbrevDeclarationIndex);
        if (declaration == null) {
            return null;
        }
        int entryOffset = startOffset - compilationUnitOffset;
        long[] attributeInfo = new long[declaration.attributeCount()];
        Object[] attributes = new Object[declaration.attributeCount()];
        for (int i = 0; i != declaration.attributeCount(); ++i) {
            int attribute = declaration.attribute(i);
            int attributeEncoding = DataEncoding.fromForm(declaration.attributeForm(i));
            Object value = null;
            if (DataEncoding.isNumber(attributeEncoding)) {
                if (DataEncoding.isLen1(attributeEncoding)) {
                    value = this.read1();
                } else if (DataEncoding.isLen2(attributeEncoding)) {
                    value = this.read2();
                } else if (DataEncoding.isLen4(attributeEncoding)) {
                    value = this.read4();
                } else if (DataEncoding.isLen8(attributeEncoding)) {
                    value = this.read8();
                } else if (DataEncoding.isLeb128Signed(attributeEncoding)) {
                    try {
                        length = BinaryStreamParser.peekLeb128Length(this.data, this.offset);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new WasmDebugException(e.getMessage());
                    }
                    if (length > 4) {
                        this.checkOffset(length);
                        this.offset += length;
                        value = 0;
                    } else {
                        value = this.readInt();
                    }
                } else if (DataEncoding.isLeb128Unsigned(attributeEncoding)) {
                    try {
                        length = BinaryStreamParser.peekLeb128Length(this.data, this.offset);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new WasmDebugException(e.getMessage());
                    }
                    if (length > 4) {
                        this.checkOffset(length);
                        this.offset += length;
                        value = 0;
                    } else {
                        value = this.readUnsignedInt();
                    }
                }
            } else if (DataEncoding.isBoolean(attributeEncoding)) {
                if (DataEncoding.isLen1(attributeEncoding)) {
                    value = this.read1() != 0;
                } else if (DataEncoding.isFlag(attributeEncoding)) {
                    value = true;
                }
            } else if (DataEncoding.isString(attributeEncoding)) {
                if (DataEncoding.isLen4(attributeEncoding)) {
                    int stringOffset = this.read4();
                    int strOffset = DebugUtil.getStrOffsetOrUndefined(this.data, debugInfoOffset);
                    int strLength = DebugUtil.getStrLengthOrUndefined(this.data, debugInfoOffset);
                    if (strOffset == -1 || strLength == -1 || Integer.compareUnsigned(stringOffset, strLength) >= 0) {
                        return null;
                    }
                    value = this.readString(strOffset + stringOffset, strLength);
                } else {
                    value = this.readString();
                }
            } else if (DataEncoding.isByteArray(attributeEncoding)) {
                length = 0;
                if (DataEncoding.isLen1(attributeEncoding)) {
                    length = this.read1();
                }
                if (DataEncoding.isLen2(attributeEncoding)) {
                    length = this.read2();
                }
                if (DataEncoding.isLen4(attributeEncoding)) {
                    length = this.read4();
                }
                if (DataEncoding.isLeb128Unsigned(attributeEncoding)) {
                    length = this.readUnsignedInt();
                }
                byte[] blockData = new byte[length];
                for (int blockOffset = 0; blockOffset != length; ++blockOffset) {
                    blockData[blockOffset] = this.read1();
                }
                value = blockData;
            }
            attributeInfo[i] = (long)attributeEncoding << 32 | (long)attribute;
            attributes[i] = value;
        }
        ArrayList<DebugData> children = new ArrayList<DebugData>();
        if (declaration.hasChildren() && followChildren) {
            while (this.offset < this.endOffset) {
                if (this.peekUnsignedInt() == 0) {
                    this.readUnsignedInt();
                    break;
                }
                DebugData child = this.readDebugEntry(abbrevTable, debugInfoOffset, compilationUnitOffset, entries, true);
                if (child == null) continue;
                children.add(child);
            }
        }
        DebugData entry = new DebugData(declaration.tag(), entryOffset, attributeInfo, attributes, children.toArray(new DebugData[0]));
        entries.put((Object)entryOffset, (Object)entry);
        return entry;
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugLocation readFrameBaseExpressionOrNull(byte[] expressionData, MaterializedFrame frame, WasmDataAccess dataAccess, DebugAddressSize addressSize) {
        try {
            return DebugParser.readExpression(expressionData, frame, dataAccess, null, null, addressSize);
        }
        catch (WasmDebugException e) {
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugLocation readExpression(byte[] expressionData, DebugLocation location) {
        try {
            return DebugParser.readExpression(expressionData, location.frame(), location.dataAccess(), location.frameBase(), location, location.addressSize());
        }
        catch (WasmDebugException e) {
            return location.invalidate();
        }
    }

    private static DebugLocation readExpression(byte[] expressionData, MaterializedFrame frame, WasmDataAccess dataAccess, DebugLocation frameBase, DebugLocation baseLocation, DebugAddressSize addressSize) throws WasmDebugException {
        ArrayDeque<DebugLocation> valueStack = new ArrayDeque<DebugLocation>();
        if (baseLocation != null) {
            valueStack.push(baseLocation);
        }
        int exprOffset = 0;
        int expressionEndOffset = expressionData.length;
        while (exprOffset < expressionEndOffset) {
            byte opcode = DebugParser.peek1(expressionData, exprOffset, expressionEndOffset);
            ++exprOffset;
            block0 : switch (opcode) {
                case -19: {
                    byte type = DebugParser.peek1(expressionData, exprOffset, expressionEndOffset);
                    ++exprOffset;
                    switch (type) {
                        case 0: {
                            long valueAndLength = DebugParser.peekUnsignedIntValueAndLength(expressionData, exprOffset, expressionEndOffset);
                            int value = BinaryStreamParser.value(valueAndLength);
                            valueStack.push(DebugLocation.createLocalAccess(value, frame, dataAccess, frameBase, addressSize));
                            exprOffset += BinaryStreamParser.length(valueAndLength);
                            break block0;
                        }
                        case 1: {
                            long valueAndLength = DebugParser.peekUnsignedIntValueAndLength(expressionData, exprOffset, expressionEndOffset);
                            int value = BinaryStreamParser.value(valueAndLength);
                            valueStack.push(DebugLocation.createGlobalAccess(value, frame, dataAccess, frameBase, addressSize));
                            exprOffset += BinaryStreamParser.length(valueAndLength);
                            break block0;
                        }
                        case 2: {
                            long valueAndLength = DebugParser.peekUnsignedIntValueAndLength(expressionData, exprOffset, expressionEndOffset);
                            int value = BinaryStreamParser.value(valueAndLength);
                            valueStack.push(DebugLocation.createStackAccess(value, frame, dataAccess, frameBase, addressSize));
                            exprOffset += BinaryStreamParser.length(valueAndLength);
                            break block0;
                        }
                        case 3: {
                            int value = DebugParser.peek4(expressionData, exprOffset, expressionEndOffset);
                            valueStack.push(DebugLocation.createGlobalAccess(value, frame, dataAccess, frameBase, addressSize));
                            exprOffset += 4;
                        }
                    }
                    break;
                }
                case -97: {
                    return (DebugLocation)valueStack.pop();
                }
                case -111: {
                    long offsetValueAndLength = DebugParser.peekIntValueAndLength(expressionData, exprOffset, expressionEndOffset);
                    int offsetValue = BinaryStreamParser.value(offsetValueAndLength);
                    valueStack.push(frameBase.addOffset(offsetValue));
                    exprOffset += BinaryStreamParser.length(offsetValueAndLength);
                    break;
                }
                case 3: {
                    int value = DebugParser.peek4(expressionData, exprOffset, expressionEndOffset);
                    exprOffset += 4;
                    valueStack.push(DebugLocation.createMemoryAccess(value, frame, dataAccess, frameBase, addressSize));
                    break;
                }
                case 6: {
                    DebugLocation loc = (DebugLocation)valueStack.pop();
                    valueStack.push(loc.loadAsLocation());
                }
            }
        }
        return (DebugLocation)valueStack.pop();
    }

    private String readString(int stringOffset, int stringLength) throws WasmDebugException {
        int currentOffset = this.offset;
        int currentEndOffset = this.endOffset;
        this.offset = stringOffset;
        this.endOffset = stringOffset + stringLength;
        String s = this.readString();
        this.offset = currentOffset;
        this.endOffset = currentEndOffset;
        return s;
    }

    @CompilerDirectives.TruffleBoundary
    public DebugLineMap[] readLineSectionOrNull(int debugLineOffset, int debugLineLength, String compilationPath) {
        DebugState state;
        int currentOffset = this.offset;
        int currentEndOffset = this.endOffset;
        this.offset = debugLineOffset;
        this.endOffset = debugLineOffset + debugLineLength;
        try {
            state = this.readLineSectionHeader(compilationPath);
        }
        catch (WasmDebugException e) {
            return null;
        }
        if (state == null) {
            return null;
        }
        int sectionEndOffset = debugLineOffset + state.length();
        while (this.offset < sectionEndOffset) {
            try {
                int opcode = this.readUnsigned1();
                block2 : switch (opcode) {
                    case 0: {
                        int length = this.readUnsignedInt();
                        if (length == 0) break;
                        int extendedOpcode = this.readUnsigned1();
                        switch (extendedOpcode) {
                            case 1: {
                                state.setEndSequence();
                                break block2;
                            }
                            case 2: {
                                int address = this.read4();
                                if (address == -1) {
                                    state.setIgnore();
                                }
                                state.setAddress(address);
                                break block2;
                            }
                            case 3: {
                                this.readString();
                                this.read1();
                                this.readUnsignedInt();
                                this.readUnsignedInt();
                                this.readUnsignedInt();
                                break block2;
                            }
                            case 4: {
                                int discriminator = this.readUnsignedInt();
                                state.setDiscriminator(discriminator);
                            }
                        }
                        break;
                    }
                    case 1: {
                        state.addRow();
                        break;
                    }
                    case 2: {
                        int advance = this.readUnsignedInt();
                        state.advancePc(advance);
                        break;
                    }
                    case 3: {
                        int lineAdvance = this.readInt();
                        state.advanceLine(lineAdvance);
                        break;
                    }
                    case 4: {
                        int file = this.readUnsignedInt();
                        state.setFile(file);
                        break;
                    }
                    case 5: {
                        int column = this.readUnsignedInt();
                        state.setColumn(column);
                        break;
                    }
                    case 6: {
                        state.negateStatement();
                        break;
                    }
                    case 7: {
                        state.setBasicBlock();
                        break;
                    }
                    case 8: {
                        state.addConstantPc();
                        break;
                    }
                    case 9: {
                        short fixedAdvance = this.read2();
                        state.addFixedPc(fixedAdvance);
                        break;
                    }
                    case 10: {
                        state.setPrologueEnd();
                        break;
                    }
                    case 11: {
                        state.setEpilogueBegin();
                        break;
                    }
                    case 12: {
                        int isa = this.readUnsignedInt();
                        state.setIsa(isa);
                        break;
                    }
                    default: {
                        state.specialOpcode(opcode);
                    }
                }
            }
            catch (WasmDebugException e) {
                return null;
            }
        }
        this.offset = currentOffset;
        this.endOffset = currentEndOffset;
        return state.lineMaps();
    }

    private DebugState readLineSectionHeader(String compilationPath) throws WasmDebugException {
        Path cPath;
        int length = this.read4();
        short version = this.read2();
        if (version != 4) {
            return null;
        }
        int headerLength = this.read4();
        int headerEndOffset = this.offset + headerLength;
        int minInstrLength = this.readUnsigned1();
        int maxOpsPerInstr = this.readUnsigned1();
        int defaultIsStmt = this.readUnsigned1();
        byte lineBase = this.read1();
        int lineRange = this.readUnsigned1();
        int opcodeBase = this.readUnsigned1();
        for (int i = 0; i < opcodeBase - 1; i = (int)((byte)(i + 1))) {
            this.read1();
        }
        try {
            cPath = Path.of(compilationPath, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new WasmDebugException(e.getMessage());
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(cPath);
        byte lastByte = this.peek1();
        while (lastByte != 0) {
            try {
                Path dirPath = Path.of(this.readString(), new String[0]);
                if (dirPath.isAbsolute()) {
                    paths.add(dirPath);
                } else {
                    paths.add(cPath.resolve(dirPath));
                }
            }
            catch (InvalidPathException e) {
                throw new WasmDebugException(e.getMessage());
            }
            lastByte = this.peek1();
        }
        this.read1();
        ArrayList<Path> filePaths = new ArrayList<Path>();
        try {
            filePaths.add(cPath);
        }
        catch (InvalidPathException e) {
            throw new WasmDebugException(e.getMessage());
        }
        lastByte = this.peek1();
        while (lastByte != 0) {
            String name = this.readString();
            int pathIndex = this.readUnsignedInt();
            this.readUnsignedInt();
            this.readUnsignedInt();
            lastByte = this.peek1();
            try {
                Path filePath = Paths.get(name, new String[0]);
                if (filePath.isAbsolute()) {
                    filePaths.add(filePath);
                    continue;
                }
                filePaths.add(((Path)paths.get(pathIndex)).resolve(filePath));
            }
            catch (InvalidPathException e) {
                throw new WasmDebugException(e.getMessage());
            }
        }
        this.read1();
        if (filePaths.size() == 1) {
            return null;
        }
        if (this.offset != headerEndOffset) {
            return null;
        }
        return new DebugState(defaultIsStmt != 0, lineBase, lineRange, opcodeBase, minInstrLength, maxOpsPerInstr, length, filePaths);
    }

    @CompilerDirectives.TruffleBoundary
    public IntArrayList readRangeSectionOrNull(int rangeOffset, int rangeLength) {
        int currentOffset = this.offset;
        int currentEndOffset = this.endOffset;
        this.offset = rangeOffset;
        this.endOffset = rangeOffset + rangeLength;
        IntArrayList ranges = new IntArrayList();
        while (true) {
            int end;
            int start;
            try {
                start = this.read4();
                end = this.read4();
            }
            catch (WasmDebugException e) {
                return null;
            }
            if (start == -1) continue;
            if (start == 0 && end == 0) break;
            ranges.add(start);
            ranges.add(end);
        }
        this.offset = currentOffset;
        this.endOffset = currentEndOffset;
        return ranges;
    }

    /*
     * Unable to fully structure code
     */
    @CompilerDirectives.TruffleBoundary
    public byte[] readLocationListOrNull(int locOffset, int locLength) {
        currentOffset = this.offset;
        currentEndOffset = this.endOffset;
        this.offset = locOffset;
        this.endOffset = locOffset + locLength;
        b = null;
        try {
            block2: while (true) {
                start = this.read4();
                end = this.read4();
                if (start == -1) continue;
                if (start != 0 || end != 0) {
                    length = this.read2();
                    b = new byte[length];
                    i = 0;
                    while (true) {
                        if (i < length) ** break;
                        continue block2;
                        b[i] = this.read1();
                        ++i;
                    }
                }
                break;
            }
        }
        catch (WasmDebugException e) {
            return null;
        }
        this.offset = currentOffset;
        this.endOffset = currentEndOffset;
        return b;
    }

    private boolean is64Bit() throws WasmDebugException {
        return Integer.compareUnsigned(this.peek4(), -1) == 0;
    }

    private int readInitialLength() throws WasmDebugException {
        int value = this.read4();
        if (Integer.compareUnsigned(value, -16) > 0) {
            return -1;
        }
        return value;
    }

    private static void checkOffset(int offset, int endOffset, int length) throws WasmDebugException {
        if (Integer.compareUnsigned(offset + length, endOffset) > 0) {
            throw new WasmDebugException("out of bounds data access");
        }
    }

    private void checkOffset(int length) throws WasmDebugException {
        DebugParser.checkOffset(this.offset, this.endOffset, length);
    }

    private static byte peek1(byte[] data, int offset, int endOffset) throws WasmDebugException {
        DebugParser.checkOffset(offset, endOffset, 1);
        try {
            return BinaryStreamParser.peek1(data, offset);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private byte peek1() throws WasmDebugException {
        return DebugParser.peek1(this.data, this.offset, this.endOffset);
    }

    private byte read1() throws WasmDebugException {
        byte value = this.peek1();
        ++this.offset;
        return value;
    }

    private int readUnsigned1() throws WasmDebugException {
        return this.read1() & 0xFF;
    }

    private short read2() throws WasmDebugException {
        this.checkOffset(2);
        try {
            short value = BinaryStreamParser.peek2(this.data, this.offset);
            this.offset += 2;
            return value;
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private int peek4() throws WasmDebugException {
        return DebugParser.peek4(this.data, this.offset, this.endOffset);
    }

    private static int peek4(byte[] data, int offset, int endOffset) throws WasmDebugException {
        DebugParser.checkOffset(offset, endOffset, 4);
        try {
            return BinaryStreamParser.peek4(data, offset);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private int read4() throws WasmDebugException {
        int value = this.peek4();
        this.offset += 4;
        return value;
    }

    private long read8() throws WasmDebugException {
        this.checkOffset(8);
        try {
            long value = BinaryStreamParser.peek8(this.data, this.offset);
            this.offset += 8;
            return value;
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private int readInt() throws WasmDebugException {
        try {
            long valueAndLength = BinaryStreamParser.peekSignedInt32AndLength(this.data, this.offset);
            int length = BinaryStreamParser.length(valueAndLength);
            this.checkOffset(length);
            this.offset += length;
            return BinaryStreamParser.value(valueAndLength);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private static long peekIntValueAndLength(byte[] data, int offset, int endOffset) throws WasmDebugException {
        try {
            byte length = BinaryStreamParser.peekLeb128Length(data, offset);
            DebugParser.checkOffset(offset, endOffset, length);
            return BinaryStreamParser.peekSignedInt32AndLength(data, offset);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private int peekUnsignedInt() throws WasmDebugException {
        try {
            long valueAndLength = BinaryStreamParser.peekUnsignedInt32AndLength(this.data, this.offset);
            int length = BinaryStreamParser.length(valueAndLength);
            this.checkOffset(length);
            return BinaryStreamParser.value(valueAndLength);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private static long peekUnsignedIntValueAndLength(byte[] data, int offset, int endOffset) throws WasmDebugException {
        try {
            byte length = BinaryStreamParser.peekLeb128Length(data, offset);
            DebugParser.checkOffset(offset, endOffset, length);
            return BinaryStreamParser.peekUnsignedInt32AndLength(data, offset);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private int readUnsignedInt() throws WasmDebugException {
        try {
            long valueAndLength = BinaryStreamParser.peekUnsignedInt32AndLength(this.data, this.offset);
            int length = BinaryStreamParser.length(valueAndLength);
            this.checkOffset(length);
            this.offset += length;
            return BinaryStreamParser.value(valueAndLength);
        }
        catch (WasmException e) {
            throw new WasmDebugException(e.getMessage());
        }
    }

    private String readString() throws WasmDebugException {
        int startOffset = this.offset;
        byte stringByte = this.read1();
        while (stringByte != 0) {
            stringByte = this.read1();
        }
        return new String(this.data, startOffset, this.offset - startOffset - 1);
    }
}

