/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import java.util.Locale;
import org.graalvm.wasm.exception.ExceptionProvider;
import org.graalvm.wasm.exception.ExceptionProviders;
import org.graalvm.wasm.exception.Failure;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmException
extends AbstractTruffleException {
    private static final long serialVersionUID = -84137683950579647L;
    private final Failure failure;

    private WasmException(String message, Node location, Failure failure) {
        super(message, location);
        this.failure = failure;
    }

    public static WasmException create(Failure failure, Node location, String message) {
        return new WasmException(message, location, failure);
    }

    public static WasmException create(Failure failure, Node location) {
        return WasmException.create(failure, location, failure.name);
    }

    public static WasmException create(Failure failure, String message) {
        return WasmException.create(failure, null, message);
    }

    public static WasmException create(Failure failure) {
        return WasmException.create(failure, null, failure.name);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException format(Failure failure, String format, Object ... args) {
        return WasmException.create(failure, String.format(Locale.ROOT, format, args));
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException format(Failure failure, Node location, String format, Object ... args) {
        return WasmException.create(failure, location, String.format(Locale.ROOT, format, args));
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException format(Failure failure, Node location, String format, Object arg) {
        return WasmException.create(failure, location, String.format(Locale.ROOT, format, arg));
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException format(Failure failure, Node location, String format, int arg) {
        return WasmException.create(failure, location, String.format(Locale.ROOT, format, arg));
    }

    public static ExceptionProvider provider() {
        return ExceptionProviders.POLYGLOT_EXCEPTION_PROVIDER;
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public ExceptionType getExceptionType() {
        switch (this.failure.type) {
            case MALFORMED: 
            case INVALID: {
                return ExceptionType.PARSE_ERROR;
            }
        }
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readMember(String member) throws UnknownIdentifierException {
        switch (member) {
            case "message": {
                return this.getMessage();
            }
            case "failureType": {
                return this.failure.type.name;
            }
            case "failure": {
                return this.failure.name;
            }
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean isMemberReadable(String member) {
        switch (member) {
            case "message": 
            case "failureType": 
            case "failure": {
                return true;
            }
        }
        return false;
    }
}

