/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.nodes.WasmFixedMemoryImplFunctionNodeGen;
import org.graalvm.wasm.nodes.WasmFunctionBaseNode;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;

public abstract class WasmFixedMemoryImplFunctionNode
extends Node {
    private final WasmModule module;
    private final WasmCodeEntry codeEntry;
    private final int bytecodeStartOffset;
    private final int bytecodeEndOffset;
    private final Node[] callNodes;
    private static final WasmFunctionBaseNode[] EMPTY_FUNCTION_BASE_NODES = new WasmFunctionBaseNode[0];
    @Node.Children
    private WasmFunctionBaseNode[] functionBaseNodes = EMPTY_FUNCTION_BASE_NODES;

    protected WasmFixedMemoryImplFunctionNode(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes) {
        this.module = module;
        this.codeEntry = codeEntry;
        this.bytecodeStartOffset = bytecodeStartOffset;
        this.bytecodeEndOffset = bytecodeEndOffset;
        this.callNodes = callNodes;
    }

    public static WasmFixedMemoryImplFunctionNode create(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes) {
        return WasmFixedMemoryImplFunctionNodeGen.create(module, codeEntry, bytecodeStartOffset, bytecodeEndOffset, callNodes);
    }

    @Specialization(guards={"memoryCount() == 1"}, limit="3")
    protected void doFixedMemoryImpl(VirtualFrame frame, WasmInstance instance, @CachedLibrary(value="instance.memory(0)") WasmMemoryLibrary cachedMemoryLib0, @Cached(value="createMemoryLibs1(cachedMemoryLib0)") WasmMemoryLibrary[] cachedMemoryLibs, @Cached(value="createSpecializedFunctionNode(cachedMemoryLibs)", adopt=false) WasmFunctionBaseNode specializedFunctionNode) {
        specializedFunctionNode.execute(frame, instance);
    }

    @Specialization(replaces={"doFixedMemoryImpl"})
    protected void doDispatched(VirtualFrame frame, WasmInstance instance, @Cached(value="createDispatchedFunctionNode()", adopt=false) WasmFunctionBaseNode dispatchedFunctionNode) {
        dispatchedFunctionNode.execute(frame, instance);
    }

    @NeverDefault
    protected WasmMemoryLibrary[] createMemoryLibs1(WasmMemoryLibrary memoryLibs) {
        return new WasmMemoryLibrary[]{memoryLibs};
    }

    @Idempotent
    protected int memoryCount() {
        return this.module.memoryCount();
    }

    @NeverDefault
    protected WasmFunctionBaseNode createSpecializedFunctionNode(WasmMemoryLibrary[] memoryLibs) {
        CompilerAsserts.neverPartOfCompilation();
        WasmInstrumentableFunctionNode instrumentableFunctionNode = new WasmInstrumentableFunctionNode(this.module, this.codeEntry, this.bytecodeStartOffset, this.bytecodeEndOffset, this.callNodes, memoryLibs);
        WasmFunctionBaseNode baseNode = new WasmFunctionBaseNode(instrumentableFunctionNode);
        this.functionBaseNodes = Arrays.copyOf(this.functionBaseNodes, this.functionBaseNodes.length + 1);
        this.functionBaseNodes[this.functionBaseNodes.length - 1] = (WasmFunctionBaseNode)this.insert(baseNode);
        this.notifyInserted(instrumentableFunctionNode);
        return baseNode;
    }

    @NeverDefault
    protected WasmFunctionBaseNode createDispatchedFunctionNode() {
        CompilerAsserts.neverPartOfCompilation();
        WasmMemoryLibrary[] memoryLibs = new WasmMemoryLibrary[this.module.memoryCount()];
        for (int memoryIndex = 0; memoryIndex < this.module.memoryCount(); ++memoryIndex) {
            memoryLibs[memoryIndex] = (WasmMemoryLibrary)this.insert((Node)((WasmMemoryLibrary)WasmMemoryLibrary.getFactory().createDispatched(3)));
        }
        WasmInstrumentableFunctionNode instrumentableFunctionNode = new WasmInstrumentableFunctionNode(this.module, this.codeEntry, this.bytecodeStartOffset, this.bytecodeEndOffset, this.callNodes, memoryLibs);
        WasmFunctionBaseNode baseNode = new WasmFunctionBaseNode(instrumentableFunctionNode);
        this.functionBaseNodes = new WasmFunctionBaseNode[]{(WasmFunctionBaseNode)this.insert(baseNode)};
        this.notifyInserted(instrumentableFunctionNode);
        return baseNode;
    }

    public abstract void execute(VirtualFrame var1, WasmInstance var2);

    final Node[] getCallNodes() {
        return this.callNodes;
    }
}

