/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.graalvm.wasm.api.Vector128Ops;

public abstract class WasmFrame {
    private WasmFrame() {
    }

    public static void dropPrimitive(VirtualFrame frame, int slot) {
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
    }

    public static void dropObject(VirtualFrame frame, int slot) {
        frame.clearObjectStatic(slot);
    }

    public static void drop(VirtualFrame frame, int slot) {
        frame.clearStatic(slot);
    }

    public static void copyPrimitive(VirtualFrame frame, int sourceSlot, int targetSlot) {
        frame.copyPrimitiveStatic(sourceSlot, targetSlot);
    }

    public static void copyObject(VirtualFrame frame, int sourceSlot, int targetSlot) {
        frame.copyObjectStatic(sourceSlot, targetSlot);
    }

    public static void copy(VirtualFrame frame, int sourceSlot, int targetSlot) {
        frame.copyStatic(sourceSlot, targetSlot);
    }

    public static boolean popBoolean(VirtualFrame frame, int slot) {
        boolean result;
        boolean bl = result = frame.getIntStatic(slot) != 0;
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
        return result;
    }

    public static int popInt(VirtualFrame frame, int slot) {
        int result = frame.getIntStatic(slot);
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
        return result;
    }

    public static void pushInt(VirtualFrame frame, int slot, int value) {
        frame.setIntStatic(slot, value);
    }

    public static long popLong(VirtualFrame frame, int slot) {
        long result = frame.getLongStatic(slot);
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
        return result;
    }

    public static void pushLong(VirtualFrame frame, int slot, long value) {
        frame.setLongStatic(slot, value);
    }

    public static float popFloat(VirtualFrame frame, int slot) {
        float result = frame.getFloatStatic(slot);
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
        return result;
    }

    public static void pushFloat(VirtualFrame frame, int slot, float value) {
        frame.setFloatStatic(slot, value);
    }

    public static double popDouble(VirtualFrame frame, int slot) {
        double result = frame.getDoubleStatic(slot);
        if (CompilerDirectives.inCompiledCode()) {
            frame.clearPrimitiveStatic(slot);
        }
        return result;
    }

    public static void pushDouble(VirtualFrame frame, int slot, double value) {
        frame.setDoubleStatic(slot, value);
    }

    public static <V128> V128 popVector128(VirtualFrame frame, int slot) {
        Object result = Vector128Ops.cast(frame.getObjectStatic(slot));
        frame.clearObjectStatic(slot);
        return (V128)result;
    }

    public static <T> void pushVector128(VirtualFrame frame, int slot, T value) {
        frame.setObjectStatic(slot, value);
    }

    public static Object popReference(VirtualFrame frame, int slot) {
        Object result = frame.getObjectStatic(slot);
        frame.clearObjectStatic(slot);
        return result;
    }

    public static void pushReference(VirtualFrame frame, int slot, Object value) {
        frame.setObjectStatic(slot, value);
    }
}

