/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.util.Iterator;
import org.graalvm.collections.EconomicSet;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.debugging.DebugLineSection;
import org.graalvm.wasm.nodes.WasmBaseStatementNode;
import org.graalvm.wasm.nodes.WasmStatementNode;

public final class WasmInstrumentationSupportNode
extends Node {
    @Node.Children
    private final WasmBaseStatementNode[] statementNodes;
    private int sourceLocation;

    @CompilerDirectives.TruffleBoundary
    public WasmInstrumentationSupportNode(DebugLineSection lineSection, Source source) {
        if (!lineSection.isEmpty()) {
            EconomicSet<Integer> lines = lineSection.uniqueLines();
            this.statementNodes = new WasmBaseStatementNode[lines.size()];
            int i = 0;
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                int line = (Integer)iterator.next();
                this.statementNodes[i++] = new WasmStatementNode(line, source);
            }
        } else {
            this.statementNodes = null;
        }
    }

    public void notifyLine(VirtualFrame frame, int currentLineIndex, int nextLineIndex, int currentSourceLocation) {
        CompilerAsserts.partialEvaluationConstant((int)currentLineIndex);
        CompilerAsserts.partialEvaluationConstant((int)nextLineIndex);
        InstrumentableNode.WrapperNode currentLineWrapper = this.getWrapperAt(currentLineIndex);
        InstrumentableNode.WrapperNode nextLineWrapper = this.getWrapperAt(nextLineIndex);
        if (currentLineWrapper == nextLineWrapper) {
            return;
        }
        this.sourceLocation = currentSourceLocation;
        WasmInstrumentationSupportNode.exitAt(frame, currentLineWrapper);
        WasmInstrumentationSupportNode.enterAt(frame, nextLineWrapper);
    }

    private static void enterAt(VirtualFrame frame, InstrumentableNode.WrapperNode wrapperNode) {
        if (wrapperNode == null) {
            return;
        }
        ProbeNode probeNode = wrapperNode.getProbeNode();
        try {
            probeNode.onEnter(frame);
        }
        catch (Throwable t) {
            Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, false);
            if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            if (result != null) {
                return;
            }
            throw t;
        }
    }

    private static void exitAt(VirtualFrame frame, InstrumentableNode.WrapperNode wrapperNode) {
        if (wrapperNode == null) {
            return;
        }
        ProbeNode probeNode = wrapperNode.getProbeNode();
        try {
            probeNode.onReturnValue(frame, (Object)WasmConstant.VOID);
        }
        catch (Throwable t) {
            Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, true);
            if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            if (result != null) {
                return;
            }
            throw t;
        }
    }

    private InstrumentableNode.WrapperNode getWrapperAt(int lineIndex) {
        if (this.statementNodes == null || lineIndex < 0 || lineIndex >= this.statementNodes.length) {
            return null;
        }
        WasmBaseStatementNode node = this.statementNodes[lineIndex];
        if (!(node instanceof InstrumentableNode.WrapperNode)) {
            return null;
        }
        CompilerAsserts.partialEvaluationConstant((Object)((Object)node));
        return (InstrumentableNode.WrapperNode)node;
    }

    public int currentSourceLocation() {
        return this.sourceLocation;
    }
}

