/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.Linker;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.collection.ByteArrayList;
import org.graalvm.wasm.constants.Bytecode;
import org.graalvm.wasm.globals.WasmGlobal;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.parser.ir.CallNode;
import org.graalvm.wasm.parser.ir.CodeEntry;

public abstract class BytecodeParser {
    public static void resetGlobalState(WasmModule module, WasmInstance instance) {
        for (int i = 0; i < module.numGlobals(); ++i) {
            if (module.globalImported(i)) continue;
            Object initValue = module.globalInitialized(i) ? module.globalInitialValue(i) : Linker.evalConstantExpression(instance, module.globalInitializerBytecode(i));
            if (module.globalExternal(i)) {
                WasmGlobal global = instance.externalGlobal(i);
                try {
                    InteropLibrary interop = InteropLibrary.getUncached((Object)global);
                    if (!global.isMutable()) {
                        if (Objects.equals(interop.readMember((Object)global, "value"), initValue)) continue;
                        throw CompilerDirectives.shouldNotReachHere((String)"Value of immutable global is not equal to init value");
                    }
                    interop.writeMember((Object)global, "value", initValue);
                    continue;
                }
                catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            instance.globals().store(module.globalValueType(i), module.globalAddress(i), initValue);
        }
    }

    public static void resetMemoryState(WasmModule module, WasmInstance instance) {
        byte[] bytecode = module.bytecode();
        for (int i = 0; i < module.dataInstanceCount(); ++i) {
            int dataLength;
            int dataOffset = module.dataInstanceOffset(i);
            byte flags = bytecode[dataOffset];
            int effectiveOffset = dataOffset + 1;
            int dataMode = flags & 1;
            switch (flags & 0xC0) {
                case 64: {
                    dataLength = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                    ++effectiveOffset;
                    break;
                }
                case 128: {
                    dataLength = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                    effectiveOffset += 2;
                    break;
                }
                case 192: {
                    dataLength = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                    effectiveOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (dataMode == 0) {
                int memoryIndex;
                long offsetAddress;
                byte[] offsetBytecode;
                long value;
                switch (flags & 0xE) {
                    case 0: {
                        value = -1L;
                        break;
                    }
                    case 2: {
                        value = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        ++effectiveOffset;
                        break;
                    }
                    case 4: {
                        value = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 6: {
                        value = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    case 8: {
                        value = BinaryStreamParser.rawPeekI64(bytecode, effectiveOffset);
                        effectiveOffset += 8;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                if ((flags & 0x10) == 0 && (flags & 0xE) != 0) {
                    int offsetBytecodeLength = (int)value;
                    offsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset, effectiveOffset + offsetBytecodeLength);
                    effectiveOffset += offsetBytecodeLength;
                    offsetAddress = -1L;
                } else {
                    offsetBytecode = null;
                    offsetAddress = value;
                }
                if (offsetBytecode != null) {
                    offsetAddress = ((Number)Linker.evalConstantExpression(instance, offsetBytecode)).longValue();
                }
                if ((flags & 0x20) != 0) {
                    memoryIndex = 0;
                } else {
                    byte memoryIndexEncoding = bytecode[effectiveOffset];
                    ++effectiveOffset;
                    switch (memoryIndexEncoding & 0xC0) {
                        case 0: {
                            memoryIndex = memoryIndexEncoding & 0x3F;
                            break;
                        }
                        case 64: {
                            memoryIndex = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                            ++effectiveOffset;
                            break;
                        }
                        case 128: {
                            memoryIndex = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                            effectiveOffset += 2;
                            break;
                        }
                        case 192: {
                            memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                            effectiveOffset += 4;
                            break;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                }
                WasmMemory memory = instance.memory(memoryIndex);
                WasmMemoryLibrary memoryLib = WasmMemoryLibrary.getUncached();
                memoryLib.initialize(memory, null, module.bytecode(), effectiveOffset, offsetAddress, dataLength);
                continue;
            }
            instance.setDataInstance(i, effectiveOffset);
        }
    }

    public static void resetTableState(WasmStore store, WasmModule module, WasmInstance instance) {
        byte[] bytecode = module.bytecode();
        for (int i = 0; i < module.elemInstanceCount(); ++i) {
            int elemCount;
            int elemOffset = module.elemInstanceOffset(i);
            byte flags = bytecode[elemOffset];
            byte typeAndMode = bytecode[elemOffset + 1];
            int effectiveOffset = elemOffset + 2;
            int elemMode = typeAndMode & 0xF;
            switch (flags & 0xC0) {
                case 64: {
                    elemCount = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                    ++effectiveOffset;
                    break;
                }
                case 128: {
                    elemCount = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                    effectiveOffset += 2;
                    break;
                }
                case 192: {
                    elemCount = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                    effectiveOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            Linker linker = Objects.requireNonNull(store.linker());
            if (elemMode == 0) {
                int offsetAddress;
                byte[] offsetBytecode;
                int tableIndex;
                switch (flags & 0x30) {
                    case 0: {
                        tableIndex = 0;
                        break;
                    }
                    case 16: {
                        tableIndex = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        ++effectiveOffset;
                        break;
                    }
                    case 32: {
                        tableIndex = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 48: {
                        tableIndex = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                switch (flags & 0xC) {
                    case 0: {
                        offsetBytecode = null;
                        break;
                    }
                    case 4: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, ++effectiveOffset, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    case 8: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset += 2, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    case 12: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset += 4, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                switch (flags & 3) {
                    case 0: {
                        offsetAddress = -1;
                        break;
                    }
                    case 1: {
                        offsetAddress = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        ++effectiveOffset;
                        break;
                    }
                    case 2: {
                        offsetAddress = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 3: {
                        offsetAddress = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                linker.immediatelyResolveElemSegment(store, instance, tableIndex, offsetAddress, offsetBytecode, effectiveOffset, elemCount);
                continue;
            }
            if (elemMode != 1) continue;
            linker.immediatelyResolvePassiveElementSegment(store, instance, i, effectiveOffset, elemCount);
        }
    }

    public static CodeEntry[] readCodeEntries(WasmModule module) {
        byte[] bytecode = module.bytecode();
        CodeEntry[] codeEntries = new CodeEntry[module.codeEntryCount()];
        for (int i = 0; i < module.codeEntryCount(); ++i) {
            codeEntries[i] = BytecodeParser.readCodeEntry(module, bytecode, i);
        }
        return codeEntries;
    }

    public static CodeEntry readCodeEntry(WasmModule module, byte[] bytecode, int codeEntryIndex) {
        byte[] results;
        byte[] locals;
        int length;
        int maxStackSize;
        int functionIndex;
        int codeEntryOffset = module.codeEntryOffset(codeEntryIndex);
        byte flags = bytecode[codeEntryOffset];
        int effectiveOffset = codeEntryOffset + 1;
        switch (flags & 0xC0) {
            case 0: {
                functionIndex = 0;
                break;
            }
            case 64: {
                functionIndex = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                ++effectiveOffset;
                break;
            }
            case 128: {
                functionIndex = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                effectiveOffset += 2;
                break;
            }
            case 192: {
                functionIndex = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                effectiveOffset += 4;
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        switch (flags & 0x30) {
            case 0: {
                maxStackSize = 0;
                break;
            }
            case 16: {
                maxStackSize = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                ++effectiveOffset;
                break;
            }
            case 32: {
                maxStackSize = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                effectiveOffset += 2;
                break;
            }
            case 48: {
                maxStackSize = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                effectiveOffset += 4;
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        switch (flags & 0xC) {
            case 4: {
                length = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                ++effectiveOffset;
                break;
            }
            case 8: {
                length = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                effectiveOffset += 2;
                break;
            }
            case 12: {
                length = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                effectiveOffset += 4;
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        if ((flags & 2) != 0) {
            ByteArrayList localsList = new ByteArrayList();
            while (bytecode[effectiveOffset] != 0) {
                localsList.add(bytecode[effectiveOffset]);
                ++effectiveOffset;
            }
            ++effectiveOffset;
            locals = localsList.toArray();
        } else {
            locals = Bytecode.EMPTY_BYTES;
        }
        if ((flags & 1) != 0) {
            ByteArrayList resultsList = new ByteArrayList();
            while (bytecode[effectiveOffset] != 0) {
                resultsList.add(bytecode[effectiveOffset]);
                ++effectiveOffset;
            }
            results = resultsList.toArray();
        } else {
            results = Bytecode.EMPTY_BYTES;
        }
        List<CallNode> callNodes = BytecodeParser.readCallNodes(bytecode, codeEntryOffset - length, codeEntryOffset);
        boolean usesMemoryZero = module.memoryCount() != 0;
        return new CodeEntry(functionIndex, maxStackSize, locals, results, callNodes, codeEntryOffset - length, codeEntryOffset, usesMemoryZero);
    }

    private static List<CallNode> readCallNodes(byte[] bytecode, int startOffset, int endOffset) {
        int offset = startOffset;
        ArrayList<CallNode> callNodes = new ArrayList<CallNode>();
        while (offset < endOffset) {
            int opcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
            int originalOffset = offset++;
            block0 : switch (opcode) {
                case 17: {
                    int functionIndex = BinaryStreamParser.rawPeekU8(bytecode, offset + 1);
                    callNodes.add(new CallNode(originalOffset, functionIndex));
                    offset += 2;
                    break;
                }
                case 18: {
                    int functionIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                    callNodes.add(new CallNode(originalOffset, functionIndex));
                    offset += 8;
                    break;
                }
                case 19: {
                    callNodes.add(new CallNode(originalOffset));
                    offset += 3;
                    break;
                }
                case 20: {
                    callNodes.add(new CallNode(originalOffset));
                    offset += 12;
                    break;
                }
                case 23: 
                case 24: {
                    offset += 2;
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 8: 
                case 21: 
                case 22: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: {
                    break;
                }
                case 2: 
                case 3: 
                case 10: {
                    offset += opcode;
                    break;
                }
                case 5: 
                case 11: 
                case 25: 
                case 27: 
                case 29: 
                case 31: 
                case 33: 
                case 35: 
                case 37: 
                case 39: 
                case 42: 
                case 45: 
                case 48: 
                case 51: 
                case 54: 
                case 57: 
                case 60: 
                case 63: 
                case 66: 
                case 69: 
                case 72: 
                case 75: 
                case 78: 
                case 81: 
                case 84: 
                case 87: 
                case 90: 
                case 93: 
                case 96: 
                case 99: 
                case 102: 
                case 105: 
                case 108: 
                case 112: 
                case 114: {
                    ++offset;
                    break;
                }
                case 6: {
                    offset += 2;
                    break;
                }
                case 13: {
                    offset += 3;
                    break;
                }
                case 12: 
                case 26: 
                case 28: 
                case 30: 
                case 32: 
                case 34: 
                case 36: 
                case 38: 
                case 40: 
                case 43: 
                case 46: 
                case 49: 
                case 52: 
                case 55: 
                case 58: 
                case 61: 
                case 64: 
                case 67: 
                case 70: 
                case 73: 
                case 76: 
                case 79: 
                case 82: 
                case 85: 
                case 88: 
                case 91: 
                case 94: 
                case 97: 
                case 100: 
                case 103: 
                case 106: 
                case 109: 
                case 110: 
                case 111: 
                case 113: 
                case 116: 
                case 248: 
                case 249: 
                case 250: {
                    offset += 4;
                    break;
                }
                case 9: 
                case 14: {
                    offset += 6;
                    break;
                }
                case 115: 
                case 117: 
                case 254: {
                    offset += 8;
                    break;
                }
                case 7: {
                    offset += 9;
                    break;
                }
                case 15: {
                    int size = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    offset += 3 + size * 6;
                    break;
                }
                case 16: {
                    int size = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 6 + size * 6;
                    break;
                }
                case 41: 
                case 44: 
                case 47: 
                case 50: 
                case 53: 
                case 56: 
                case 59: 
                case 62: 
                case 65: 
                case 68: 
                case 71: 
                case 74: 
                case 77: 
                case 80: 
                case 83: 
                case 86: 
                case 89: 
                case 92: 
                case 95: 
                case 98: 
                case 101: 
                case 104: 
                case 107: {
                    int flags = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int offsetLength = flags & 0xF;
                    offset += 4;
                    switch (offsetLength) {
                        case 1: {
                            ++offset;
                            break block0;
                        }
                        case 4: {
                            offset += 4;
                            break block0;
                        }
                        case 8: {
                            offset += 8;
                            break block0;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case 251: {
                    int miscOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    switch (miscOpcode) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            break block0;
                        }
                        case 12: 
                        case 13: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 25: 
                        case 26: 
                        case 27: {
                            offset += 4;
                            break block0;
                        }
                        case 8: 
                        case 10: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 22: 
                        case 24: {
                            offset += 8;
                            break block0;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case 252: {
                    int atomicOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    if (atomicOpcode == 63) break;
                    switch (atomicOpcode) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 65: 
                        case 66: {
                            int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                            ++offset;
                            int indexType64 = encoding & 0x80;
                            offset += 4;
                            if (indexType64 == 0) {
                                offset += 4;
                                break block0;
                            }
                            offset += 8;
                            break block0;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case 253: {
                    int vectorOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    switch (vectorOpcode) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 92: 
                        case 93: {
                            int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                            ++offset;
                            int indexType64 = encoding & 0x80;
                            offset += 4;
                            if (indexType64 == 0) {
                                offset += 4;
                                break block0;
                            }
                            offset += 8;
                            break block0;
                        }
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: {
                            int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                            ++offset;
                            int indexType64 = encoding & 0x80;
                            offset += 4;
                            offset = indexType64 == 0 ? (offset += 4) : (offset += 8);
                            ++offset;
                            break block0;
                        }
                        case 12: 
                        case 13: {
                            offset += 16;
                            break block0;
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: {
                            ++offset;
                            break block0;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: 
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: {
                            break block0;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }
        return callNodes;
    }
}

