/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.ir;

import java.util.List;
import org.graalvm.wasm.parser.ir.CallNode;

public final class CodeEntry {
    private final int functionIndex;
    private final int maxStackSize;
    private final byte[] localTypes;
    private final byte[] resultTypes;
    private final List<CallNode> callNodes;
    private final int bytecodeStartOffset;
    private final int bytecodeEndOffset;
    private final boolean usesMemoryZero;

    public CodeEntry(int functionIndex, int maxStackSize, byte[] localTypes, byte[] resultTypes, List<CallNode> callNodes, int startOffset, int endOffset, boolean usesMemoryZero) {
        this.functionIndex = functionIndex;
        this.maxStackSize = maxStackSize;
        this.localTypes = localTypes;
        this.resultTypes = resultTypes;
        this.callNodes = callNodes;
        this.bytecodeStartOffset = startOffset;
        this.bytecodeEndOffset = endOffset;
        this.usesMemoryZero = usesMemoryZero;
    }

    public int maxStackSize() {
        return this.maxStackSize;
    }

    public int functionIndex() {
        return this.functionIndex;
    }

    public byte[] localTypes() {
        return this.localTypes;
    }

    public byte[] resultTypes() {
        return this.resultTypes;
    }

    public List<CallNode> callNodes() {
        return this.callNodes;
    }

    public int bytecodeStartOffset() {
        return this.bytecodeStartOffset;
    }

    public int bytecodeEndOffset() {
        return this.bytecodeEndOffset;
    }

    public boolean usesMemoryZero() {
        return this.usesMemoryZero;
    }
}

