/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiFdDatasyncNode
extends WasmBuiltinRootNode {
    public WasiFdDatasyncNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return WasiFdDatasyncNode.fdDatasync(instance.store(), (Integer)WasmArguments.getArgument(args, 0));
    }

    @CompilerDirectives.TruffleBoundary
    private static int fdDatasync(WasmStore store, int fd) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.datasync().ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_datasync";
    }
}

