/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiFdFdstatSetRightsNode
extends WasmBuiltinRootNode {
    public WasiFdFdstatSetRightsNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return WasiFdFdstatSetRightsNode.fdFdstatSetRights(instance.store(), (Integer)WasmArguments.getArgument(args, 0), (Long)WasmArguments.getArgument(args, 1), (Long)WasmArguments.getArgument(args, 2));
    }

    @CompilerDirectives.TruffleBoundary
    private static int fdFdstatSetRights(WasmStore store, int fd, long fsRightsBase, long fsRightsInheriting) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.fdstatSetRights(fsRightsBase, fsRightsInheriting).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_fdstat_set_rights";
    }
}

