/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.types.Filetype;

public final class Dirent {
    public static final int BYTES = 24;

    private Dirent() {
    }

    public static long readDNext(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 0);
    }

    public static void writeDNext(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 0, value);
    }

    public static void writeDNextToByteArray(byte[] buffer, int address, long value) {
        ByteArraySupport.littleEndian().putLong(buffer, address + 0, value);
    }

    public static long readDIno(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 8);
    }

    public static void writeDIno(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 8, value);
    }

    public static void writeDInoToByteArray(byte[] buffer, int address, long value) {
        ByteArraySupport.littleEndian().putLong(buffer, address + 8, value);
    }

    public static int readDNamlen(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i32(memory, node, address + 16);
    }

    public static void writeDNamlen(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, int value) {
        memoryLib.store_i32(memory, node, address + 16, value);
    }

    public static void writeDNamlen(byte[] buffer, int address, int value) {
        ByteArraySupport.littleEndian().putInt(buffer, address + 16, value);
    }

    public static Filetype readDType(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Filetype.fromValue((byte)memoryLib.load_i32_8u(memory, node, address + 20));
    }

    public static void writeDType(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Filetype value) {
        memoryLib.store_i32_8(memory, node, address + 20, value.toValue());
    }

    public static void writeDType(byte[] buffer, int address, Filetype value) {
        ByteArraySupport.littleEndian().putByte(buffer, address + 20, value.toValue());
    }
}

