/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.normalizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.test.normalizer.OutputNormalizer;

public class GradleOutputNormalizer
implements OutputNormalizer {
    private static final Pattern STACK_TRACE_ELEMENT = Pattern.compile("\\s+(at\\s+)?([\\w.$_]+/)?[\\w.$_]+\\.[\\w$_ =+'-<>]+\\(.+?\\)(\\x1B\\[0K)?");
    private static final Pattern BUILD_RESULT_PATTERN = Pattern.compile("BUILD (SUCCESSFUL|FAILED)( in \\d+(ms|s|m|h)( \\d+(ms|s|m|h))*)?");
    private static final Pattern DOCUMENTATION_URL_PATTERN = Pattern.compile("https://docs.gradle.org/((\\d+.\\d+(.\\d+)?(-\\d+\\+0000)?)|current|nightly)/");
    private static final Pattern BUILD_SCAN_URL_PATTERN = Pattern.compile("https://gradle.com/s/([a-z0-9]+)");
    public static final String DOWNLOAD_MESSAGE_PREFIX = "Download ";
    public static final String GENERATING_JAR_PREFIX = "Generating JAR file 'gradle-api-";
    public static final String DOWNLOADING_WRAPPER_MESSAGE_PREFIX = "Downloading https://services.gradle.org/distributions";
    public static final String DOWNLOADING_WRAPPER_PROGRESS_PREFIX = ".........10%";
    public static final String INCUBATING_FEATURE_SUFFIX = "incubating feature.";
    public static final String STARTING_A_GRADLE_DAEMON_MESSAGE = "Starting a Gradle Daemon";
    public static final String DAEMON_WILL_BE_STOPPED_MESSAGE = "Daemon will be stopped at the end of the build";
    public static final String EXPIRING_DAEMON_MESSAGE = "Expiring Daemon because JVM Tenured space is exhausted";
    public static final String DEPRECATED_GRADLE_FEATURES_MESSAGE = "Deprecated Gradle features were used in this build, making it incompatible with Gradle";
    public static final String JAVA_7_DEPRECATION_MESSAGE = "Support for running Gradle using Java 7 has been deprecated and is scheduled to be removed in Gradle 5.0.";

    @Override
    public String normalize(String commandOutput, ExecutionMetadata executionMetadata) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = Arrays.asList(commandOutput.split("\\r?\\n", -1));
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.startsWith(GENERATING_JAR_PREFIX)) {
                ++i;
                continue;
            }
            if (line.startsWith(DOWNLOAD_MESSAGE_PREFIX)) {
                ++i;
                continue;
            }
            if (line.startsWith(DOWNLOADING_WRAPPER_MESSAGE_PREFIX)) {
                ++i;
                continue;
            }
            if (line.startsWith(DOWNLOADING_WRAPPER_PROGRESS_PREFIX)) {
                ++i;
                continue;
            }
            if (line.endsWith(INCUBATING_FEATURE_SUFFIX)) {
                ++i;
                continue;
            }
            if (line.contains(STARTING_A_GRADLE_DAEMON_MESSAGE)) {
                ++i;
                continue;
            }
            if (line.contains(DAEMON_WILL_BE_STOPPED_MESSAGE)) {
                ++i;
                continue;
            }
            if (line.contains(EXPIRING_DAEMON_MESSAGE)) {
                ++i;
                continue;
            }
            if (line.contains(DEPRECATED_GRADLE_FEATURES_MESSAGE)) {
                i += 2;
                continue;
            }
            if (line.contains(JAVA_7_DEPRECATION_MESSAGE)) {
                ++i;
                while (i < lines.size() && STACK_TRACE_ELEMENT.matcher(lines.get(i)).matches()) {
                    ++i;
                }
                continue;
            }
            if (BUILD_RESULT_PATTERN.matcher(line).matches()) {
                result.add(BUILD_RESULT_PATTERN.matcher(line).replaceFirst("BUILD $1 in 0s"));
                ++i;
                continue;
            }
            if (DOCUMENTATION_URL_PATTERN.matcher(line).find()) {
                line = DOCUMENTATION_URL_PATTERN.matcher(line).replaceFirst("https://docs.gradle.org/0.0.0/");
            } else if (BUILD_SCAN_URL_PATTERN.matcher(line).find()) {
                line = BUILD_SCAN_URL_PATTERN.matcher(line).replaceFirst("https://gradle.com/s/feeedfooc00de");
            }
            result.add(line);
            ++i;
        }
        return StringUtils.join(result, (String)"\n");
    }
}

