/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.rule;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.exemplar.test.rule.UsesSample;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Sample
implements TestRule {
    private final SourceSampleDirSupplier sourceSampleDirSupplier;
    private TargetBaseDirSupplier targetBaseDirSupplier;
    private String defaultSampleName;
    private String sampleName;
    private File targetDir;

    public static Sample from(final String sourceBaseDirPath) {
        return Sample.from(new SourceSampleDirSupplier(){

            @Override
            public File getDir(String sampleName) {
                return new File(sourceBaseDirPath, sampleName);
            }
        });
    }

    public static Sample from(SourceSampleDirSupplier sourceSampleDirSupplier) {
        return new Sample(sourceSampleDirSupplier);
    }

    private Sample(SourceSampleDirSupplier sourceSampleDirSupplier) {
        this.sourceSampleDirSupplier = sourceSampleDirSupplier;
    }

    @Deprecated
    public Sample into(final TemporaryFolder temporaryFolder) {
        return this.into(new TargetBaseDirSupplier(){

            @Override
            public File getDir() {
                try {
                    return temporaryFolder.newFolder("samples");
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create samples target base dir", e);
                }
            }
        });
    }

    public Sample intoTemporaryFolder() {
        return this.intoTemporaryFolder(null);
    }

    public Sample intoTemporaryFolder(File parentFolder) {
        return this.into(new ManagedTemporaryFolder(parentFolder));
    }

    public Sample into(TargetBaseDirSupplier targetBaseDirSupplier) {
        this.targetBaseDirSupplier = targetBaseDirSupplier;
        return this;
    }

    public Sample withDefaultSample(String name) {
        this.defaultSampleName = name;
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        if (this.targetBaseDirSupplier == null) {
            this.intoTemporaryFolder();
        }
        this.sampleName = this.getSampleName(description);
        return new Statement(){

            public void evaluate() throws Throwable {
                Assert.assertNotNull((String)"No sample selected. Please use @UsesSample or withDefaultSample()", (Object)Sample.this.sampleName);
                try {
                    File srcDir = Sample.this.sourceSampleDirSupplier.getDir(Sample.this.sampleName);
                    FileUtils.copyDirectory((File)srcDir, (File)Sample.this.getDir());
                    base.evaluate();
                }
                finally {
                    if (Sample.this.targetBaseDirSupplier instanceof Closeable) {
                        ((Closeable)((Object)Sample.this.targetBaseDirSupplier)).close();
                    }
                }
            }
        };
    }

    private String getSampleName(Description description) {
        UsesSample annotation = (UsesSample)description.getAnnotation(UsesSample.class);
        return annotation != null ? annotation.value() : this.defaultSampleName;
    }

    public File getDir() {
        if (this.targetDir == null) {
            this.targetDir = this.computeSampleDir();
        }
        return this.targetDir;
    }

    private File computeSampleDir() {
        String subDirName = this.getSampleTargetDirName();
        return new File(this.targetBaseDirSupplier.getDir(), subDirName);
    }

    private String getSampleTargetDirName() {
        if (this.sampleName == null) {
            throw new IllegalStateException("This rule hasn't been applied, yet.");
        }
        return this.sampleName;
    }

    private static class ManagedTemporaryFolder
    implements TargetBaseDirSupplier,
    Closeable {
        private final TemporaryFolder temporaryFolder;

        public ManagedTemporaryFolder(File parentFolder) {
            this.temporaryFolder = new TemporaryFolder(parentFolder);
        }

        @Override
        public File getDir() {
            try {
                this.temporaryFolder.create();
                return this.temporaryFolder.getRoot();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create samples target base dir", e);
            }
        }

        @Override
        public void close() {
            this.temporaryFolder.delete();
        }
    }

    public static interface TargetBaseDirSupplier {
        public File getDir();
    }

    public static interface SourceSampleDirSupplier {
        public File getDir(String var1);
    }
}

