/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.verifier;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.gradle.exemplar.test.verifier.OutputVerifier;
import org.junit.Assert;

public class AnyOrderLineSegmentedOutputVerifier
implements OutputVerifier {
    private static final String NEWLINE = System.getProperty("line.separator");

    @Override
    public void verify(String expected, String actual, boolean allowAdditionalOutput) {
        LinkedList<String> expectedLines = new LinkedList<String>(Arrays.asList(expected.replaceAll("(\\r?\\n)+", "\n").split("\\r?\\n")));
        LinkedList<String> unmatchedLines = new LinkedList<String>(Arrays.asList(actual.replaceAll("(\\r?\\n)+", "\n").split("\\r?\\n")));
        for (String expectedLine : expectedLines) {
            String matchedLine = null;
            for (String unmatchedLine : unmatchedLines) {
                if (!unmatchedLine.equals(expectedLine)) continue;
                matchedLine = unmatchedLine;
            }
            if (matchedLine != null) {
                unmatchedLines.remove(matchedLine);
                continue;
            }
            Assert.fail((String)String.format("Line missing from output.%n%s%n---%nActual output:%n%s%n---", expectedLine, actual));
        }
        if (!allowAdditionalOutput && !unmatchedLines.isEmpty()) {
            String unmatched = StringUtils.join(unmatchedLines, (String)NEWLINE);
            Assert.fail((String)String.format("Extra lines in output.%n%s%n---%nActual output:%n%s%n---", unmatched, actual));
        }
    }
}

