/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.executor;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.exemplar.executor.CommandExecutor;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.GradleRunner;

public class GradleRunnerCommandExecutor
extends CommandExecutor {
    private final File workingDir;
    private final File customGradleInstallation;
    private final boolean expectFailure;

    public GradleRunnerCommandExecutor(File workingDir, @Nullable File customGradleInstallation, boolean expectFailure) {
        this.workingDir = workingDir;
        this.customGradleInstallation = customGradleInstallation;
        this.expectFailure = expectFailure;
    }

    @Override
    protected int run(String executable, List<String> args, List<String> flags, OutputStream output) {
        ArrayList<String> allArguments = new ArrayList<String>(args);
        allArguments.addAll(flags);
        GradleRunner gradleRunner = GradleRunner.create().withProjectDir(this.workingDir).withArguments(allArguments).forwardOutput();
        if (this.customGradleInstallation != null) {
            gradleRunner.withGradleInstallation(this.customGradleInstallation);
        }
        OutputStreamWriter mergedOutput = new OutputStreamWriter(output);
        try {
            BuildResult buildResult = this.expectFailure ? gradleRunner.buildAndFail() : gradleRunner.build();
            mergedOutput.write(buildResult.getOutput());
            ((Writer)mergedOutput).close();
            int n = this.expectFailure ? 1 : 0;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute " + executable, e);
        }
        finally {
            IOUtils.closeQuietly((Writer)mergedOutput);
        }
    }
}

