/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.verifier;

import java.util.Arrays;
import java.util.List;
import org.gradle.exemplar.test.verifier.OutputVerifier;
import org.junit.Assert;

public class StrictOrderLineSegmentedOutputVerifier
implements OutputVerifier {
    @Override
    public void verify(String expected, String actual, boolean allowAdditionalOutput) {
        List<String> expectedLines = Arrays.asList(expected.split("\\r?\\n"));
        List<String> actualLines = Arrays.asList(actual.split("\\r?\\n"));
        int expectedIndex = 0;
        int actualIndex = 0;
        if (allowAdditionalOutput) {
            actualIndex = this.findFirstMatchingLine(actualLines, expectedLines.get(expectedIndex));
        }
        while (actualIndex < actualLines.size() && expectedIndex < expectedLines.size()) {
            String actualLine;
            String expectedLine = expectedLines.get(expectedIndex);
            if (!expectedLine.equals(actualLine = actualLines.get(actualIndex))) {
                if (expectedLine.contains(actualLine)) {
                    Assert.fail((String)String.format("Missing text at line %d.%nExpected: %s%nActual: %s%nActual output:%n%s%n", actualIndex + 1, expectedLine, actualLine, actual));
                }
                if (actualLine.contains(expectedLine)) {
                    Assert.fail((String)String.format("Extra text at line %d.%nExpected: %s%nActual: %s%nActual output:%n%s%n", actualIndex + 1, expectedLine, actualLine, actual));
                }
                Assert.fail((String)String.format("Unexpected value at line %d.%nExpected: %s%nActual: %s%nActual output:%n%s%n", actualIndex + 1, expectedLine, actualLine, actual));
            }
            ++actualIndex;
            ++expectedIndex;
        }
        if (actualIndex == actualLines.size() && expectedIndex < expectedLines.size()) {
            Assert.fail((String)String.format("Lines missing from actual result, starting at expected line %d.%nExpected: %s%nActual output:%n%s%n", expectedIndex, expectedLines.get(expectedIndex), actual));
        }
        if (!allowAdditionalOutput && actualIndex < actualLines.size() && expectedIndex == expectedLines.size()) {
            Assert.fail((String)String.format("Extra lines in actual result, starting at line %d.%nActual: %s%nActual output:%n%s%n", actualIndex + 1, actualLines.get(actualIndex), actual));
        }
    }

    private int findFirstMatchingLine(List<String> actualLines, String expected) {
        for (int index = 0; index < actualLines.size(); ++index) {
            if (!actualLines.get(index).equals(expected)) continue;
            return index;
        }
        return actualLines.size();
    }
}

