/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.EventSettings;
import jdk.jfr.RecordingState;

public final class Recording
implements Closeable {
    private final Map<String, String> settings;

    public Recording(Map<String, String> settings) {
        this.settings = new HashMap<String, String>(settings);
    }

    public Recording() {
        this(new HashMap<String, String>());
    }

    public Recording(Configuration configuration) {
        this(configuration.getSettings());
    }

    public void start() {
    }

    public void scheduleStart(Duration delay) {
        Objects.requireNonNull(delay);
    }

    public boolean stop() {
        return true;
    }

    public Map<String, String> getSettings() {
        return new HashMap<String, String>(this.settings);
    }

    public long getSize() {
        return 0L;
    }

    public Instant getStopTime() {
        return null;
    }

    public Instant getStartTime() {
        return null;
    }

    public long getMaxSize() {
        return 0L;
    }

    public Duration getMaxAge() {
        return null;
    }

    public String getName() {
        return "dummyRecording";
    }

    public void setSettings(Map<String, String> settings) {
        Objects.requireNonNull(settings);
        this.settings.clear();
        this.settings.putAll(settings);
    }

    public RecordingState getState() {
        return RecordingState.CLOSED;
    }

    @Override
    public void close() {
    }

    public Recording copy(boolean stop) {
        return new Recording(this.settings);
    }

    public void dump(Path destination) throws IOException {
        Objects.requireNonNull(destination);
        Files.createFile(destination, new FileAttribute[0]);
    }

    public boolean isToDisk() {
        return false;
    }

    public void setMaxSize(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("Max size of recording can't be negative");
        }
    }

    public void setMaxAge(Duration maxAge) {
        if (maxAge != null && maxAge.isNegative()) {
            throw new IllegalArgumentException("Max age of recording can't be negative");
        }
    }

    public void setDestination(Path destination) throws IOException {
    }

    public Path getDestination() {
        return null;
    }

    public long getId() {
        return 42L;
    }

    public void setName(String name) {
        Objects.requireNonNull(name);
    }

    public void setDumpOnExit(boolean dumpOnExit) {
    }

    public boolean getDumpOnExit() {
        return false;
    }

    public void setToDisk(boolean disk) {
    }

    public InputStream getStream(Instant start, Instant end) throws IOException {
        if (start != null && end != null && end.isBefore(start)) {
            throw new IllegalArgumentException("End time of requested stream must not be before start time");
        }
        return null;
    }

    public Duration getDuration() {
        return null;
    }

    public void setDuration(Duration duration) {
    }

    public EventSettings enable(String name) {
        Objects.requireNonNull(name);
        return DummyEventSettings.INSTANCE;
    }

    public EventSettings disable(String name) {
        Objects.requireNonNull(name);
        return DummyEventSettings.INSTANCE;
    }

    public EventSettings enable(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        return DummyEventSettings.INSTANCE;
    }

    public EventSettings disable(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        return DummyEventSettings.INSTANCE;
    }

    private static class DummyEventSettings
    extends EventSettings {
        static final DummyEventSettings INSTANCE = new DummyEventSettings();

        private DummyEventSettings() {
        }

        @Override
        public EventSettings with(String name, String value) {
            return this;
        }

        @Override
        Map<String, String> toMap() {
            return Collections.emptyMap();
        }
    }
}

