/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.id;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;

public class GradoopId
implements NormalizableKey<GradoopId>,
CopyableValue<GradoopId> {
    public static final int ID_SIZE = 12;
    public static final GradoopId NULL_VALUE = new GradoopId(0, 0, 0, 0);
    private static final int MACHINE_IDENTIFIER;
    private static final short PROCESS_IDENTIFIER;
    private static final AtomicInteger NEXT_COUNTER;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int HIGH_ORDER_ONE_BYTE = -16777216;
    private static final char[] HEX_CHARS;
    private byte[] bytes;

    public GradoopId() {
        this.bytes = new byte[12];
    }

    private GradoopId(byte[] bytes) {
        this.bytes = bytes;
    }

    public GradoopId(int timestamp, int machineIdentifier, short processIdentifier, int counter) {
        this(timestamp, machineIdentifier, processIdentifier, counter, true);
    }

    private GradoopId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if ((machineIdentifier & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.put((byte)(timestamp >> 24));
        buffer.put((byte)(timestamp >> 16));
        buffer.put((byte)(timestamp >> 8));
        buffer.put((byte)timestamp);
        buffer.put((byte)(machineIdentifier >> 16));
        buffer.put((byte)(machineIdentifier >> 8));
        buffer.put((byte)machineIdentifier);
        buffer.put((byte)(processIdentifier >> 8));
        buffer.put((byte)processIdentifier);
        buffer.put((byte)(counter >> 16));
        buffer.put((byte)(counter >> 8));
        buffer.put((byte)counter);
        this.bytes = buffer.array();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (SocketException t) {
            machinePiece = new SecureRandom().nextInt();
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        short processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        return processId;
    }

    public static GradoopId get() {
        return new GradoopId(GradoopId.dateToTimestampSeconds(new Date()), MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    public static GradoopId fromString(String string) {
        if (!GradoopId.isValid(string)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of a GradoopId: [" + string + "]");
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return new GradoopId(b);
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static GradoopId fromByteArray(byte[] bytes) {
        return new GradoopId(bytes);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        byte[] firstBytes = this.bytes;
        byte[] secondBytes = ((GradoopId)o).bytes;
        for (int i = 0; i < 12; ++i) {
            if (firstBytes[i] == secondBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getTimeStamp();
        result = 31 * result + this.getMachineIdentifier();
        result = 31 * result + this.getProcessIdentifier();
        result = 31 * result + this.getCounter();
        return result;
    }

    public int compareTo(GradoopId other) {
        for (int i = 0; i < 12; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return (this.bytes[i] & 0xFF) < (other.bytes[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        char[] chars = new char[24];
        int i = 0;
        for (byte b : this.bytes) {
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
        }
        return String.valueOf(chars);
    }

    public int getMaxNormalizedKeyLen() {
        return 12;
    }

    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        target.put(offset, this.bytes, 0, len);
    }

    public void write(DataOutputView out) throws IOException {
        out.write(this.bytes);
    }

    public void read(DataInputView in) throws IOException {
        in.readFully(this.bytes);
    }

    public int getBinaryLength() {
        return 12;
    }

    public void copyTo(GradoopId target) {
        target.bytes = this.bytes;
    }

    public GradoopId copy() {
        return new GradoopId(this.bytes);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 12);
    }

    private int getTimeStamp() {
        return GradoopId.makeInt(this.bytes[0], this.bytes[1], this.bytes[2], this.bytes[3]);
    }

    private int getMachineIdentifier() {
        return GradoopId.makeInt((byte)0, this.bytes[4], this.bytes[5], this.bytes[6]);
    }

    private short getProcessIdentifier() {
        return (short)GradoopId.makeInt((byte)0, (byte)0, this.bytes[7], this.bytes[8]);
    }

    private int getCounter() {
        return GradoopId.makeInt((byte)0, this.bytes[9], this.bytes[10], this.bytes[11]);
    }

    public static GradoopId min(GradoopId first, GradoopId second) {
        int comparison = first.compareTo(second);
        return comparison == 0 ? first : (comparison < 0 ? first : second);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MACHINE_IDENTIFIER = GradoopId.createMachineIdentifier();
        PROCESS_IDENTIFIER = GradoopId.createProcessIdentifier();
    }
}

