/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.id;

import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.gradoop.common.model.impl.id.GradoopId;

public class GradoopIdSet
extends AbstractSet<GradoopId>
implements Value {
    private Set<GradoopId> ids;

    public GradoopIdSet() {
        this.ids = new HashSet<GradoopId>();
    }

    private GradoopIdSet(byte[] bytes) {
        this.ids = this.readIds(bytes);
    }

    private GradoopIdSet(Collection<GradoopId> ids) {
        this.ids = new HashSet<GradoopId>(ids);
    }

    private Set<GradoopId> readIds(byte[] bytes) {
        this.ids = new HashSet<GradoopId>();
        for (int i = 0; i < bytes.length / 12; ++i) {
            byte[] idBytes = new byte[12];
            System.arraycopy(bytes, i * 12, idBytes, 0, 12);
            this.ids.add(GradoopId.fromByteArray(idBytes));
        }
        return this.ids;
    }

    private byte[] writeIds(Set<GradoopId> ids) {
        byte[] bytes = new byte[ids.size() * 12];
        int i = 0;
        for (GradoopId id : ids) {
            System.arraycopy(id.toByteArray(), 0, bytes, i * 12, 12);
            ++i;
        }
        return bytes;
    }

    public static GradoopIdSet fromExisting(GradoopId ... ids) {
        return GradoopIdSet.fromExisting(Arrays.asList(ids));
    }

    public static GradoopIdSet fromExisting(Collection<GradoopId> ids) {
        return new GradoopIdSet(ids);
    }

    public static GradoopIdSet fromByteArray(byte[] bytes) {
        return new GradoopIdSet(bytes);
    }

    @Override
    public boolean add(GradoopId id) {
        return this.ids.add(id);
    }

    public void addAll(GradoopIdSet ids) {
        this.ids.addAll(ids.ids);
    }

    @Override
    public boolean addAll(Collection<? extends GradoopId> ids) {
        return this.ids.addAll(ids);
    }

    @Override
    public boolean contains(Object identifier) {
        return this.ids.contains(identifier);
    }

    public boolean containsAll(GradoopIdSet other) {
        if (other.size() > this.size()) {
            return false;
        }
        for (GradoopId id : other) {
            if (this.contains(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> other) {
        if (other instanceof Set && other.size() > this.size()) {
            return false;
        }
        for (Object id : other) {
            if (this.contains(id)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(GradoopIdSet other) {
        int otherSize;
        Set<GradoopId> iterate = this.ids;
        Set<GradoopId> contains = other.ids;
        int thisSize = this.size();
        if (thisSize > (otherSize = other.size())) {
            iterate = other.ids;
            contains = this.ids;
        }
        for (GradoopId id : iterate) {
            if (!contains.contains(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Set<GradoopId> other) {
        int otherSize;
        Set<GradoopId> iterate = this.ids;
        Set<GradoopId> contains = other;
        int thisSize = this.size();
        if (thisSize > (otherSize = other.size())) {
            iterate = other;
            contains = this.ids;
        }
        for (GradoopId id : iterate) {
            if (!contains.contains(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    @Override
    public Iterator<GradoopId> iterator() {
        return this.ids.iterator();
    }

    @Override
    public void clear() {
        this.ids.clear();
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    public byte[] toByteArray() {
        return this.writeIds(this.ids);
    }

    public void write(DataOutputView out) throws IOException {
        if (this.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.size());
            out.write(this.writeIds(this.ids));
        }
    }

    public void read(DataInputView in) throws IOException {
        int n = in.readInt();
        byte[] bytes = new byte[n * 12];
        in.readFully(bytes);
        this.ids = this.readIds(bytes);
    }

    @Override
    public boolean equals(Object o) {
        boolean equal;
        boolean bl = equal = this == o;
        if (!equal && o instanceof GradoopIdSet) {
            GradoopIdSet that = (GradoopIdSet)o;
            boolean bl2 = equal = this.size() == that.size();
            if (equal) {
                equal = this.ids.equals(that.ids);
            }
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return this.ids.hashCode();
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        Iterator<GradoopId> it = this.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            GradoopId id = it.next();
            sb.append(id);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

