/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.metadata;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.metadata.PropertyMetaData;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.Type;

public class MetaData {
    public static final String PROPERTY_TOKEN_DELIMITER = ":";
    private static Map<String, Class<?>> TYPE_STRING_TO_CLASS_MAP = MetaData.createStringToClassMap();
    protected Map<String, List<PropertyMetaData>> graphMetaData;
    protected Map<String, List<PropertyMetaData>> vertexMetaData;
    protected Map<String, List<PropertyMetaData>> edgeMetaData;

    protected MetaData(Map<String, List<PropertyMetaData>> graphMetaData, Map<String, List<PropertyMetaData>> vertexMetaData, Map<String, List<PropertyMetaData>> edgeMetaData) {
        this.graphMetaData = graphMetaData;
        this.vertexMetaData = vertexMetaData;
        this.edgeMetaData = edgeMetaData;
    }

    public static Class<?> getClassFromTypeString(String typeString) {
        String prunedTypeString = typeString.split(PROPERTY_TOKEN_DELIMITER)[0];
        return TYPE_STRING_TO_CLASS_MAP.get(prunedTypeString);
    }

    private static Map<String, Class<?>> createStringToClassMap() {
        HashMap<String, Class<Set>> stringClassMap = new HashMap<String, Class<Set>>();
        stringClassMap.put(Type.NULL.toString(), null);
        stringClassMap.put(Type.SHORT.toString(), Short.class);
        stringClassMap.put(Type.INTEGER.toString(), Integer.class);
        stringClassMap.put(Type.LONG.toString(), Long.class);
        stringClassMap.put(Type.FLOAT.toString(), Float.class);
        stringClassMap.put(Type.DOUBLE.toString(), Double.class);
        stringClassMap.put(Type.BOOLEAN.toString(), Boolean.class);
        stringClassMap.put(Type.STRING.toString(), String.class);
        stringClassMap.put(Type.BIG_DECIMAL.toString(), BigDecimal.class);
        stringClassMap.put(Type.GRADOOP_ID.toString(), GradoopId.class);
        stringClassMap.put(Type.MAP.toString(), Map.class);
        stringClassMap.put(Type.LIST.toString(), List.class);
        stringClassMap.put(Type.DATE.toString(), LocalDate.class);
        stringClassMap.put(Type.TIME.toString(), LocalTime.class);
        stringClassMap.put(Type.DATE_TIME.toString(), LocalDateTime.class);
        stringClassMap.put(Type.SET.toString(), Set.class);
        return Collections.unmodifiableMap(stringClassMap);
    }

    public Set<String> getGraphLabels() {
        return this.graphMetaData.keySet();
    }

    public Set<String> getVertexLabels() {
        return this.vertexMetaData.keySet();
    }

    public Set<String> getEdgeLabels() {
        return this.edgeMetaData.keySet();
    }

    public List<PropertyMetaData> getGraphPropertyMetaData(String label) {
        return this.graphMetaData.getOrDefault(label, new ArrayList());
    }

    public List<PropertyMetaData> getVertexPropertyMetaData(String label) {
        return this.vertexMetaData.getOrDefault(label, new ArrayList());
    }

    public List<PropertyMetaData> getEdgePropertyMetaData(String label) {
        return this.edgeMetaData.getOrDefault(label, new ArrayList());
    }

    public static String getTypeString(PropertyValue propertyValue) {
        if (propertyValue.isNull()) {
            return Type.NULL.toString();
        }
        if (propertyValue.isShort()) {
            return Type.SHORT.toString();
        }
        if (propertyValue.isInt()) {
            return Type.INTEGER.toString();
        }
        if (propertyValue.isLong()) {
            return Type.LONG.toString();
        }
        if (propertyValue.isFloat()) {
            return Type.FLOAT.toString();
        }
        if (propertyValue.isDouble()) {
            return Type.DOUBLE.toString();
        }
        if (propertyValue.isBoolean()) {
            return Type.BOOLEAN.toString();
        }
        if (propertyValue.isString()) {
            return Type.STRING.toString();
        }
        if (propertyValue.isBigDecimal()) {
            return Type.BIG_DECIMAL.toString();
        }
        if (propertyValue.isGradoopId()) {
            return Type.GRADOOP_ID.toString();
        }
        if (propertyValue.isMap()) {
            return Type.MAP.toString() + PROPERTY_TOKEN_DELIMITER + MetaData.getTypeString(propertyValue.getMap().keySet().iterator().next()) + PROPERTY_TOKEN_DELIMITER + MetaData.getTypeString(propertyValue.getMap().values().iterator().next());
        }
        if (propertyValue.isList()) {
            return Type.LIST.toString() + PROPERTY_TOKEN_DELIMITER + MetaData.getTypeString(propertyValue.getList().get(0));
        }
        if (propertyValue.isDate()) {
            return Type.DATE.toString();
        }
        if (propertyValue.isTime()) {
            return Type.TIME.toString();
        }
        if (propertyValue.isDateTime()) {
            return Type.DATE_TIME.toString();
        }
        if (propertyValue.isSet()) {
            return Type.SET.toString() + PROPERTY_TOKEN_DELIMITER + MetaData.getTypeString(propertyValue.getSet().iterator().next());
        }
        throw new IllegalArgumentException("Type " + propertyValue.getType() + " is not supported");
    }
}

