/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.pojo;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.common.model.impl.properties.PropertyValue;

public abstract class EPGMElement
implements Element {
    protected GradoopId id;
    protected String label;
    protected Properties properties;

    protected EPGMElement() {
    }

    protected EPGMElement(GradoopId id, String label, Properties properties) {
        this.id = id;
        this.label = label;
        this.properties = properties;
    }

    @Override
    public GradoopId getId() {
        return this.id;
    }

    @Override
    public void setId(GradoopId id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    @Nullable
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.properties != null ? this.properties.getKeys() : null;
    }

    @Override
    public PropertyValue getPropertyValue(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setProperty(Property property) {
        Preconditions.checkNotNull((Object)property, (Object)"Property was null");
        this.initProperties();
        this.properties.set(property);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.initProperties();
        this.properties.set(key, value);
    }

    @Override
    public void setProperty(String key, PropertyValue value) {
        this.initProperties();
        this.properties.set(key, value);
    }

    @Override
    public PropertyValue removeProperty(String key) {
        return this.properties != null ? this.properties.remove(key) : null;
    }

    @Override
    public int getPropertyCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EPGMElement that = (EPGMElement)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s%s%s{%s}", this.id, this.label == null || this.label.equals("") ? "" : ":", this.label, this.properties == null ? "" : this.properties);
    }

    private void initProperties() {
        if (this.properties == null) {
            this.properties = Properties.create();
        }
    }
}

